/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.Constraint;
import constraints.TupleManager;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.Table;
import constraints.extension.structures.Tries;
import interfaces.FilteringSpecific;
import interfaces.Observers;
import interfaces.Tags;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import propagation.Supporter;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public abstract class Extension
extends Constraint
implements Tags.TagAC,
Tags.TagFilteringCompleteAtEachCall {
    public ExtensionStructure extStructure;

    private static Extension build(Problem pb, Variable[] scp, boolean positive, boolean presentStar) {
        Kit.control(scp.length > 1);
        Set<Class<?>> classes = pb.head.handlerClasses.map.get(Extension.class);
        if (presentStar) {
            Kit.control(positive);
            String name = pb.head.control.extension.positive.toString();
            Extension c = (Extension)Reflector.buildObject(name.equals("V") || name.equals("VA") ? "Extension" + name : name, classes, pb, scp);
            Kit.control(c instanceof Tags.TagStarred);
            return c;
        }
        if (scp.length == 2 && pb.head.control.extension.validForBinary) {
            return new ExtensionGeneric.ExtensionV(pb, scp);
        }
        String name = (positive ? pb.head.control.extension.positive : pb.head.control.extension.negative).toString();
        return (Extension)Reflector.buildObject(name.equals("V") || name.equals("VA") ? "Extension" + name : name, classes, pb, scp);
    }

    private static int[][] reverseTuples(Variable[] variables, int[][] tuples) {
        Kit.control(Variable.areDomainsFull(variables));
        assert (Kit.isLexIncreasing(tuples));
        int cnt = 0;
        TupleManager tupleManager = new TupleManager(variables);
        int[] idxs = tupleManager.firstValidTuple();
        int[] vals = new int[idxs.length];
        ArrayList<int[]> list = new ArrayList<int[]>();
        do {
            for (int i = vals.length - 1; i >= 0; --i) {
                vals[i] = variables[i].dom.toVal(idxs[i]);
            }
            if (cnt < tuples.length && Arrays.equals(vals, tuples[cnt])) {
                ++cnt;
                continue;
            }
            list.add((int[])vals.clone());
        } while (tupleManager.nextValidTuple() != -1);
        return Kit.intArray2D(list);
    }

    private static boolean isStarPresent(Object tuples) {
        return tuples instanceof int[][] ? Kit.isPresent(0x7FFFFFFE, (int[][])tuples) : Kit.isPresent("*", (String[][])tuples);
    }

    public static Constraint build(Problem pb, Variable[] scp, Object tuples, boolean positive, Boolean starred) {
        int[][] m;
        Kit.control(scp.length > 1 && Variable.haveSameType(scp));
        Kit.control(Array.getLength(tuples) == 0 || Array.getLength(Array.get(tuples, 0)) == scp.length, () -> "Badly formed extensional constraint " + scp.length + " " + Array.getLength(Array.get(tuples, 0)));
        if (starred == null) {
            starred = Extension.isStarPresent(tuples);
        } else assert (starred == Extension.isStarPresent(tuples)) : starred + " \n" + Kit.join(tuples, new String[0]);
        int[][] nArray = m = scp[0] instanceof Variable.VariableSymbolic ? pb.symbolic.replaceSymbols((String[][])tuples) : (int[][])tuples;
        if (scp[0] instanceof Variable.VariableInteger && !starred.booleanValue() && pb.head.control.extension.mustReverse(scp.length, positive)) {
            m = Extension.reverseTuples(scp, m);
            positive = !positive;
        }
        Extension c = Extension.build(pb, scp, positive, starred);
        c.storeTuples(m, positive);
        return c;
    }

    protected abstract ExtensionStructure buildExtensionStructure();

    @Override
    public ExtensionStructure extStructure() {
        return this.extStructure;
    }

    @Override
    public final boolean checkIndexes(int[] t) {
        return this.extStructure.checkIdxs(t);
    }

    @Override
    public final boolean checkValues(int[] t) {
        return this.checkIndexes(this.toIdxs(t, this.tupleManager.localTuple));
    }

    @Override
    public int[] symmetryMatching() {
        return this.extStructure.computeVariableSymmetryMatching(this);
    }

    public Extension(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    public void cloneStructures(boolean onlyConflictsStructure) {
        super.cloneStructures(onlyConflictsStructure);
        if (!onlyConflictsStructure && this.extStructure.registeredCtrs().size() > 1) {
            this.extStructure.unregister(this);
            this.extStructure = Reflector.buildObject(this.extStructure.getClass().getSimpleName(), ExtensionStructure.class, this, this.extStructure);
        }
    }

    public final void storeTuples(int[][] tuples, boolean positive) {
        String stuffKey = this.signature() + " " + tuples + " " + positive;
        this.key = this.problem.features.collectedTuples.computeIfAbsent(stuffKey, k -> this.signature() + "r" + this.problem.features.collectedTuples.size());
        this.control(positive && this instanceof Tags.TagPositive || !positive && this instanceof Tags.TagNegative || !(this instanceof Tags.TagPositive) && !(this instanceof Tags.TagNegative), positive + " " + this.getClass().getName());
        if (this.supporter != null) {
            ((Supporter.SupporterHard)this.supporter).reset();
        }
        Map<String, ExtensionStructure> map = this.problem.head.structureSharing.mapOfExtensionStructures;
        this.extStructure = map.get(this.key);
        if (this.extStructure == null) {
            this.extStructure = this.buildExtensionStructure();
            this.extStructure.originalTuples = (int[][])(this instanceof ExtensionGeneric || this.problem.head.control.problem.isSymmetryBreaking() ? tuples : null);
            this.extStructure.originalPositive = positive;
            this.extStructure.storeTuples(tuples, positive);
            map.put(this.key, this.extStructure);
        } else {
            this.extStructure.register(this);
            assert (this.indexesMatchValues == this.extStructure.firstRegisteredCtr().indexesMatchValues);
        }
    }

    boolean controlTuples(int[][] tuples) {
        return Stream.of(tuples).allMatch(t -> IntStream.range(0, ((int[])t).length).allMatch(i -> t[i] == 0x7FFFFFFE || this.scp[i].dom.presentValue(t[i])));
    }

    public static abstract class ExtensionGlobal
    extends Extension
    implements FilteringSpecific,
    Observers.ObserverBacktracking.ObserverBacktrackingSystematic {
        public ExtensionGlobal(Problem pb, Variable[] scp) {
            super(pb, scp);
        }
    }

    public static abstract class ExtensionGeneric
    extends Extension {
        public ExtensionGeneric(Problem pb, Variable[] scp) {
            super(pb, scp);
        }

        public static final class ExtensionVA
        extends ExtensionGeneric
        implements Tags.TagPositive {
            @Override
            protected ExtensionStructure buildExtensionStructure() {
                int variant = this.problem.head.control.extension.variant;
                assert (variant == 0 || variant == 1 || variant == 11);
                return variant == 0 ? new Table(this).withSubtables() : new Tries(this, variant == 11);
            }

            public ExtensionVA(Problem pb, Variable[] scp) {
                super(pb, scp);
            }

            private final boolean seekSupportVA(int x, int a, int[] tuple, boolean another) {
                int[] t;
                if (!another) {
                    this.tupleManager.firstValidTupleWith(x, a, tuple);
                } else if (this.tupleManager.nextValidTupleCautiously() == -1) {
                    return false;
                }
                while ((t = this.extStructure.nextSupport(x, a, tuple)) != tuple) {
                    if (t == null) {
                        return false;
                    }
                    Kit.copy(t, tuple);
                    if (this.isValid(tuple)) break;
                    if (this.tupleManager.nextValidTupleCautiously() != -1) continue;
                    return false;
                }
                return true;
            }

            @Override
            public final boolean seekFirstSupportWith(int x, int a, int[] buffer) {
                buffer[x] = a;
                return this.seekSupportVA(x, a, buffer, false);
            }
        }

        public static final class ExtensionV
        extends ExtensionGeneric {
            @Override
            protected ExtensionStructure buildExtensionStructure() {
                if (this.scp.length == 2) {
                    return Reflector.buildObject(this.problem.head.control.extension.classBinary, ExtensionStructure.class, this);
                }
                if (this.scp.length == 3) {
                    return Reflector.buildObject(this.problem.head.control.extension.classTernary, ExtensionStructure.class, this);
                }
                return new Table(this);
            }

            public ExtensionV(Problem pb, Variable[] scp) {
                super(pb, scp);
            }
        }
    }

    public static final class Extension1
    extends Constraint
    implements FilteringSpecific,
    Tags.TagAC,
    Tags.TagFilteringCompleteAtEachCall {
        final int[] values;
        final boolean positive;

        @Override
        public boolean checkValues(int[] t) {
            return Arrays.binarySearch(this.values, t[0]) >= 0 == this.positive;
        }

        public Extension1(Problem pb, Variable x, int[] values, boolean positive) {
            super(pb, new Variable[]{x});
            assert (values.length > 0 && Kit.isStrictlyIncreasing(values));
            this.values = values;
            this.positive = positive;
            this.key = this.signature() + " " + values + " " + positive;
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.positive && !this.scp[0].dom.removeValuesNotIn(this.values)) {
                return false;
            }
            if (!this.positive && !this.scp[0].dom.removeValuesIn(this.values)) {
                return false;
            }
            assert (this.scp[0].dom.size() > 0);
            return this.entailed();
        }
    }
}

