/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.Constraint;
import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.TableSmart;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import propagation.StrongConsistency;
import sets.SetDenseReversible;
import sets.SetSparse;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class CSmart
extends Extension.ExtensionGlobal
implements ICtr.ICtrSmart {
    private static final int UNINITIALIZED_VALUE = Integer.MAX_VALUE;
    protected int lastDepth;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    private boolean backtrack;
    public final TableSmart.SmartTuple[] smartTuples;
    protected SetDenseReversible set;
    public SetSparse[] unsupported;
    protected int sValSize;
    protected int[] sVal;
    protected int sSupSize;
    protected int[] sSup;
    protected long lastCallNode;

    public static Constraint buildAllEqual(Problem pb, Variable[] list) {
        TableSmart.SmartTuple st = new TableSmart.SmartTuple(IntStream.range(1, list.length).mapToObj(i -> XNodeParent.eq(list[0], list[i])).collect(Collectors.toList()));
        return new CSmart(pb, list, st);
    }

    public static Constraint buildNotAllEqual(Problem pb, Variable[] list) {
        TableSmart.SmartTuple[] sts = (TableSmart.SmartTuple[])IntStream.range(1, list.length).mapToObj(i -> new TableSmart.SmartTuple(XNodeParent.ne(list[0], list[i]))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, list, sts);
    }

    public static Constraint buildAtMost1(Problem pb, Variable[] list, Variable value) {
        Kit.control(!Kit.isPresent(value, list), () -> "Not handled for the moment");
        TableSmart.SmartTuple[] smartTuples = (TableSmart.SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new TableSmart.SmartTuple(IntStream.range(0, list.length).filter(j -> j != i).mapToObj(j -> XNodeParent.ne(value, list[j])).collect(Collectors.toList()))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{list, value})), smartTuples);
    }

    public static Constraint buildElement(Problem pb, Variable[] list, Variable index, Variable value) {
        Kit.control(index.dom.firstValue() == 0 && !Kit.isPresent(value, list), () -> "Not handled for the moment");
        TableSmart.SmartTuple[] sts = (TableSmart.SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new TableSmart.SmartTuple(XNodeParent.eq(index, i), XNodeParent.eq(list[i], value))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{list, index, value})), sts);
    }

    public static Constraint buildMinimum(Problem pb, Variable[] list, Variable min) {
        Kit.control(!Kit.isPresent(min, list), () -> "Not handled for the moment");
        TableSmart.SmartTuple[] smartTuples = (TableSmart.SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new TableSmart.SmartTuple(IntStream.range(0, list.length).mapToObj(j -> j != i ? XNodeParent.le(list[i], list[j]) : XNodeParent.eq(list[i], min)).collect(Collectors.toList()))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{list, min})), smartTuples);
    }

    public static Constraint buildMaximum(Problem pb, Variable[] list, Variable max) {
        Kit.control(!Kit.isPresent(max, list), () -> "Not handled for the moment");
        TableSmart.SmartTuple[] smartTuples = (TableSmart.SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new TableSmart.SmartTuple(IntStream.range(0, list.length).mapToObj(j -> j != i ? XNodeParent.ge(list[i], list[j]) : XNodeParent.eq(list[i], max)).collect(Collectors.toList()))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{list, max})), smartTuples);
    }

    public static Constraint buildLexicographicL(Problem pb, Variable[] t1, Variable[] t2, boolean strict) {
        Kit.control(t1.length == t2.length);
        TableSmart.SmartTuple[] smartTuples = (TableSmart.SmartTuple[])IntStream.range(0, t1.length).mapToObj(i -> new TableSmart.SmartTuple(IntStream.range(0, i + 1).mapToObj(j -> j < i ? XNodeParent.eq(t1[j], t2[j]) : (i == t1.length - 1 ? XNodeParent.le(t1[i], t2[i]) : XNodeParent.lt(t1[i], t2[i]))).collect(Collectors.toList()))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{t1, t2})), smartTuples);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable x2, int w1, int w2) {
        TableSmart.SmartTuple st1 = new TableSmart.SmartTuple(XNodeParent.ge(x2, XNodeParent.add(x1, w1)));
        TableSmart.SmartTuple st2 = new TableSmart.SmartTuple(XNodeParent.ge(x1, XNodeParent.add(x2, w2)));
        return new CSmart(pb, (Variable[])pb.vars(new Object[]{x1, x2}), st1, st2);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable y1, Variable x2, Variable y2, int w1, int h1, int w2, int h2) {
        TableSmart.SmartTuple st1 = new TableSmart.SmartTuple(XNodeParent.ge(x2, XNodeParent.add(x1, w1)));
        TableSmart.SmartTuple st2 = new TableSmart.SmartTuple(XNodeParent.ge(x1, XNodeParent.add(x2, w2)));
        TableSmart.SmartTuple st3 = new TableSmart.SmartTuple(XNodeParent.ge(y2, XNodeParent.add(y1, h1)));
        TableSmart.SmartTuple st4 = new TableSmart.SmartTuple(XNodeParent.ge(y1, XNodeParent.add(y2, h2)));
        return new CSmart(pb, (Variable[])pb.vars(new Object[]{x1, y1, x2, y2}), st1, st2, st3, st4);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable y1, Variable x2, Variable y2, Variable w1, Variable h1, Variable w2, Variable h2) {
        Kit.control(w1.dom.size() == 2 && h1.dom.size() == 2 && w2.dom.size() == 2 && h2.dom.size() == 2);
        TableSmart.SmartTuple st1 = new TableSmart.SmartTuple(XNodeParent.eq(w1, w1.dom.firstValue()), XNodeParent.ge(x2, XNodeParent.add(x1, w1.dom.firstValue())));
        TableSmart.SmartTuple st2 = new TableSmart.SmartTuple(XNodeParent.eq(w1, w1.dom.lastValue()), XNodeParent.ge(x2, XNodeParent.add(x1, w1.dom.lastValue())));
        TableSmart.SmartTuple st3 = new TableSmart.SmartTuple(XNodeParent.eq(w2, w2.dom.firstValue()), XNodeParent.ge(x1, XNodeParent.add(x2, w2.dom.firstValue())));
        TableSmart.SmartTuple st4 = new TableSmart.SmartTuple(XNodeParent.eq(w2, w2.dom.lastValue()), XNodeParent.ge(x1, XNodeParent.add(x2, w2.dom.lastValue())));
        TableSmart.SmartTuple st5 = new TableSmart.SmartTuple(XNodeParent.eq(h1, h1.dom.firstValue()), XNodeParent.ge(y2, XNodeParent.add(y1, h1.dom.firstValue())));
        TableSmart.SmartTuple st6 = new TableSmart.SmartTuple(XNodeParent.eq(h1, h1.dom.lastValue()), XNodeParent.ge(y2, XNodeParent.add(y1, h1.dom.lastValue())));
        TableSmart.SmartTuple st7 = new TableSmart.SmartTuple(XNodeParent.eq(h2, h2.dom.firstValue()), XNodeParent.ge(y1, XNodeParent.add(y2, h2.dom.firstValue())));
        TableSmart.SmartTuple st8 = new TableSmart.SmartTuple(XNodeParent.eq(h2, h2.dom.lastValue()), XNodeParent.ge(y1, XNodeParent.add(y2, h2.dom.lastValue())));
        return new CSmart(pb, (Variable[])pb.vars(new Object[]{x1, y1, x2, y2, w1, h1, w2, h2}), st1, st2, st3, st4, st5, st6, st7, st8);
    }

    public static Constraint buildDistinctVectors(Problem pb, Variable[] t1, Variable[] t2) {
        Kit.control(t1.length == t2.length);
        Variable[] tt1 = IntStream.range(0, t1.length).anyMatch(i -> t1[i] == t2[i]) ? (Variable[])IntStream.range(0, t1.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t1[i]).toArray(Variable[]::new) : t1;
        Variable[] tt2 = IntStream.range(0, t1.length).anyMatch(i -> t1[i] == t2[i]) ? (Variable[])IntStream.range(0, t1.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t2[i]).toArray(Variable[]::new) : t2;
        Kit.control(tt1.length == tt2.length);
        TableSmart.SmartTuple[] smartTuples = (TableSmart.SmartTuple[])IntStream.range(0, tt1.length).mapToObj(i -> new TableSmart.SmartTuple(XNodeParent.ne(tt1[i], tt2[i]))).toArray(TableSmart.SmartTuple[]::new);
        return new CSmart(pb, (Variable[])pb.distinctSorted((Variable[])pb.vars(new Object[]{tt1, tt2})), smartTuples);
    }

    protected void initRestorationStructuresBeforeFiltering() {
        int depth = this.problem.solver.depth();
        assert (depth >= this.lastDepth && this.lastDepth >= 0) : depth + " " + this.lastDepth;
        for (int i = this.lastDepth + 1; i <= depth; ++i) {
            System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.lastSizesStack[this.lastDepth].length);
        }
        this.lastSizes = this.lastSizesStack[depth];
        this.lastDepth = depth;
    }

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        this.set = new SetDenseReversible(this.smartTuples.length, this.problem.variables.length + 1);
        this.lastSizesStack = new int[this.problem.variables.length + 1][this.scp.length];
        Arrays.fill(this.lastSizesStack[0], Integer.MAX_VALUE);
    }

    @Override
    public void restoreBefore(int depth) {
        this.set.restoreLimitAtLevel(depth);
        this.lastDepth = Math.max(0, Math.min(this.lastDepth, depth - 1));
        this.backtrack = true;
    }

    public CSmart(Problem pb, Variable[] scp, TableSmart.SmartTuple ... smartTuples) {
        super(pb, scp);
        this.smartTuples = smartTuples;
        this.extStructure = this.buildExtensionStructure();
        this.unsupported = (SetSparse[])IntStream.range(0, scp.length).mapToObj(i -> new SetSparse(scp[i].dom.initSize(), true)).toArray(SetSparse[]::new);
        Stream.of(smartTuples).forEach(st -> st.attach(this));
        this.sVal = new int[scp.length];
        this.sSup = new int[scp.length];
    }

    @Override
    public ExtensionStructure buildExtensionStructure() {
        return new TableSmart(this, this.smartTuples);
    }

    protected void manageLastPastVariable() {
        if (this.lastCallNode != this.problem.solver.stats.nAssignments || this.problem.solver.propagation instanceof StrongConsistency) {
            int x;
            this.lastCallNode = this.problem.solver.stats.nAssignments;
            Variable lastPast = this.problem.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
            }
        }
    }

    protected void beforeFiltering() {
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVariable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            Domain dom = this.scp[x].dom;
            if (dom.size() == this.lastSizes[x]) {
                this.unsupported[x].limit = this.lastSizes[x] - 1;
            } else {
                this.unsupported[x].clear();
                int a = dom.first();
                while (a != -1) {
                    this.unsupported[x].add(a);
                    a = dom.next(a);
                }
                this.backtrack = false;
            }
            int domSize = dom.size();
            if (this.lastSizes[x] != domSize) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            this.sSup[this.sSupSize++] = x;
        }
    }

    protected boolean updateDomains() {
        for (int i = 0; i < this.sSupSize; ++i) {
            int x = this.sSup[i];
            assert (!this.unsupported[x].isEmpty());
            if (!this.scp[x].dom.remove(this.unsupported[x])) {
                return false;
            }
            this.unsupported[x].moveElementsAt(this.lastSizes[x] - 1);
            this.lastSizes[x] = this.scp[x].dom.size();
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int depth = this.problem.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            TableSmart.SmartTuple st = this.smartTuples[this.set.dense[i]];
            boolean valid = st.isValid(this.sVal, this.sValSize);
            if (valid) {
                this.sSupSize = st.collect(this.sSup, this.sSupSize);
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return this.updateDomains();
    }
}

