/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.MDDShort;
import interfaces.Tags;
import java.util.Arrays;
import problem.Problem;
import sets.SetSparseReversible;
import variables.Domain;
import variables.Variable;

public final class CMDDShort
extends Extension.ExtensionGlobal
implements Tags.TagPositive,
Tags.TagStarred {
    protected SetSparseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;
    protected int falseTimestamp = 1;
    protected int trueTimestamp = 1;
    protected int[] falseNodes;
    protected int[] trueNodes;
    protected int earlyCutoff;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        int nNodes = ((MDDShort)this.extStructure).nNodes();
        this.trueNodes = new int[nNodes];
        if (this.problem.head.control.extension.decremental) {
            this.set = new SetSparseReversible(nNodes, false, this.problem.variables.length + 1);
        } else {
            this.falseNodes = new int[nNodes];
        }
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
    }

    @Override
    public void restoreBefore(int depth) {
        if (this.set != null) {
            this.set.restoreLimitAtLevel(depth);
        } else {
            ++this.falseTimestamp;
        }
    }

    public CMDDShort(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(scp.length >= 1);
    }

    public CMDDShort(Problem pb, Variable[] scp, int[][] tuples) {
        this(pb, scp);
        this.storeTuples(tuples, true);
    }

    public CMDDShort(Problem pb, Variable[] scp, MDDShort.MDDNodeShort root) {
        this(pb, scp);
        this.extStructure = new MDDShort(this, root);
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new MDDShort(this);
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            int domSize = this.scp[x].dom.size();
            this.cnt += domSize;
            this.cnts[x] = domSize;
            Arrays.fill(this.ac[x], false);
        }
        ++this.trueTimestamp;
        this.earlyCutoff = this.scp.length;
    }

    private boolean manageSuccessfulExploration(int level, int a) {
        if (a == 0x7FFFFFFE) {
            Variable x = this.scp[level];
            if (x.isFuture()) {
                int b = x.dom.first();
                while (b != -1) {
                    if (!this.ac[level][b]) {
                        --this.cnt;
                        int n = level;
                        this.cnts[n] = this.cnts[n] - 1;
                        this.ac[level][b] = true;
                    }
                    b = x.dom.next(b);
                }
            }
            return false;
        }
        int cutoffVariant = this.problem.head.control.extension.variant;
        if (cutoffVariant == 2) {
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
            }
            return level >= this.earlyCutoff;
        }
        if (cutoffVariant == 1) {
            boolean b = false;
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                        b = true;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
                b = true;
            }
            return b;
        }
        assert (cutoffVariant == 0);
        if (this.scp[level].isFuture() && !this.ac[level][a]) {
            --this.cnt;
            int n = level;
            this.cnts[n] = this.cnts[n] - 1;
            this.ac[level][a] = true;
        }
        return false;
    }

    private boolean exploreMDD(MDDShort.MDDNodeShort node) {
        if (node == MDDShort.MDDNodeShort.nodeT || this.trueNodes[node.id] == this.trueTimestamp) {
            return true;
        }
        if (node == MDDShort.MDDNodeShort.nodeF || this.set != null && this.set.isPresent(node.id) || this.set == null && this.falseNodes[node.id] == this.falseTimestamp) {
            return false;
        }
        Domain dom = this.scp[node.level].dom;
        boolean supported = false;
        boolean finished = false;
        if (this.exploreMDD(node.sons[node.sons.length - 1])) {
            supported = true;
            this.manageSuccessfulExploration(node.level, 0x7FFFFFFE);
        }
        int a = dom.first();
        while (a != -1 && !finished) {
            if (this.exploreMDD(node.sons[a])) {
                supported = true;
                finished = this.manageSuccessfulExploration(node.level, a);
            }
            a = dom.next(a);
        }
        if (supported) {
            this.trueNodes[node.id] = this.trueTimestamp;
        } else if (this.set != null) {
            this.set.add(node.id, this.problem.solver.depth());
        } else {
            this.falseNodes[node.id] = this.falseTimestamp;
        }
        return supported;
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.beforeFiltering();
        this.exploreMDD(((MDDShort)this.extStructure).root);
        return this.updateDomains();
    }
}

