/*
 * Decompiled with CFR 0.152.
 */
package constraints.extension;

import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.extension.structures.MDD;
import interfaces.Tags;
import java.util.Arrays;
import java.util.Map;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import sets.SetSparseReversible;
import variables.Domain;
import variables.Variable;

public final class CMDD
extends Extension.ExtensionGlobal
implements Tags.TagPositive,
ICtr.ICtrMdd {
    protected SetSparseReversible set;
    protected boolean[][] ac;
    protected int[] cnts;
    protected int cnt;
    protected int falseTimestamp = 1;
    protected int trueTimestamp = 1;
    protected int[] falseNodes;
    protected int[] trueNodes;
    protected int earlyCutoff;

    @Override
    public void afterProblemConstruction() {
        super.afterProblemConstruction();
        int nNodes = ((MDD)this.extStructure).nNodes();
        this.trueNodes = new int[nNodes];
        if (this.problem.head.control.extension.decremental) {
            this.set = new SetSparseReversible(nNodes, false, this.problem.variables.length + 1);
        } else {
            this.falseNodes = new int[nNodes];
        }
        this.ac = Variable.litterals(this.scp).booleanArray();
        this.cnts = new int[this.scp.length];
    }

    @Override
    public void restoreBefore(int depth) {
        if (this.set != null) {
            this.set.restoreLimitAtLevel(depth);
        } else {
            ++this.falseTimestamp;
        }
    }

    public CMDD(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.control(scp.length >= 1);
    }

    public CMDD(Problem pb, Variable[] scp, int[][] tuples) {
        this(pb, scp);
        this.storeTuples(tuples, true);
    }

    public CMDD(Problem pb, Variable[] scp, MDD.MDDNode root) {
        this(pb, scp);
        this.extStructure = new MDD(this, root);
    }

    public CMDD(Problem pb, Variable[] scp, Transition[] transitions) {
        this(pb, scp);
        String s = this.signature() + " " + transitions;
        Map<String, MDD> map = this.problem.head.structureSharing.mapOfMDDStructures;
        this.extStructure = map.get(s);
        if (this.extStructure == null) {
            this.extStructure = new MDD(this, transitions);
            map.put(s, (MDD)this.extStructure);
        }
    }

    public CMDD(Problem problem, Variable[] scope, Automaton automaton) {
        this(problem, scope);
        this.extStructure = new MDD(this, automaton);
    }

    public CMDD(Problem problem, Variable[] scope, int[] coeffs, Object limits) {
        this(problem, scope);
        this.extStructure = new MDD(this, coeffs, limits);
    }

    @Override
    protected ExtensionStructure buildExtensionStructure() {
        return new MDD(this);
    }

    protected void beforeFiltering() {
        this.cnt = 0;
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            int domSize = this.scp[x].dom.size();
            this.cnt += domSize;
            this.cnts[x] = domSize;
            Arrays.fill(this.ac[x], false);
        }
        ++this.trueTimestamp;
        this.earlyCutoff = this.scp.length;
    }

    private boolean manageSuccessfulExploration(int level, int a) {
        int cutoffVariant = this.problem.head.control.extension.variant;
        if (cutoffVariant == 2) {
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
            }
            return level >= this.earlyCutoff;
        }
        if (cutoffVariant == 1) {
            boolean b = false;
            if (this.scp[level].isFuture()) {
                if (!this.ac[level][a]) {
                    --this.cnt;
                    int n = level;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[level][a] = true;
                    if (this.cnts[level] == 0 && this.earlyCutoff == level + 1) {
                        this.earlyCutoff = level;
                        b = true;
                    }
                }
            } else if (this.earlyCutoff == level + 1) {
                this.earlyCutoff = level;
                b = true;
            }
            return b;
        }
        assert (cutoffVariant == 0);
        if (this.scp[level].isFuture() && !this.ac[level][a]) {
            --this.cnt;
            int n = level;
            this.cnts[n] = this.cnts[n] - 1;
            this.ac[level][a] = true;
        }
        return false;
    }

    private boolean exploreMDD(MDD.MDDNode node) {
        boolean supported;
        block13: {
            if (node == MDD.MDDNode.nodeT || this.trueNodes[node.id] == this.trueTimestamp) {
                return true;
            }
            if (node == MDD.MDDNode.nodeF || this.set != null && this.set.isPresent(node.id) || this.set == null && this.falseNodes[node.id] == this.falseTimestamp) {
                return false;
            }
            Domain dom = this.scp[node.level].dom;
            supported = false;
            boolean finished = false;
            if (dom.size() < node.nSonsDifferentFromNodeF()) {
                int a = dom.first();
                while (a != -1 && !finished) {
                    if (this.exploreMDD(node.sons[a])) {
                        supported = true;
                        finished = this.manageSuccessfulExploration(node.level, a);
                    }
                    a = dom.next(a);
                }
            } else {
                int[][] nArray = node.sonsClasses;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int[] childsClass;
                    for (int a : childsClass = nArray[i]) {
                        if (!dom.present(a) || !this.exploreMDD(node.sons[a])) continue;
                        supported = true;
                        finished = this.manageSuccessfulExploration(node.level, a);
                        if (!finished) {
                            continue;
                        }
                        break block13;
                    }
                }
            }
        }
        if (supported) {
            this.trueNodes[node.id] = this.trueTimestamp;
        } else if (this.set != null) {
            this.set.add(node.id, this.problem.solver.depth());
        } else {
            this.falseNodes[node.id] = this.falseTimestamp;
        }
        return supported;
    }

    protected boolean updateDomains() {
        for (int i = this.futvars.limit; i >= 0 && this.cnt > 0; --i) {
            int x = this.futvars.dense[i];
            int nRemovals = this.cnts[x];
            if (nRemovals == 0) continue;
            if (!this.scp[x].dom.remove(this.ac[x], nRemovals)) {
                return false;
            }
            this.cnt -= nRemovals;
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.beforeFiltering();
        this.exploreMDD(((MDD)this.extStructure).root);
        return this.updateDomains();
    }
}

