/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import java.util.function.Consumer;
import java.util.function.Predicate;
import variables.Domain;
import variables.Variable;

public final class TupleManager {
    private final Domain[] doms;
    public final int[] localTuple;
    private final boolean[] fixed;
    public int[] currTuple;

    public TupleManager(Domain[] doms) {
        this.doms = doms;
        this.localTuple = new int[doms.length];
        this.fixed = new boolean[doms.length];
    }

    public TupleManager(Variable[] vars) {
        this(Variable.buildDomainsArrayFor(vars));
    }

    private boolean isValidCurrTuple() {
        for (int i = this.currTuple.length - 1; i >= 0; --i) {
            if (this.doms[i].present(this.currTuple[i])) continue;
            return false;
        }
        return true;
    }

    private void fix(int x, int a) {
        assert (this.doms[x].present(a)) : a + " no more in " + this.doms[x];
        this.currTuple[x] = a;
        this.fixed[x] = true;
    }

    public int[] firstValidTuple(int[] buffer) {
        this.currTuple = buffer;
        for (int i = buffer.length - 1; i >= 0; --i) {
            buffer[i] = this.doms[i].first();
            this.fixed[i] = false;
        }
        return buffer;
    }

    public int[] firstValidTuple() {
        return this.firstValidTuple(this.localTuple);
    }

    public int[] firstValidTupleWith(int x, int a, int[] buffer) {
        this.firstValidTuple(buffer);
        this.fix(x, a);
        return buffer;
    }

    public int[] firstValidTupleWith(int x, int a) {
        return this.firstValidTupleWith(x, a, this.localTuple);
    }

    public int[] firstValidTupleWith(int x, int a, int y, int b, int[] buffer) {
        this.firstValidTuple(buffer);
        this.fix(x, a);
        this.fix(y, b);
        return buffer;
    }

    public int[] firstValidTupleWith(int x, int a, int y, int b) {
        return this.firstValidTupleWith(x, a, y, b, this.localTuple);
    }

    private int setNextValidTupleBefore(int frontier) {
        for (int i = frontier; i >= 0; --i) {
            if (this.fixed[i]) continue;
            int a = this.doms[i].next(this.currTuple[i]);
            if (a != -1) {
                this.currTuple[i] = a;
                return i;
            }
            this.currTuple[i] = this.doms[i].first();
        }
        return -1;
    }

    public final int nextValidTuple() {
        assert (this.isValidCurrTuple());
        return this.setNextValidTupleBefore(this.doms.length - 1);
    }

    public final int nextValidTupleCautiously() {
        int arity = this.doms.length;
        for (int i = 0; i < arity; ++i) {
            if (this.doms[i].present(this.currTuple[i])) continue;
            int modifiedPosition = this.setNextValidTupleBefore(i);
            if (modifiedPosition == -1) {
                return -1;
            }
            for (int j = i + 1; j < arity; ++j) {
                if (this.fixed[j]) continue;
                this.currTuple[j] = this.doms[j].first();
            }
            return modifiedPosition;
        }
        return this.nextValidTuple();
    }

    public final void overValidTuples(Consumer<int[]> p) {
        assert (this.isValidCurrTuple());
        do {
            p.accept(this.currTuple);
        } while (this.nextValidTuple() != -1);
    }

    public final boolean findValidTupleChecking(Predicate<int[]> p) {
        assert (this.isValidCurrTuple());
        do {
            if (!p.test(this.currTuple)) continue;
            return true;
        } while (this.nextValidTuple() != -1);
        return false;
    }

    public final long countValidTuplesChecking(Predicate<int[]> p) {
        assert (this.isValidCurrTuple());
        long cnt = 0L;
        do {
            if (!p.test(this.currTuple)) continue;
            ++cnt;
        } while (this.nextValidTuple() != -1);
        return cnt;
    }
}

