/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.ConflictsStructure;
import constraints.TupleManager;
import constraints.extension.Extension;
import constraints.extension.structures.Bits;
import constraints.extension.structures.ExtensionStructure;
import constraints.global.Sum;
import constraints.intension.Intension;
import dashboard.Control;
import heuristics.HeuristicVariablesDynamic;
import interfaces.FilteringSpecific;
import interfaces.Observers;
import interfaces.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import propagation.Forward;
import propagation.Reviser;
import propagation.Supporter;
import sets.SetDense;
import sets.SetSparse;
import utility.Kit;
import variables.Domain;
import variables.DomainInfinite;
import variables.Variable;

public abstract class Constraint
implements ICtr,
Observers.ObserverConstruction,
Comparable<Constraint> {
    public static final int MAX_FILTERING_COMPLEXITY = 2;
    public static final Constraint TAG = new Constraint(){

        @Override
        public boolean checkValues(int[] t) {
            throw new AssertionError();
        }
    };
    public final Problem problem;
    public int num = -1;
    private String id;
    public final Variable[] scp;
    private int[] positions;
    public SetDense futvars;
    public boolean ignored;
    public String key;
    public final TupleManager tupleManager;
    protected final Supporter supporter;
    public final boolean indexesMatchValues;
    protected final int[] vals;
    public final Domain[] doms;
    public int cost = 1;
    public long time;
    public int filteringComplexity;
    public final int genericFilteringThreshold;
    public int nEffectiveFilterings;
    public Variable[] infiniteDomainVars;
    public Control.SettingCtrs settings;
    public ConflictsStructure conflictsStructure;

    @Override
    public int compareTo(Constraint c) {
        boolean b2;
        boolean b1 = this.id == null;
        boolean bl = b2 = c.id == null;
        return b1 && !b2 ? -1 : (!b1 && b2 ? 1 : (!b1 && !b2 ? this.id.compareTo(c.id) : Integer.compare(this.num, c.num)));
    }

    @Override
    public void afterProblemConstruction() {
        int nVariables = this.problem.variables.length;
        int arity = this.scp.length;
        if (this.settings.arityLimitForVapArrayLb < arity && (nVariables < this.settings.arityLimitForVapArrayUb || arity > nVariables / 3)) {
            this.positions = Kit.repeat(-1, nVariables);
            for (int i = 0; i < arity; ++i) {
                this.positions[this.scp[i].num] = i;
            }
            this.futvars = new SetSparse(arity, true);
        } else {
            this.positions = null;
            this.futvars = new SetDense(arity, true);
        }
    }

    public static final boolean isGuaranteedGAC(Constraint[] ctrs) {
        return Stream.of(ctrs).allMatch(c -> c.isGuaranteedAC());
    }

    public static final int howManyVarsWithin(int[] sizes, int spaceLimitation) {
        int i;
        double limit = Math.pow(2.0, spaceLimitation);
        Arrays.sort(sizes);
        double prod = 1.0;
        for (i = sizes.length - 1; i >= 0 && prod <= limit; prod *= (double)sizes[i], --i) {
        }
        return prod > limit ? sizes.length - i - 1 : Integer.MAX_VALUE;
    }

    public static final int howManyVarsWithin(Variable[] vars, int spaceLimitation) {
        return Constraint.howManyVarsWithin(Stream.of(vars).mapToInt(x -> x.dom.size()).toArray(), spaceLimitation);
    }

    public static Constraint firstUnsatisfiedHardConstraint(Constraint[] constraints, int[] solution) {
        for (Constraint c : constraints) {
            if (c.ignored) continue;
            int[] tmp = c.tupleManager.localTuple;
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = solution != null ? solution[c.scp[i].num] : c.scp[i].dom.unique();
            }
            if (c.checkIndexes(tmp)) continue;
            return c;
        }
        return null;
    }

    public static Constraint firstUnsatisfiedHardConstraint(Constraint[] constraints) {
        return Constraint.firstUnsatisfiedHardConstraint(constraints, null);
    }

    public static int nPairsOfCtrsWithSimilarScopeIn(Constraint ... ctrs) {
        return IntStream.range(0, ctrs.length).map(i -> (int)IntStream.range(i + 1, ctrs.length).filter(j -> Variable.areSimilarArrays(ctrs[i].scp, ctrs[j].scp)).count()).sum();
    }

    public static final boolean areNumsNormalized(Constraint[] ctrs) {
        return IntStream.range(0, ctrs.length).noneMatch(i -> i != ctrs[i].num);
    }

    public static final boolean isPresentScope(Constraint c, boolean[] presentVars) {
        return Stream.of(c.scp).allMatch(x -> presentVars[x.num]);
    }

    public static final long costOfCoveredConstraintsIn(Constraint[] ctrs) {
        long cost = 0L;
        for (Constraint c : ctrs) {
            if (c.futvars.size() != 0) continue;
            cost = Kit.addSafe(cost, c.costOfCurrInstantiation());
        }
        return cost;
    }

    public static int[][] buildTable(Constraint ... ctrs) {
        Variable[] scp = Variable.scopeOf(ctrs);
        int[][] positions = (int[][])Stream.of(ctrs).map(c -> IntStream.range(0, c.scp.length).map(i -> Utilities.indexOf(c.scp[i], scp)).toArray()).toArray(x$0 -> new int[x$0][]);
        ArrayList<int[]> list = new ArrayList<int[]>();
        int[] values = new int[scp.length];
        EnumerationCartesian ec = new EnumerationCartesian(Variable.domSizeArrayOf(scp, true));
        block0: while (ec.hasNext()) {
            int i;
            int[] indexes = ec.next();
            for (i = 0; i < ctrs.length; ++i) {
                int[] t = ctrs[i].tupleManager.localTuple;
                for (int j = 0; j < t.length; ++j) {
                    t[j] = indexes[positions[i][j]];
                }
                if (!ctrs[i].checkIndexes(t)) continue block0;
            }
            for (i = 0; i < indexes.length; ++i) {
                values[i] = scp[i].dom.toVal(indexes[i]);
            }
            list.add((int[])values.clone());
        }
        return Kit.intArray2D(list);
    }

    public final String defaultId() {
        return "c" + this.num;
    }

    public final String explicitId() {
        return this.id;
    }

    public final String getId() {
        return this.id != null ? this.id : this.defaultId();
    }

    public final int positionOf(Variable x) {
        if (this.positions != null) {
            return this.positions[x.num];
        }
        for (int i = this.scp.length - 1; i >= 0; --i) {
            if (this.scp[i] != x) continue;
            return i;
        }
        return -1;
    }

    public final boolean involves(Variable x) {
        return this.positionOf(x) != -1;
    }

    public final boolean involves(Variable x, Variable y) {
        return this.positionOf(x) != -1 && this.positionOf(y) != -1;
    }

    public final boolean isScopeCoveredBy(Variable[] vars) {
        int cnt = 0;
        for (Variable x : vars) {
            if (!this.involves(x) || ++cnt != this.scp.length) continue;
            return true;
        }
        return false;
    }

    public final double wdeg() {
        return ((HeuristicVariablesDynamic.WdegVariant)this.problem.solver.heuristic).cscores[this.num];
    }

    public boolean isIrreflexive() {
        this.control(this.scp.length == 2);
        int[] tuple = this.tupleManager.localTuple;
        int p = this.scp[0].dom.size() > this.scp[1].dom.size() ? 1 : 0;
        int q = p == 0 ? 1 : 0;
        Domain dx = this.scp[p].dom;
        Domain dy = this.scp[q].dom;
        int a = dx.first();
        while (a != -1) {
            int b = dy.toIdx(dx.toVal(a));
            if (b >= 0) {
                tuple[p] = a;
                tuple[q] = b;
                if (this.checkIndexes(tuple)) {
                    return false;
                }
            }
            a = dx.next(a);
        }
        return true;
    }

    public boolean isSubstitutableBy(int x, int a, int b) {
        this.tupleManager.firstValidTupleWith(x, a);
        return !this.tupleManager.findValidTupleChecking(t -> {
            t[x] = a;
            boolean b1 = this.checkIndexes((int[])t);
            t[x] = b;
            boolean b2 = this.checkIndexes((int[])t);
            return b1 && !b2;
        });
    }

    public boolean isGuaranteedAC() {
        if (this.infiniteDomainVars.length > 0) {
            return false;
        }
        if (this instanceof Tags.TagAC) {
            return true;
        }
        if (this instanceof Tags.TagNotAC) {
            return false;
        }
        if (this instanceof FilteringSpecific) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        return this.genericFilteringThreshold == Integer.MAX_VALUE;
    }

    public Boolean isSymmetric() {
        if (this instanceof Tags.TagSymmetric) {
            return Boolean.TRUE;
        }
        if (this instanceof Tags.TagNotSymmetric) {
            return Boolean.FALSE;
        }
        return null;
    }

    public int[] symmetryMatching() {
        Boolean b = this.isSymmetric();
        this.control(b != null);
        return b != false ? Kit.repeat(1, this.scp.length) : Kit.range(1, this.scp.length);
    }

    public boolean entailed() {
        this.problem.solver.entail(this);
        return true;
    }

    public ExtensionStructure extStructure() {
        return null;
    }

    public void cloneStructures(boolean onlyConflictsStructure) {
        if (this.conflictsStructure != null && this.conflictsStructure.registeredCtrs().size() > 1) {
            this.conflictsStructure.unregister(this);
            this.conflictsStructure = new ConflictsStructure(this.conflictsStructure, this);
        }
    }

    private Constraint() {
        this.problem = null;
        this.scp = new Variable[0];
        this.tupleManager = null;
        this.vals = null;
        this.doms = null;
        this.genericFilteringThreshold = Integer.MAX_VALUE;
        this.indexesMatchValues = false;
        this.infiniteDomainVars = new Variable[0];
        this.supporter = null;
    }

    private final int computeGenericFilteringThreshold() {
        if (this instanceof FilteringSpecific || this instanceof Extension) {
            return Integer.MAX_VALUE;
        }
        int arityLimit = this.problem.head.control.propagation.arityLimitForGACGuaranteed;
        if (this.scp.length <= arityLimit) {
            return Integer.MAX_VALUE;
        }
        int futureLimitation = this.problem.head.control.propagation.futureLimitation;
        if (futureLimitation != -1) {
            return futureLimitation < this.scp.length ? Math.max(arityLimit, futureLimitation) : Integer.MAX_VALUE;
        }
        int spaceLimitation = this.problem.head.control.propagation.spaceLimitation;
        if (spaceLimitation != -1) {
            return Math.max(arityLimit, Constraint.howManyVarsWithin(this.scp, spaceLimitation));
        }
        return Integer.MAX_VALUE;
    }

    public Constraint(Problem pb, Variable[] scp) {
        this.problem = pb;
        scp = (Variable[])Stream.of(scp).distinct().toArray(Variable[]::new);
        this.scp = scp;
        this.control(scp.length >= 1 && Stream.of(scp).allMatch(x -> x != null), () -> this + " with a scope badly formed ");
        Stream.of(scp).forEach(x -> x.collectedCtrs.add(this));
        this.infiniteDomainVars = (Variable[])Stream.of(scp).filter(x -> x.dom instanceof DomainInfinite).toArray(Variable[]::new);
        this.doms = Variable.buildDomainsArrayFor(scp);
        this.tupleManager = new TupleManager(scp);
        this.vals = new int[scp.length];
        this.settings = pb.head.control.constraints;
        this.genericFilteringThreshold = this.computeGenericFilteringThreshold();
        this.indexesMatchValues = Stream.of(scp).allMatch(x -> x.dom.indexesMatchValues());
        if (this instanceof FilteringSpecific) {
            ++pb.features.nSpecificCtrs;
        }
        if (this instanceof Observers.ObserverConstruction) {
            pb.head.observersConstruction.add(this);
        }
        this.supporter = Supporter.buildFor(this);
    }

    public final void reset() {
        this.control(this.futvars.isFull());
        this.nEffectiveFilterings = 0;
        this.time = 0L;
    }

    public final void doPastVariable(Variable x) {
        if (this.positions != null) {
            ((SetSparse)this.futvars).remove(this.positions[x.num]);
        } else {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (this.scp[this.futvars.dense[i]] != x) continue;
                this.futvars.removeAtPosition(i);
                break;
            }
        }
    }

    public final void undoPastVariable(Variable x) {
        assert (x.assigned() && this.scp[this.futvars.dense[this.futvars.size()]] == x);
        ++this.futvars.limit;
    }

    public abstract boolean checkValues(int[] var1);

    public boolean checkIndexes(int[] t) {
        return this.indexesMatchValues ? this.checkValues(t) : this.checkValues(this.toVals(t));
    }

    public int[] buildCurrentInstantiationTuple() {
        int[] tuple = this.tupleManager.localTuple;
        for (int i = tuple.length - 1; i >= 0; --i) {
            tuple[i] = this.doms[i].unique();
        }
        return tuple;
    }

    public boolean checkCurrentInstantiation() {
        return this.checkIndexes(this.buildCurrentInstantiationTuple());
    }

    public long costOfCurrInstantiation() {
        return this.checkIndexes(this.buildCurrentInstantiationTuple()) ? 0L : (long)this.cost;
    }

    public int[] toVals(int[] idxs) {
        for (int i = this.vals.length - 1; i >= 0; --i) {
            this.vals[i] = this.doms[i].toVal(idxs[i]);
        }
        return this.vals;
    }

    public int[] toIdxs(int[] vals, int[] idxs) {
        for (int i = vals.length - 1; i >= 0; --i) {
            idxs[i] = this.doms[i].toIdx(vals[i]);
        }
        return idxs;
    }

    public final boolean isValid(int[] tuple) {
        for (int i = tuple.length - 1; i >= 0; --i) {
            if (this.doms[i].present(tuple[i])) continue;
            return false;
        }
        return true;
    }

    private final boolean seekSupport() {
        return this.tupleManager.findValidTupleChecking(t -> this.checkIndexes((int[])t));
    }

    public final boolean seekFirstSupport() {
        this.tupleManager.firstValidTuple();
        return this.seekSupport();
    }

    public final boolean seekFirstSupportWith(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.seekSupport();
    }

    public boolean seekFirstSupportWith(int x, int a, int[] buffer) {
        this.tupleManager.firstValidTupleWith(x, a, buffer);
        return this.seekSupport();
    }

    public final boolean seekFirstSupportWith(int x, int a, int y, int b) {
        this.tupleManager.firstValidTupleWith(x, a, y, b);
        return this.seekSupport();
    }

    public final boolean seekNextSupport() {
        return this.tupleManager.nextValidTupleCautiously() != -1 && this.seekSupport();
    }

    private final boolean seekConflict() {
        return this.tupleManager.findValidTupleChecking(t -> !this.checkIndexes((int[])t));
    }

    public final boolean seekFirstConflict() {
        this.tupleManager.firstValidTuple();
        return this.seekConflict();
    }

    public final boolean seekFirstConflictWith(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.seekConflict();
    }

    public long nConflictsFor(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.tupleManager.countValidTuplesChecking(t -> !this.checkIndexes((int[])t));
    }

    public boolean findArcSupportFor(int x, int a) {
        if (this.supporter != null) {
            return ((Supporter.SupporterHard)this.supporter).findArcSupportFor(x, a);
        }
        if (this.extStructure() instanceof Bits) {
            long[] t1 = ((Bits)this.extStructure()).bitSupsFor(x)[a];
            long[] t2 = this.scp[x == 0 ? 1 : 0].dom.binary();
            for (int i = 0; i < t1.length; ++i) {
                if ((t1[i] & t2[i]) == 0L) continue;
                return true;
            }
            return false;
        }
        return this.seekFirstSupportWith(x, a);
    }

    private boolean handleHugeDomains() {
        assert (this.infiniteDomainVars.length > 0);
        if (this.futvars.size() == 0) {
            return this.checkCurrentInstantiation();
        }
        if (this.futvars.size() == 1) {
            if (this instanceof Sum.SumSimple.SumSimpleEQ) {
                ((Sum.SumSimple.SumSimpleEQ)this).deduce();
                return true;
            }
            if (this instanceof Sum.SumWeighted.SumWeightedEQ) {
                ((Sum.SumWeighted.SumWeightedEQ)this).deduce();
                return true;
            }
        }
        return this.futvars.size() > 0;
    }

    private boolean genericFiltering(Variable x) {
        if (this.futvars.size() > this.genericFilteringThreshold) {
            return true;
        }
        Reviser reviser = ((Forward)this.problem.solver.propagation).reviser;
        if (x.assigned()) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (reviser.revise(this, this.scp[this.futvars.dense[i]])) continue;
                return false;
            }
        } else {
            boolean revisingEventVarToo = this.scp.length == 1;
            for (int i = this.futvars.limit; i >= 0; --i) {
                Variable y = this.scp[this.futvars.dense[i]];
                if (y == x) continue;
                if (this.time < y.time) {
                    revisingEventVarToo = true;
                }
                if (reviser.revise(this, y)) continue;
                return false;
            }
            if (revisingEventVarToo && !reviser.revise(this, x)) {
                return false;
            }
        }
        return true;
    }

    public final boolean filterFrom(Variable x) {
        boolean consistent;
        if (this.infiniteDomainVars.length > 0 && this.handleHugeDomains()) {
            return true;
        }
        if (this.problem.settings.framework == Types.TypeFramework.CSP) {
            if (this.futvars.size() == 0) {
                assert (!this.isGuaranteedAC() || this.checkCurrentInstantiation()) : "Unsatisfied constraint " + this + "while AC should be guaranteed";
                return this.isGuaranteedAC() || this.checkCurrentInstantiation();
            }
            if (this.futvars.size() == 1 && x.isFuture() && this.scp.length > 1) {
                return true;
            }
        }
        if (this.time > x.time && this instanceof Tags.TagFilteringCompleteAtEachCall) {
            return true;
        }
        int nBefore = this.problem.nValuesRemoved;
        boolean bl = consistent = this instanceof FilteringSpecific ? ((FilteringSpecific)((Object)this)).runPropagator(x) : this.genericFiltering(x);
        if (!consistent || this.problem.nValuesRemoved != nBefore) {
            this.problem.solver.proofer.updateProof(this);
            ++this.nEffectiveFilterings;
            ++this.problem.features.nEffectiveFilterings;
        }
        this.time = this.problem.solver.propagation.incrementTime();
        return consistent;
    }

    public boolean controlArcConsistency() {
        if (this.ignored) {
            return true;
        }
        if (Domain.nValidTuplesBoundedAtMaxValueFor(this.doms) > 1000L) {
            return true;
        }
        for (int x = 0; x < this.scp.length; ++x) {
            int a = this.doms[x].first();
            while (a != -1) {
                if (!this.seekFirstSupportWith(x, a)) {
                    System.out.println(" " + this.scp[x] + "=" + this.doms[x].toVal(a) + " not supported by " + this);
                    for (Domain dom : this.doms) {
                        dom.display(false);
                    }
                    this.display(true);
                    return false;
                }
                a = this.doms[x].next(a);
            }
        }
        return true;
    }

    public void control(boolean conditionToBeRespected, Supplier<String> message) {
        Kit.control(conditionToBeRespected, message);
    }

    public void control(boolean conditionToBeRespected, String message) {
        Kit.control(conditionToBeRespected, () -> message);
    }

    public void control(boolean conditionToBeRespected) {
        Kit.control(conditionToBeRespected, () -> "");
    }

    public StringBuilder signature() {
        return Variable.signatureFor(this.scp);
    }

    public String toString() {
        return this.getId() + "(" + Stream.of(this.scp).map(x -> x.id()).collect(Collectors.joining(",")) + ")";
    }

    public void display(boolean exhaustively) {
        Kit.log.finer("Constraint " + this.toString());
        Kit.log.finer("\tClass = " + this.getClass().getName() + (this instanceof Extension ? ":" + ((Extension)this).extStructure().getClass().getSimpleName() : ""));
        if (this instanceof Intension) {
            Kit.log.finer("\tPredicate: " + ((Intension)this).tree.toFunctionalExpression(null));
        }
        Kit.log.finer("\tKey = " + this.key);
        Kit.log.finest("\tCost = " + this.cost);
    }

    public static abstract class CtrGlobal
    extends Constraint
    implements FilteringSpecific {
        protected final void defineKey(Object ... specificData) {
            StringBuilder sb = this.signature().append(' ').append(this.getClass().getSimpleName());
            for (Object data : specificData) {
                sb.append(' ').append(data.toString());
            }
            this.key = sb.toString();
        }

        public CtrGlobal(Problem pb, Variable[] scp) {
            super(pb, scp);
            this.filteringComplexity = 1;
        }
    }

    public static class CtrTrue
    extends Constraint
    implements FilteringSpecific,
    Tags.TagFilteringCompleteAtEachCall,
    Tags.TagAC {
        @Override
        public boolean checkValues(int[] t) {
            return true;
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            return true;
        }

        public CtrTrue(Problem pb, Variable[] scp) {
            super(pb, scp);
        }
    }

    public static class CtrFalse
    extends Constraint
    implements FilteringSpecific,
    Tags.TagFilteringCompleteAtEachCall,
    Tags.TagAC {
        public String message;

        @Override
        public boolean checkValues(int[] t) {
            return false;
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            return false;
        }

        public CtrFalse(Problem pb, Variable[] scp, String message) {
            super(pb, scp);
            this.message = message;
        }
    }

    public static interface RegisteringCtrs {
        public List<Constraint> registeredCtrs();

        default public Constraint firstRegisteredCtr() {
            return this.registeredCtrs().get(0);
        }

        default public void register(Constraint c) {
            if (!2.$assertionsDisabled && (this.registeredCtrs().contains(c) || this.registeredCtrs().size() != 0 && !Domain.similarDomains(c.doms, this.firstRegisteredCtr().doms))) {
                throw new AssertionError();
            }
            this.registeredCtrs().add(c);
        }

        default public void unregister(Constraint c) {
            boolean b = this.registeredCtrs().remove(c);
            if (!2.$assertionsDisabled && !b) {
                throw new AssertionError();
            }
        }

        static {
            if (2.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

