/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.Constraint;
import constraints.extension.Extension;
import constraints.extension.structures.ExtensionStructure;
import constraints.intension.Intension;
import interfaces.FilteringSpecific;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import problem.Problem;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public final class ConflictsStructure
implements Constraint.RegisteringCtrs {
    static final BigInteger LIMIT_FOR_BARY = BigInteger.valueOf(1000000L);
    static final BigInteger LIMIT_FOR_NARY = BigInteger.valueOf(10000L);
    private List<Constraint> registeredCtrs = new ArrayList<Constraint>();
    public int[][] nConflicts;
    public int[] nMaxConflicts;

    public static void buildFor(Problem problem) {
        ConflictsStructure conflictsStructure;
        Constraint c;
        if (!problem.head.control.mustBuildConflictStructures) {
            return;
        }
        for (ExtensionStructure extStructure : problem.head.structureSharing.mapOfExtensionStructures.values()) {
            c = extStructure.firstRegisteredCtr();
            if (c instanceof FilteringSpecific || c.scp.length == 1 || c.infiniteDomainVars.length > 0) continue;
            Kit.control(c instanceof Extension.ExtensionGeneric);
            if (Kit.memory() > 400000000L) {
                return;
            }
            conflictsStructure = new ConflictsStructure(c).initializeFrom(extStructure.originalTuples, extStructure.originalPositive);
            for (Constraint cc : extStructure.registeredCtrs) {
                cc.conflictsStructure = conflictsStructure;
                if (cc == c) continue;
                conflictsStructure.register(cc);
            }
        }
        for (Intension.SharedTreeEvaluator treeEvaluator : problem.head.structureSharing.mapOfTreeEvaluators.values()) {
            c = treeEvaluator.firstRegisteredCtr();
            if (c instanceof FilteringSpecific || c.scp.length == 1 || c.infiniteDomainVars.length > 0) continue;
            Kit.control(c instanceof Intension);
            if (Kit.memory() > 400000000L) {
                return;
            }
            if (Domain.nValidTuples(c.doms, false).compareTo(c.scp.length == 2 ? LIMIT_FOR_BARY : LIMIT_FOR_NARY) > 0) continue;
            conflictsStructure = new ConflictsStructure(c).initialize();
            for (Constraint cc : treeEvaluator.registeredCtrs) {
                cc.conflictsStructure = conflictsStructure;
                if (cc == c) continue;
                conflictsStructure.register(cc);
            }
        }
    }

    @Override
    public List<Constraint> registeredCtrs() {
        return this.registeredCtrs;
    }

    public ConflictsStructure(Constraint c) {
        this.registeredCtrs.add(c);
        this.nMaxConflicts = new int[c.scp.length];
        this.nConflicts = Variable.litterals(c.scp).intArray();
    }

    public ConflictsStructure(ConflictsStructure conflictsStructure, Constraint c) {
        this.registeredCtrs.add(c);
        this.nMaxConflicts = (int[])conflictsStructure.nMaxConflicts.clone();
        this.nConflicts = Kit.cloneDeeply(conflictsStructure.nConflicts);
    }

    private void computeNbMaxConflicts() {
        Domain[] doms = this.firstRegisteredCtr().doms;
        for (int i = 0; i < this.nMaxConflicts.length; ++i) {
            int max = Integer.MIN_VALUE;
            Domain dom = doms[i];
            int a = dom.first();
            while (a != -1) {
                max = Math.max(max, this.nConflicts[i][a]);
                a = dom.next(a);
            }
            this.nMaxConflicts[i] = max;
        }
    }

    private ConflictsStructure initializeFrom(int[][] tuples, boolean positive) {
        assert (this.registeredCtrs.size() == 1);
        Domain[] doms = this.firstRegisteredCtr().doms;
        block0: for (int[] tuple : tuples) {
            int i;
            assert (IntStream.of(tuple).noneMatch(v -> v == 0x7FFFFFFE));
            for (i = 0; i < tuple.length; ++i) {
                if (!doms[i].presentValue(tuple[i])) continue block0;
            }
            for (i = 0; i < tuple.length; ++i) {
                int[] nArray = this.nConflicts[i];
                int n = doms[i].toIdx(tuple[i]);
                nArray[n] = nArray[n] + 1;
            }
        }
        if (positive) {
            int nValidTuples = Domain.nValidTuples(doms, false).intValueExact();
            for (int i = 0; i < this.nConflicts.length; ++i) {
                int nTuples = nValidTuples / doms[i].size();
                for (int j = 0; j < this.nConflicts[i].length; ++j) {
                    this.nConflicts[i][j] = nTuples - this.nConflicts[i][j];
                }
            }
        }
        this.computeNbMaxConflicts();
        assert (this.controlStructures());
        return this;
    }

    private ConflictsStructure initialize() {
        assert (this.registeredCtrs.size() == 1);
        Constraint c = this.firstRegisteredCtr();
        c.tupleManager.firstValidTuple();
        c.tupleManager.overValidTuples(t -> {
            if (!c.checkIndexes((int[])t)) {
                for (int i = 0; i < ((int[])t).length; ++i) {
                    int[] nArray = this.nConflicts[i];
                    int n = t[i];
                    nArray[n] = nArray[n] + 1;
                }
            }
        });
        this.computeNbMaxConflicts();
        assert (this.controlStructures());
        return this;
    }

    private boolean controlStructures() {
        Constraint c = this.firstRegisteredCtr();
        if (Domain.nValidTuples(c.doms, false).compareTo(LIMIT_FOR_NARY) > 0) {
            Kit.log.warning("Too large Cartesian Space for checking ");
            return true;
        }
        for (int i = 0; i < this.nConflicts.length; ++i) {
            Variable x = c.scp[i];
            int max = Integer.MIN_VALUE;
            int a = x.dom.first();
            while (a != -1) {
                Kit.control((long)this.nConflicts[i][a] == c.nConflictsFor(i, a), "pb with " + c + " " + x);
                max = Math.max(max, this.nConflicts[i][a]);
                a = x.dom.next(a);
            }
            Kit.control(max == this.nMaxConflicts[i], "pb with " + c + " " + x);
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("In ").append(this.firstRegisteredCtr()).append(" (nCtrs=").append(this.registeredCtrs.size()).append(")");
        for (int i = 0; i < this.nConflicts.length; ++i) {
            sb.append("\n  ").append(i).append(" : nMaxConflicts=").append(this.nMaxConflicts[i]).append("  nConflicts=(").append(Kit.join((Object)this.nConflicts[i], new String[0]));
        }
        return sb.toString();
    }
}

