# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['isort',
 'isort._future',
 'isort._vendored.toml',
 'isort.deprecated',
 'isort.stdlibs']

package_data = \
{'': ['*']}

extras_require = \
{'pipfile_deprecated_finder': ['pipreqs', 'requirementslib', 'tomlkit>=0.5.3'],
 'requirements_deprecated_finder': ['pipreqs', 'pip-api']}

entry_points = \
{'console_scripts': ['isort = isort.main:main'],
 'distutils.commands': ['isort = isort.main:ISortCommand'],
 'pylama.linter': ['isort = isort = isort.pylama_isort:Linter']}

setup_kwargs = {
    'name': 'isort',
    'version': '5.0.8',
    'description': 'A Python utility / library to sort Python imports.',
    'long_description': '[![isort - isort your imports, so you don\'t have to.](https://raw.githubusercontent.com/timothycrosley/isort/develop/art/logo_large.png)](https://timothycrosley.github.io/isort/)\n\n------------------------------------------------------------------------\n\n[![PyPI version](https://badge.fury.io/py/isort.svg)](https://badge.fury.io/py/isort)\n[![Test Status](https://github.com/timothycrosley/isort/workflows/Test/badge.svg?branch=develop)](https://github.com/timothycrosley/isort/actions?query=workflow%3ATest)\n[![Lint Status](https://github.com/timothycrosley/isort/workflows/Lint/badge.svg?branch=develop)](https://github.com/timothycrosley/isort/actions?query=workflow%3ALint)\n[![Code coverage Status](https://codecov.io/gh/timothycrosley/isort/branch/develop/graph/badge.svg)](https://codecov.io/gh/timothycrosley/isort)\n[![Maintainability](https://api.codeclimate.com/v1/badges/060372d3e77573072609/maintainability)](https://codeclimate.com/github/timothycrosley/isort/maintainability)\n[![License](https://img.shields.io/github/license/mashape/apistatus.svg)](https://pypi.org/project/isort/)\n[![Join the chat at https://gitter.im/timothycrosley/isort](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/timothycrosley/isort?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)\n[![Downloads](https://pepy.tech/badge/isort)](https://pepy.tech/project/isort)\n[![DeepSource](https://static.deepsource.io/deepsource-badge-light-mini.svg)](https://deepsource.io/gh/timothycrosley/isort/?ref=repository-badge)\n_________________\n\n[Read Latest Documentation](https://timothycrosley.github.io/isort/) - [Browse GitHub Code Repository](https://github.com/timothycrosley/isort/)\n_________________\n\nisort your imports, so you don\'t have to.\n\nisort is a Python utility / library to sort imports alphabetically, and\nautomatically separated into sections and by type. It provides a command line\nutility, Python library and [plugins for various\neditors](https://github.com/timothycrosley/isort/wiki/isort-Plugins) to\nquickly sort all your imports. It requires Python 3.6+ to run but\nsupports formatting Python 2 code too.\n\n[Try isort now from your browser!](https://timothycrosley.github.io/isort/docs/quick_start/0.-try/)\n\n![Example Usage](https://raw.github.com/timothycrosley/isort/develop/example.gif)\n\nBefore isort:\n\n```python\nfrom my_lib import Object\n\nimport os\n\nfrom my_lib import Object3\n\nfrom my_lib import Object2\n\nimport sys\n\nfrom third_party import lib15, lib1, lib2, lib3, lib4, lib5, lib6, lib7, lib8, lib9, lib10, lib11, lib12, lib13, lib14\n\nimport sys\n\nfrom __future__ import absolute_import\n\nfrom third_party import lib3\n\nprint("Hey")\nprint("yo")\n```\n\nAfter isort:\n\n```python\nfrom __future__ import absolute_import\n\nimport os\nimport sys\n\nfrom third_party import (lib1, lib2, lib3, lib4, lib5, lib6, lib7, lib8,\n                         lib9, lib10, lib11, lib12, lib13, lib14, lib15)\n\nfrom my_lib import Object, Object2, Object3\n\nprint("Hey")\nprint("yo")\n```\n\nInstalling isort\n================\n\nInstalling isort is as simple as:\n\n```bash\npip install isort\n```\n\nInstall isort with requirements.txt support:\n\n```bash\npip install isort[requirements_deprecated_finder]\n```\n\nInstall isort with Pipfile support:\n\n```bash\npip install isort[pipfile_deprecated_finder]\n```\n\nInstall isort with both formats support:\n\n```bash\npip install isort[requirements_deprecated_finder,pipfile_deprecated_finder]\n```\n\nUsing isort\n===========\n\n**From the command line**:\n\n```bash\nisort mypythonfile.py mypythonfile2.py\n```\n\nor recursively:\n\n```bash\nisort .\n```\n\n*which is equivalent to:*\n\n```bash\nisort **/*.py\n```\n\nor to see the proposed changes without applying them:\n\n```bash\nisort mypythonfile.py --diff\n```\n\nFinally, to atomically run isort against a project, only applying\nchanges if they don\'t introduce syntax errors do:\n\n```bash\nisort --atomic .\n```\n\n(Note: this is disabled by default as it keeps isort from being able to\nrun against code written using a different version of Python)\n\n**From within Python**:\n\n```bash\nimport isort\n\nisort.file("pythonfile.py")\n```\n\nor:\n\n```bash\nimport isort\n\nsorted_code = isort.code("import b\\nimport a\\n")\n```\n\nInstalling isort\'s for your preferred text editor\n==================================================\n\nSeveral plugins have been written that enable to use isort from within a\nvariety of text-editors. You can find a full list of them [on the isort\nwiki](https://github.com/timothycrosley/isort/wiki/isort-Plugins).\nAdditionally, I will enthusiastically accept pull requests that include\nplugins for other text editors and add documentation for them as I am\nnotified.\n\nMulti line output modes\n=======================\n\nYou will notice above the \\"multi\\_line\\_output\\" setting. This setting\ndefines how from imports wrap when they extend past the line\\_length\nlimit and has 6 possible settings:\n\n**0 - Grid**\n\n```python\nfrom third_party import (lib1, lib2, lib3,\n                         lib4, lib5, ...)\n```\n\n**1 - Vertical**\n\n```python\nfrom third_party import (lib1,\n                         lib2,\n                         lib3\n                         lib4,\n                         lib5,\n                         ...)\n```\n\n**2 - Hanging Indent**\n\n```python\nfrom third_party import \\\n    lib1, lib2, lib3, \\\n    lib4, lib5, lib6\n```\n\n**3 - Vertical Hanging Indent**\n\n```python\nfrom third_party import (\n    lib1,\n    lib2,\n    lib3,\n    lib4,\n)\n```\n\n**4 - Hanging Grid**\n\n```python\nfrom third_party import (\n    lib1, lib2, lib3, lib4,\n    lib5, ...)\n```\n\n**5 - Hanging Grid Grouped**\n\n```python\nfrom third_party import (\n    lib1, lib2, lib3, lib4,\n    lib5, ...\n)\n```\n\n**6 - Hanging Grid Grouped, No Trailing Comma**\n\nIn Mode 5 isort leaves a single extra space to maintain consistency of\noutput when a comma is added at the end. Mode 6 is the same - except\nthat no extra space is maintained leading to the possibility of lines\none character longer. You can enforce a trailing comma by using this in\nconjunction with `-tc` or `include_trailing_comma: True`.\n\n```python\nfrom third_party import (\n    lib1, lib2, lib3, lib4,\n    lib5\n)\n```\n\n**7 - NOQA**\n\n```python\nfrom third_party import lib1, lib2, lib3, ...  # NOQA\n```\n\nAlternatively, you can set `force_single_line` to `True` (`-sl` on the\ncommand line) and every import will appear on its own line:\n\n```python\nfrom third_party import lib1\nfrom third_party import lib2\nfrom third_party import lib3\n...\n```\n\nNote: to change the how constant indents appear - simply change the\nindent property with the following accepted formats:\n\n-   Number of spaces you would like. For example: 4 would cause standard\n    4 space indentation.\n-   Tab\n-   A verbatim string with quotes around it.\n\nFor example:\n\n```python\n"    "\n```\n\nis equivalent to 4.\n\nFor the import styles that use parentheses, you can control whether or\nnot to include a trailing comma after the last import with the\n`include_trailing_comma` option (defaults to `False`).\n\nIntelligently Balanced Multi-line Imports\n=========================================\n\nAs of isort 3.1.0 support for balanced multi-line imports has been\nadded. With this enabled isort will dynamically change the import length\nto the one that produces the most balanced grid, while staying below the\nmaximum import length defined.\n\nExample:\n\n```python\nfrom __future__ import (absolute_import, division,\n                        print_function, unicode_literals)\n```\n\nWill be produced instead of:\n\n```python\nfrom __future__ import (absolute_import, division, print_function,\n                        unicode_literals)\n```\n\nTo enable this set `balanced_wrapping` to `True` in your config or pass\nthe `-e` option into the command line utility.\n\nCustom Sections and Ordering\n============================\n\nYou can change the section order with `sections` option from the default\nof:\n\n```ini\nFUTURE,STDLIB,THIRDPARTY,FIRSTPARTY,LOCALFOLDER\n```\n\nto your preference:\n\n```ini\nsections=FUTURE,STDLIB,FIRSTPARTY,THIRDPARTY,LOCALFOLDER\n```\n\nYou also can define your own sections and their order.\n\nExample:\n\n```ini\nknown_django=django\nknown_pandas=pandas,numpy\nsections=FUTURE,STDLIB,DJANGO,THIRDPARTY,PANDAS,FIRSTPARTY,LOCALFOLDER\n```\n\nwould create two new sections with the specified known modules.\n\nThe `no_lines_before` option will prevent the listed sections from being\nsplit from the previous section by an empty line.\n\nExample:\n\n```ini\nsections=FUTURE,STDLIB,THIRDPARTY,FIRSTPARTY,LOCALFOLDER\nno_lines_before=LOCALFOLDER\n```\n\nwould produce a section with both FIRSTPARTY and LOCALFOLDER modules\ncombined.\n\nAuto-comment import sections\n============================\n\nSome projects prefer to have import sections uniquely titled to aid in\nidentifying the sections quickly when visually scanning. isort can\nautomate this as well. To do this simply set the\n`import_heading_{section_name}` setting for each section you wish to\nhave auto commented - to the desired comment.\n\nFor Example:\n\n```ini\nimport_heading_stdlib=Standard Library\nimport_heading_firstparty=My Stuff\n```\n\nWould lead to output looking like the following:\n\n```python\n# Standard Library\nimport os\nimport sys\n\nimport django.settings\n\n# My Stuff\nimport myproject.test\n```\n\nOrdering by import length\n=========================\n\nisort also makes it easy to sort your imports by length, simply by\nsetting the `length_sort` option to `True`. This will result in the\nfollowing output style:\n\n```python\nfrom evn.util import (\n    Pool,\n    Dict,\n    Options,\n    Constant,\n    DecayDict,\n    UnexpectedCodePath,\n)\n```\n\nIt is also possible to opt-in to sorting imports by length for only\nspecific sections by using `length_sort_` followed by the section name\nas a configuration item, e.g.:\n\n    length_sort_stdlib=1\n\nSkip processing of imports (outside of configuration)\n=====================================================\n\nTo make isort ignore a single import simply add a comment at the end of\nthe import line containing the text `isort:skip`:\n\n```python\nimport module  # isort:skip\n```\n\nor:\n\n```python\nfrom xyz import (abc,  # isort:skip\n                 yo,\n                 hey)\n```\n\nTo make isort skip an entire file simply add `isort:skip_file` to the\nmodule\'s doc string:\n\n```python\n""" my_module.py\n    Best module ever\n\n   isort:skip_file\n"""\n\nimport b\nimport a\n```\n\nAdding an import to multiple files\n==================================\n\nisort makes it easy to add an import statement across multiple files,\nwhile being assured it\'s correctly placed.\n\nFrom the command line:\n\n```bash\nisort -a "from __future__ import print_function" *.py\n```\n\nfrom within Kate:\n\n```\nctrl+]\n```\n\nor:\n\n```\nmenu > Python > Add Import\n```\n\nRemoving an import from multiple files\n======================================\n\nisort also makes it easy to remove an import from multiple files,\nwithout having to be concerned with how it was originally formatted.\n\nFrom the command line:\n\n```bash\nisort -rm "os.system" *.py\n```\n\nfrom within Kate:\n\n```\nctrl+shift+]\n```\n\nor:\n\n```\nmenu > Python > Remove Import\n```\n\nUsing isort to verify code\n==========================\n\nThe `--check-only` option\n-------------------------\n\nisort can also be used to used to verify that code is correctly\nformatted by running it with `-c`. Any files that contain incorrectly\nsorted and/or formatted imports will be outputted to `stderr`.\n\n```bash\nisort **/*.py -c -v\n\nSUCCESS: /home/timothy/Projects/Open_Source/isort/isort_kate_plugin.py Everything Looks Good!\nERROR: /home/timothy/Projects/Open_Source/isort/isort/isort.py Imports are incorrectly sorted.\n```\n\nOne great place this can be used is with a pre-commit git hook, such as\nthis one by \\@acdha:\n\n<https://gist.github.com/acdha/8717683>\n\nThis can help to ensure a certain level of code quality throughout a\nproject.\n\nGit hook\n--------\n\nisort provides a hook function that can be integrated into your Git\npre-commit script to check Python code before committing.\n\nTo cause the commit to fail if there are isort errors (strict mode),\ninclude the following in `.git/hooks/pre-commit`:\n\n```python\n#!/usr/bin/env python\nimport sys\nfrom isort.hooks import git_hook\n\nsys.exit(git_hook(strict=True, modify=True))\n```\n\nIf you just want to display warnings, but allow the commit to happen\nanyway, call `git_hook` without the strict parameter. If you want to\ndisplay warnings, but not also fix the code, call `git_hook` without the\nmodify parameter.\n\nSetuptools integration\n----------------------\n\nUpon installation, isort enables a `setuptools` command that checks\nPython files declared by your project.\n\nRunning `python setup.py isort` on the command line will check the files\nlisted in your `py_modules` and `packages`. If any warning is found, the\ncommand will exit with an error code:\n\n```bash\n$ python setup.py isort\n```\n\nAlso, to allow users to be able to use the command without having to\ninstall isort themselves, add isort to the setup\\_requires of your\n`setup()` like so:\n\n```python\nsetup(\n    name="project",\n    packages=["project"],\n\n    setup_requires=[\n        "isort"\n    ]\n)\n```\n\nSecurity contact information\n==========\n\nTo report a security vulnerability, please use the [Tidelift security\ncontact](https://tidelift.com/security). Tidelift will coordinate the\nfix and disclosure.\n\nWhy isort?\n==========\n\nisort simply stands for import sort. It was originally called\n"sortImports" however I got tired of typing the extra characters and\ncame to the realization camelCase is not pythonic.\n\nI wrote isort because in an organization I used to work in the manager\ncame in one day and decided all code must have alphabetically sorted\nimports. The code base was huge - and he meant for us to do it by hand.\nHowever, being a programmer - I\\\'m too lazy to spend 8 hours mindlessly\nperforming a function, but not too lazy to spend 16 hours automating it.\nI was given permission to open source sortImports and here we are :)\n\n------------------------------------------------------------------------\n\n[Get professionally supported isort with the Tidelift\nSubscription](https://tidelift.com/subscription/pkg/pypi-isort?utm_source=pypi-isort&utm_medium=referral&utm_campaign=readme)\n\nProfessional support for isort is available as part of the [Tidelift\nSubscription](https://tidelift.com/subscription/pkg/pypi-isort?utm_source=pypi-isort&utm_medium=referral&utm_campaign=readme).\nTidelift gives software development teams a single source for purchasing\nand maintaining their software, with professional grade assurances from\nthe experts who know it best, while seamlessly integrating with existing\ntools.\n\n------------------------------------------------------------------------\n\nThanks and I hope you find isort useful!\n\n~Timothy Crosley\n',
    'author': 'Timothy Crosley',
    'author_email': 'timothy.crosley@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://timothycrosley.github.io/isort/',
    'packages': packages,
    'package_data': package_data,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
