# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.auto_discovery_method import AutoDiscoveryMethod  # noqa: F401,E501
from logicmonitor_sdk.models.ilp import ILP  # noqa: F401,E501
from logicmonitor_sdk.models.linked_wmi_class import LinkedWmiClass  # noqa: F401,E501


class WMIAutoDiscoveryMethod(AutoDiscoveryMethod):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'linked_classes': 'list[LinkedWmiClass]',
        'external_resource_id': 'str',
        'external_resource_type': 'str',
        'wmi_class': 'str',
        '_property': 'str',
        'namespace': 'str',
        'ilp': 'list[ILP]',
        'enable_linked_class_ilp': 'bool',
        'enable_wmi_class_ilp': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'linked_classes': 'linkedClasses',
        'external_resource_id': 'externalResourceID',
        'external_resource_type': 'externalResourceType',
        'wmi_class': 'wmiClass',
        '_property': 'property',
        'namespace': 'namespace',
        'ilp': 'ILP',
        'enable_linked_class_ilp': 'enableLinkedClassILP',
        'enable_wmi_class_ilp': 'enableWmiClassILP'
    }

    def __init__(self, name=None, linked_classes=None, external_resource_id=None, external_resource_type=None, wmi_class=None, _property=None, namespace=None, ilp=None, enable_linked_class_ilp=None, enable_wmi_class_ilp=None):  # noqa: E501
        """WMIAutoDiscoveryMethod - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._linked_classes = None
        self._external_resource_id = None
        self._external_resource_type = None
        self._wmi_class = None
        self.__property = None
        self._namespace = None
        self._ilp = None
        self._enable_linked_class_ilp = None
        self._enable_wmi_class_ilp = None
        self.discriminator = None

        self.name = name
        if linked_classes is not None:
            self.linked_classes = linked_classes
        if external_resource_id is not None:
            self.external_resource_id = external_resource_id
        if external_resource_type is not None:
            self.external_resource_type = external_resource_type
        self.wmi_class = wmi_class
        self._property = _property
        self.namespace = namespace
        if ilp is not None:
            self.ilp = ilp
        if enable_linked_class_ilp is not None:
            self.enable_linked_class_ilp = enable_linked_class_ilp
        if enable_wmi_class_ilp is not None:
            self.enable_wmi_class_ilp = enable_wmi_class_ilp

    @property
    def name(self):
        """Gets the name of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The name of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WMIAutoDiscoveryMethod.


        :param name: The name of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def linked_classes(self):
        """Gets the linked_classes of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The linked_classes of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: list[LinkedWmiClass]
        """
        return self._linked_classes

    @linked_classes.setter
    def linked_classes(self, linked_classes):
        """Sets the linked_classes of this WMIAutoDiscoveryMethod.


        :param linked_classes: The linked_classes of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: list[LinkedWmiClass]
        """

        self._linked_classes = linked_classes

    @property
    def external_resource_id(self):
        """Gets the external_resource_id of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The external_resource_id of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._external_resource_id

    @external_resource_id.setter
    def external_resource_id(self, external_resource_id):
        """Sets the external_resource_id of this WMIAutoDiscoveryMethod.


        :param external_resource_id: The external_resource_id of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._external_resource_id = external_resource_id

    @property
    def external_resource_type(self):
        """Gets the external_resource_type of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The external_resource_type of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._external_resource_type

    @external_resource_type.setter
    def external_resource_type(self, external_resource_type):
        """Sets the external_resource_type of this WMIAutoDiscoveryMethod.


        :param external_resource_type: The external_resource_type of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._external_resource_type = external_resource_type

    @property
    def wmi_class(self):
        """Gets the wmi_class of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The wmi_class of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._wmi_class

    @wmi_class.setter
    def wmi_class(self, wmi_class):
        """Sets the wmi_class of this WMIAutoDiscoveryMethod.


        :param wmi_class: The wmi_class of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if wmi_class is None:
            raise ValueError("Invalid value for `wmi_class`, must not be `None`")  # noqa: E501

        self._wmi_class = wmi_class

    @property
    def _property(self):
        """Gets the _property of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The _property of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self.__property

    @_property.setter
    def _property(self, _property):
        """Sets the _property of this WMIAutoDiscoveryMethod.


        :param _property: The _property of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if _property is None:
            raise ValueError("Invalid value for `_property`, must not be `None`")  # noqa: E501

        self.__property = _property

    @property
    def namespace(self):
        """Gets the namespace of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The namespace of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this WMIAutoDiscoveryMethod.


        :param namespace: The namespace of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if namespace is None:
            raise ValueError("Invalid value for `namespace`, must not be `None`")  # noqa: E501

        self._namespace = namespace

    @property
    def ilp(self):
        """Gets the ilp of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: list[ILP]
        """
        return self._ilp

    @ilp.setter
    def ilp(self, ilp):
        """Sets the ilp of this WMIAutoDiscoveryMethod.


        :param ilp: The ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: list[ILP]
        """

        self._ilp = ilp

    @property
    def enable_linked_class_ilp(self):
        """Gets the enable_linked_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The enable_linked_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: bool
        """
        return self._enable_linked_class_ilp

    @enable_linked_class_ilp.setter
    def enable_linked_class_ilp(self, enable_linked_class_ilp):
        """Sets the enable_linked_class_ilp of this WMIAutoDiscoveryMethod.


        :param enable_linked_class_ilp: The enable_linked_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: bool
        """

        self._enable_linked_class_ilp = enable_linked_class_ilp

    @property
    def enable_wmi_class_ilp(self):
        """Gets the enable_wmi_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501


        :return: The enable_wmi_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :rtype: bool
        """
        return self._enable_wmi_class_ilp

    @enable_wmi_class_ilp.setter
    def enable_wmi_class_ilp(self, enable_wmi_class_ilp):
        """Sets the enable_wmi_class_ilp of this WMIAutoDiscoveryMethod.


        :param enable_wmi_class_ilp: The enable_wmi_class_ilp of this WMIAutoDiscoveryMethod.  # noqa: E501
        :type: bool
        """

        self._enable_wmi_class_ilp = enable_wmi_class_ilp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WMIAutoDiscoveryMethod, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WMIAutoDiscoveryMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
