# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class WebsiteGroupData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'website_name': 'str',
        'website_group_name': 'str'
    }

    attribute_map = {
        'website_name': 'websiteName',
        'website_group_name': 'websiteGroupName'
    }

    def __init__(self, website_name=None, website_group_name=None):  # noqa: E501
        """WebsiteGroupData - a model defined in Swagger"""  # noqa: E501

        self._website_name = None
        self._website_group_name = None
        self.discriminator = None

        self.website_name = website_name
        self.website_group_name = website_group_name

    @property
    def website_name(self):
        """Gets the website_name of this WebsiteGroupData.  # noqa: E501

        The name of the website status should be displayed  # noqa: E501

        :return: The website_name of this WebsiteGroupData.  # noqa: E501
        :rtype: str
        """
        return self._website_name

    @website_name.setter
    def website_name(self, website_name):
        """Sets the website_name of this WebsiteGroupData.

        The name of the website status should be displayed  # noqa: E501

        :param website_name: The website_name of this WebsiteGroupData.  # noqa: E501
        :type: str
        """
        if website_name is None:
            raise ValueError("Invalid value for `website_name`, must not be `None`")  # noqa: E501

        self._website_name = website_name

    @property
    def website_group_name(self):
        """Gets the website_group_name of this WebsiteGroupData.  # noqa: E501

        The name of the group for which member website status should be displayed  # noqa: E501

        :return: The website_group_name of this WebsiteGroupData.  # noqa: E501
        :rtype: str
        """
        return self._website_group_name

    @website_group_name.setter
    def website_group_name(self, website_group_name):
        """Sets the website_group_name of this WebsiteGroupData.

        The name of the group for which member website status should be displayed  # noqa: E501

        :param website_group_name: The website_group_name of this WebsiteGroupData.  # noqa: E501
        :type: str
        """
        if website_group_name is None:
            raise ValueError("Invalid value for `website_group_name`, must not be `None`")  # noqa: E501

        self._website_group_name = website_group_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebsiteGroupData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebsiteGroupData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
