# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.name_and_value import NameAndValue  # noqa: F401,E501
from logicmonitor_sdk.models.website_location import WebsiteLocation  # noqa: F401,E501


class WebsiteGroup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'full_path': 'str',
        'stop_monitoring': 'bool',
        'user_permission': 'str',
        'test_location': 'WebsiteLocation',
        'has_websites_disabled': 'bool',
        'description': 'str',
        'disable_alerting': 'bool',
        'parent_id': 'int',
        'num_of_direct_websites': 'int',
        'name': 'str',
        'num_of_direct_sub_groups': 'int',
        'id': 'int',
        'num_of_websites': 'int',
        'properties': 'list[NameAndValue]'
    }

    attribute_map = {
        'full_path': 'fullPath',
        'stop_monitoring': 'stopMonitoring',
        'user_permission': 'userPermission',
        'test_location': 'testLocation',
        'has_websites_disabled': 'hasWebsitesDisabled',
        'description': 'description',
        'disable_alerting': 'disableAlerting',
        'parent_id': 'parentId',
        'num_of_direct_websites': 'numOfDirectWebsites',
        'name': 'name',
        'num_of_direct_sub_groups': 'numOfDirectSubGroups',
        'id': 'id',
        'num_of_websites': 'numOfWebsites',
        'properties': 'properties'
    }

    def __init__(self, full_path=None, stop_monitoring=None, user_permission=None, test_location=None, has_websites_disabled=None, description=None, disable_alerting=None, parent_id=None, num_of_direct_websites=None, name=None, num_of_direct_sub_groups=None, id=None, num_of_websites=None, properties=None):  # noqa: E501
        """WebsiteGroup - a model defined in Swagger"""  # noqa: E501

        self._full_path = None
        self._stop_monitoring = None
        self._user_permission = None
        self._test_location = None
        self._has_websites_disabled = None
        self._description = None
        self._disable_alerting = None
        self._parent_id = None
        self._num_of_direct_websites = None
        self._name = None
        self._num_of_direct_sub_groups = None
        self._id = None
        self._num_of_websites = None
        self._properties = None
        self.discriminator = None

        if full_path is not None:
            self.full_path = full_path
        if stop_monitoring is not None:
            self.stop_monitoring = stop_monitoring
        if user_permission is not None:
            self.user_permission = user_permission
        if test_location is not None:
            self.test_location = test_location
        if has_websites_disabled is not None:
            self.has_websites_disabled = has_websites_disabled
        if description is not None:
            self.description = description
        if disable_alerting is not None:
            self.disable_alerting = disable_alerting
        if parent_id is not None:
            self.parent_id = parent_id
        if num_of_direct_websites is not None:
            self.num_of_direct_websites = num_of_direct_websites
        self.name = name
        if num_of_direct_sub_groups is not None:
            self.num_of_direct_sub_groups = num_of_direct_sub_groups
        if id is not None:
            self.id = id
        if num_of_websites is not None:
            self.num_of_websites = num_of_websites
        if properties is not None:
            self.properties = properties

    @property
    def full_path(self):
        """Gets the full_path of this WebsiteGroup.  # noqa: E501

        The full path of the group  # noqa: E501

        :return: The full_path of this WebsiteGroup.  # noqa: E501
        :rtype: str
        """
        return self._full_path

    @full_path.setter
    def full_path(self, full_path):
        """Sets the full_path of this WebsiteGroup.

        The full path of the group  # noqa: E501

        :param full_path: The full_path of this WebsiteGroup.  # noqa: E501
        :type: str
        """

        self._full_path = full_path

    @property
    def stop_monitoring(self):
        """Gets the stop_monitoring of this WebsiteGroup.  # noqa: E501

        true: monitoring is disabled for the websites in the group false: monitoring is enabled for the websites in the group If stopMonitoring=true, then alerting will also by default be disabled for the websites in the group  # noqa: E501

        :return: The stop_monitoring of this WebsiteGroup.  # noqa: E501
        :rtype: bool
        """
        return self._stop_monitoring

    @stop_monitoring.setter
    def stop_monitoring(self, stop_monitoring):
        """Sets the stop_monitoring of this WebsiteGroup.

        true: monitoring is disabled for the websites in the group false: monitoring is enabled for the websites in the group If stopMonitoring=true, then alerting will also by default be disabled for the websites in the group  # noqa: E501

        :param stop_monitoring: The stop_monitoring of this WebsiteGroup.  # noqa: E501
        :type: bool
        """

        self._stop_monitoring = stop_monitoring

    @property
    def user_permission(self):
        """Gets the user_permission of this WebsiteGroup.  # noqa: E501

        The permission level of the user that made the API request. Acceptable values are: write, read, ack  # noqa: E501

        :return: The user_permission of this WebsiteGroup.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this WebsiteGroup.

        The permission level of the user that made the API request. Acceptable values are: write, read, ack  # noqa: E501

        :param user_permission: The user_permission of this WebsiteGroup.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def test_location(self):
        """Gets the test_location of this WebsiteGroup.  # noqa: E501


        :return: The test_location of this WebsiteGroup.  # noqa: E501
        :rtype: WebsiteLocation
        """
        return self._test_location

    @test_location.setter
    def test_location(self, test_location):
        """Sets the test_location of this WebsiteGroup.


        :param test_location: The test_location of this WebsiteGroup.  # noqa: E501
        :type: WebsiteLocation
        """

        self._test_location = test_location

    @property
    def has_websites_disabled(self):
        """Gets the has_websites_disabled of this WebsiteGroup.  # noqa: E501


        :return: The has_websites_disabled of this WebsiteGroup.  # noqa: E501
        :rtype: bool
        """
        return self._has_websites_disabled

    @has_websites_disabled.setter
    def has_websites_disabled(self, has_websites_disabled):
        """Sets the has_websites_disabled of this WebsiteGroup.


        :param has_websites_disabled: The has_websites_disabled of this WebsiteGroup.  # noqa: E501
        :type: bool
        """

        self._has_websites_disabled = has_websites_disabled

    @property
    def description(self):
        """Gets the description of this WebsiteGroup.  # noqa: E501

        The description of the group  # noqa: E501

        :return: The description of this WebsiteGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this WebsiteGroup.

        The description of the group  # noqa: E501

        :param description: The description of this WebsiteGroup.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def disable_alerting(self):
        """Gets the disable_alerting of this WebsiteGroup.  # noqa: E501

        true: alerting is disabled for the websites in the group false: alerting is enabled for the websites in the group If stopMonitoring=true, then alerting will also by default be disabled for the websites in the group  # noqa: E501

        :return: The disable_alerting of this WebsiteGroup.  # noqa: E501
        :rtype: bool
        """
        return self._disable_alerting

    @disable_alerting.setter
    def disable_alerting(self, disable_alerting):
        """Sets the disable_alerting of this WebsiteGroup.

        true: alerting is disabled for the websites in the group false: alerting is enabled for the websites in the group If stopMonitoring=true, then alerting will also by default be disabled for the websites in the group  # noqa: E501

        :param disable_alerting: The disable_alerting of this WebsiteGroup.  # noqa: E501
        :type: bool
        """

        self._disable_alerting = disable_alerting

    @property
    def parent_id(self):
        """Gets the parent_id of this WebsiteGroup.  # noqa: E501

        The Id of the parent group. If parentId=1 then the group exists under the root  group  # noqa: E501

        :return: The parent_id of this WebsiteGroup.  # noqa: E501
        :rtype: int
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this WebsiteGroup.

        The Id of the parent group. If parentId=1 then the group exists under the root  group  # noqa: E501

        :param parent_id: The parent_id of this WebsiteGroup.  # noqa: E501
        :type: int
        """

        self._parent_id = parent_id

    @property
    def num_of_direct_websites(self):
        """Gets the num_of_direct_websites of this WebsiteGroup.  # noqa: E501


        :return: The num_of_direct_websites of this WebsiteGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_direct_websites

    @num_of_direct_websites.setter
    def num_of_direct_websites(self, num_of_direct_websites):
        """Sets the num_of_direct_websites of this WebsiteGroup.


        :param num_of_direct_websites: The num_of_direct_websites of this WebsiteGroup.  # noqa: E501
        :type: int
        """

        self._num_of_direct_websites = num_of_direct_websites

    @property
    def name(self):
        """Gets the name of this WebsiteGroup.  # noqa: E501

        The name of the group  # noqa: E501

        :return: The name of this WebsiteGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WebsiteGroup.

        The name of the group  # noqa: E501

        :param name: The name of this WebsiteGroup.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def num_of_direct_sub_groups(self):
        """Gets the num_of_direct_sub_groups of this WebsiteGroup.  # noqa: E501

        The number of direct website groups in this group (exlcuding those in subgroups)  # noqa: E501

        :return: The num_of_direct_sub_groups of this WebsiteGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_direct_sub_groups

    @num_of_direct_sub_groups.setter
    def num_of_direct_sub_groups(self, num_of_direct_sub_groups):
        """Sets the num_of_direct_sub_groups of this WebsiteGroup.

        The number of direct website groups in this group (exlcuding those in subgroups)  # noqa: E501

        :param num_of_direct_sub_groups: The num_of_direct_sub_groups of this WebsiteGroup.  # noqa: E501
        :type: int
        """

        self._num_of_direct_sub_groups = num_of_direct_sub_groups

    @property
    def id(self):
        """Gets the id of this WebsiteGroup.  # noqa: E501

        The Id of the group  # noqa: E501

        :return: The id of this WebsiteGroup.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WebsiteGroup.

        The Id of the group  # noqa: E501

        :param id: The id of this WebsiteGroup.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def num_of_websites(self):
        """Gets the num_of_websites of this WebsiteGroup.  # noqa: E501


        :return: The num_of_websites of this WebsiteGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_websites

    @num_of_websites.setter
    def num_of_websites(self, num_of_websites):
        """Sets the num_of_websites of this WebsiteGroup.


        :param num_of_websites: The num_of_websites of this WebsiteGroup.  # noqa: E501
        :type: int
        """

        self._num_of_websites = num_of_websites

    @property
    def properties(self):
        """Gets the properties of this WebsiteGroup.  # noqa: E501


        :return: The properties of this WebsiteGroup.  # noqa: E501
        :rtype: list[NameAndValue]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this WebsiteGroup.


        :param properties: The properties of this WebsiteGroup.  # noqa: E501
        :type: list[NameAndValue]
        """

        self._properties = properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebsiteGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebsiteGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
