# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class UserFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_only_user': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'enable2fa': 'str',
        'role_assignment': 'str',
        'email': 'str',
        'status': 'str',
        'username': 'str'
    }

    attribute_map = {
        'api_only_user': 'apiOnlyUser',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'enable2fa': 'enable2fa',
        'role_assignment': 'roleAssignment',
        'email': 'email',
        'status': 'status',
        'username': 'username'
    }

    def __init__(self, api_only_user=None, first_name=None, last_name=None, enable2fa=None, role_assignment=None, email=None, status=None, username=None):  # noqa: E501
        """UserFilter - a model defined in Swagger"""  # noqa: E501

        self._api_only_user = None
        self._first_name = None
        self._last_name = None
        self._enable2fa = None
        self._role_assignment = None
        self._email = None
        self._status = None
        self._username = None
        self.discriminator = None

        if api_only_user is not None:
            self.api_only_user = api_only_user
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if enable2fa is not None:
            self.enable2fa = enable2fa
        if role_assignment is not None:
            self.role_assignment = role_assignment
        if email is not None:
            self.email = email
        if status is not None:
            self.status = status
        if username is not None:
            self.username = username

    @property
    def api_only_user(self):
        """Gets the api_only_user of this UserFilter.  # noqa: E501

        If the user is API only user. Acceptable values are: all, yes, no  # noqa: E501

        :return: The api_only_user of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._api_only_user

    @api_only_user.setter
    def api_only_user(self, api_only_user):
        """Sets the api_only_user of this UserFilter.

        If the user is API only user. Acceptable values are: all, yes, no  # noqa: E501

        :param api_only_user: The api_only_user of this UserFilter.  # noqa: E501
        :type: str
        """

        self._api_only_user = api_only_user

    @property
    def first_name(self):
        """Gets the first_name of this UserFilter.  # noqa: E501

        The first name of the user  # noqa: E501

        :return: The first_name of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this UserFilter.

        The first name of the user  # noqa: E501

        :param first_name: The first_name of this UserFilter.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this UserFilter.  # noqa: E501

        The last name of the user  # noqa: E501

        :return: The last_name of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this UserFilter.

        The last name of the user  # noqa: E501

        :param last_name: The last_name of this UserFilter.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def enable2fa(self):
        """Gets the enable2fa of this UserFilter.  # noqa: E501

        Whether does the user enabled 2FA. Acceptable values are: all, yes, no  # noqa: E501

        :return: The enable2fa of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._enable2fa

    @enable2fa.setter
    def enable2fa(self, enable2fa):
        """Sets the enable2fa of this UserFilter.

        Whether does the user enabled 2FA. Acceptable values are: all, yes, no  # noqa: E501

        :param enable2fa: The enable2fa of this UserFilter.  # noqa: E501
        :type: str
        """

        self._enable2fa = enable2fa

    @property
    def role_assignment(self):
        """Gets the role_assignment of this UserFilter.  # noqa: E501

        Which roles is the user belongs to  # noqa: E501

        :return: The role_assignment of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._role_assignment

    @role_assignment.setter
    def role_assignment(self, role_assignment):
        """Sets the role_assignment of this UserFilter.

        Which roles is the user belongs to  # noqa: E501

        :param role_assignment: The role_assignment of this UserFilter.  # noqa: E501
        :type: str
        """

        self._role_assignment = role_assignment

    @property
    def email(self):
        """Gets the email of this UserFilter.  # noqa: E501

        The emails of the user  # noqa: E501

        :return: The email of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserFilter.

        The emails of the user  # noqa: E501

        :param email: The email of this UserFilter.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def status(self):
        """Gets the status of this UserFilter.  # noqa: E501

        The user status. Acceptable values are: all, active, suspended  # noqa: E501

        :return: The status of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this UserFilter.

        The user status. Acceptable values are: all, active, suspended  # noqa: E501

        :param status: The status of this UserFilter.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def username(self):
        """Gets the username of this UserFilter.  # noqa: E501

        The username of the user  # noqa: E501

        :return: The username of this UserFilter.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UserFilter.

        The username of the user  # noqa: E501

        :param username: The username of this UserFilter.  # noqa: E501
        :type: str
        """

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
