# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TableWidgetForecastConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'severity': 'str',
        'confidence': 'int',
        'time_range': 'str',
        'algorithm': 'str'
    }

    attribute_map = {
        'severity': 'severity',
        'confidence': 'confidence',
        'time_range': 'timeRange',
        'algorithm': 'algorithm'
    }

    def __init__(self, severity=None, confidence=None, time_range=None, algorithm=None):  # noqa: E501
        """TableWidgetForecastConfiguration - a model defined in Swagger"""  # noqa: E501

        self._severity = None
        self._confidence = None
        self._time_range = None
        self._algorithm = None
        self.discriminator = None

        if severity is not None:
            self.severity = severity
        if confidence is not None:
            self.confidence = confidence
        if time_range is not None:
            self.time_range = time_range
        if algorithm is not None:
            self.algorithm = algorithm

    @property
    def severity(self):
        """Gets the severity of this TableWidgetForecastConfiguration.  # noqa: E501

         The minimum alert severity the forecasting should include, one of warn | error | critical  # noqa: E501

        :return: The severity of this TableWidgetForecastConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this TableWidgetForecastConfiguration.

         The minimum alert severity the forecasting should include, one of warn | error | critical  # noqa: E501

        :param severity: The severity of this TableWidgetForecastConfiguration.  # noqa: E501
        :type: str
        """

        self._severity = severity

    @property
    def confidence(self):
        """Gets the confidence of this TableWidgetForecastConfiguration.  # noqa: E501

        The percent confidence that should be required for a forecasted alert.  # noqa: E501

        :return: The confidence of this TableWidgetForecastConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """Sets the confidence of this TableWidgetForecastConfiguration.

        The percent confidence that should be required for a forecasted alert.  # noqa: E501

        :param confidence: The confidence of this TableWidgetForecastConfiguration.  # noqa: E501
        :type: int
        """

        self._confidence = confidence

    @property
    def time_range(self):
        """Gets the time_range of this TableWidgetForecastConfiguration.  # noqa: E501

        The training data time range (the data on which forecasting is calculated). Options are Last 7 days, Last 14 days, Last 30 days, Last calendar month, Last 365 days or a custom time range  # noqa: E501

        :return: The time_range of this TableWidgetForecastConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._time_range

    @time_range.setter
    def time_range(self, time_range):
        """Sets the time_range of this TableWidgetForecastConfiguration.

        The training data time range (the data on which forecasting is calculated). Options are Last 7 days, Last 14 days, Last 30 days, Last calendar month, Last 365 days or a custom time range  # noqa: E501

        :param time_range: The time_range of this TableWidgetForecastConfiguration.  # noqa: E501
        :type: str
        """

        self._time_range = time_range

    @property
    def algorithm(self):
        """Gets the algorithm of this TableWidgetForecastConfiguration.  # noqa: E501

        Forecast method for the widget :Linear | ARIMA  # noqa: E501

        :return: The algorithm of this TableWidgetForecastConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        """Sets the algorithm of this TableWidgetForecastConfiguration.

        Forecast method for the widget :Linear | ARIMA  # noqa: E501

        :param algorithm: The algorithm of this TableWidgetForecastConfiguration.  # noqa: E501
        :type: str
        """

        self._algorithm = algorithm

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TableWidgetForecastConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TableWidgetForecastConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
