# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.table_widget_data_point import TableWidgetDataPoint  # noqa: F401,E501


class TableWidgetColumn(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alternate_data_points': 'list[TableWidgetDataPoint]',
        'rpn': 'str',
        'data_point': 'TableWidgetDataPoint',
        'column_name': 'str',
        'enable_forecast': 'bool',
        'rounding_decimal': 'int'
    }

    attribute_map = {
        'alternate_data_points': 'alternateDataPoints',
        'rpn': 'rpn',
        'data_point': 'dataPoint',
        'column_name': 'columnName',
        'enable_forecast': 'enableForecast',
        'rounding_decimal': 'roundingDecimal'
    }

    def __init__(self, alternate_data_points=None, rpn=None, data_point=None, column_name=None, enable_forecast=None, rounding_decimal=None):  # noqa: E501
        """TableWidgetColumn - a model defined in Swagger"""  # noqa: E501

        self._alternate_data_points = None
        self._rpn = None
        self._data_point = None
        self._column_name = None
        self._enable_forecast = None
        self._rounding_decimal = None
        self.discriminator = None

        if alternate_data_points is not None:
            self.alternate_data_points = alternate_data_points
        if rpn is not None:
            self.rpn = rpn
        self.data_point = data_point
        self.column_name = column_name
        if enable_forecast is not None:
            self.enable_forecast = enable_forecast
        if rounding_decimal is not None:
            self.rounding_decimal = rounding_decimal

    @property
    def alternate_data_points(self):
        """Gets the alternate_data_points of this TableWidgetColumn.  # noqa: E501


        :return: The alternate_data_points of this TableWidgetColumn.  # noqa: E501
        :rtype: list[TableWidgetDataPoint]
        """
        return self._alternate_data_points

    @alternate_data_points.setter
    def alternate_data_points(self, alternate_data_points):
        """Sets the alternate_data_points of this TableWidgetColumn.


        :param alternate_data_points: The alternate_data_points of this TableWidgetColumn.  # noqa: E501
        :type: list[TableWidgetDataPoint]
        """

        self._alternate_data_points = alternate_data_points

    @property
    def rpn(self):
        """Gets the rpn of this TableWidgetColumn.  # noqa: E501


        :return: The rpn of this TableWidgetColumn.  # noqa: E501
        :rtype: str
        """
        return self._rpn

    @rpn.setter
    def rpn(self, rpn):
        """Sets the rpn of this TableWidgetColumn.


        :param rpn: The rpn of this TableWidgetColumn.  # noqa: E501
        :type: str
        """

        self._rpn = rpn

    @property
    def data_point(self):
        """Gets the data_point of this TableWidgetColumn.  # noqa: E501


        :return: The data_point of this TableWidgetColumn.  # noqa: E501
        :rtype: TableWidgetDataPoint
        """
        return self._data_point

    @data_point.setter
    def data_point(self, data_point):
        """Sets the data_point of this TableWidgetColumn.


        :param data_point: The data_point of this TableWidgetColumn.  # noqa: E501
        :type: TableWidgetDataPoint
        """
        if data_point is None:
            raise ValueError("Invalid value for `data_point`, must not be `None`")  # noqa: E501

        self._data_point = data_point

    @property
    def column_name(self):
        """Gets the column_name of this TableWidgetColumn.  # noqa: E501


        :return: The column_name of this TableWidgetColumn.  # noqa: E501
        :rtype: str
        """
        return self._column_name

    @column_name.setter
    def column_name(self, column_name):
        """Sets the column_name of this TableWidgetColumn.


        :param column_name: The column_name of this TableWidgetColumn.  # noqa: E501
        :type: str
        """
        if column_name is None:
            raise ValueError("Invalid value for `column_name`, must not be `None`")  # noqa: E501

        self._column_name = column_name

    @property
    def enable_forecast(self):
        """Gets the enable_forecast of this TableWidgetColumn.  # noqa: E501


        :return: The enable_forecast of this TableWidgetColumn.  # noqa: E501
        :rtype: bool
        """
        return self._enable_forecast

    @enable_forecast.setter
    def enable_forecast(self, enable_forecast):
        """Sets the enable_forecast of this TableWidgetColumn.


        :param enable_forecast: The enable_forecast of this TableWidgetColumn.  # noqa: E501
        :type: bool
        """

        self._enable_forecast = enable_forecast

    @property
    def rounding_decimal(self):
        """Gets the rounding_decimal of this TableWidgetColumn.  # noqa: E501


        :return: The rounding_decimal of this TableWidgetColumn.  # noqa: E501
        :rtype: int
        """
        return self._rounding_decimal

    @rounding_decimal.setter
    def rounding_decimal(self, rounding_decimal):
        """Sets the rounding_decimal of this TableWidgetColumn.


        :param rounding_decimal: The rounding_decimal of this TableWidgetColumn.  # noqa: E501
        :type: int
        """

        self._rounding_decimal = rounding_decimal

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TableWidgetColumn, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TableWidgetColumn):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
