# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SDTHistory(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'duration': 'int',
        'item_id': 'int',
        'end_epoch': 'int',
        'admin': 'str',
        'comment': 'str',
        'id': 'str',
        'type': 'str',
        'start_epoch': 'int'
    }

    attribute_map = {
        'duration': 'duration',
        'item_id': 'itemId',
        'end_epoch': 'endEpoch',
        'admin': 'admin',
        'comment': 'comment',
        'id': 'id',
        'type': 'type',
        'start_epoch': 'startEpoch'
    }

    def __init__(self, duration=None, item_id=None, end_epoch=None, admin=None, comment=None, id=None, type=None, start_epoch=None):  # noqa: E501
        """SDTHistory - a model defined in Swagger"""  # noqa: E501

        self._duration = None
        self._item_id = None
        self._end_epoch = None
        self._admin = None
        self._comment = None
        self._id = None
        self._type = None
        self._start_epoch = None
        self.discriminator = None

        if duration is not None:
            self.duration = duration
        if item_id is not None:
            self.item_id = item_id
        if end_epoch is not None:
            self.end_epoch = end_epoch
        if admin is not None:
            self.admin = admin
        if comment is not None:
            self.comment = comment
        if id is not None:
            self.id = id
        if type is not None:
            self.type = type
        if start_epoch is not None:
            self.start_epoch = start_epoch

    @property
    def duration(self):
        """Gets the duration of this SDTHistory.  # noqa: E501

        The duration of the SDT, in minutes  # noqa: E501

        :return: The duration of this SDTHistory.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this SDTHistory.

        The duration of the SDT, in minutes  # noqa: E501

        :param duration: The duration of this SDTHistory.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def item_id(self):
        """Gets the item_id of this SDTHistory.  # noqa: E501

        The ID of the resource in SDT, e.g. the group or device in SDT  # noqa: E501

        :return: The item_id of this SDTHistory.  # noqa: E501
        :rtype: int
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this SDTHistory.

        The ID of the resource in SDT, e.g. the group or device in SDT  # noqa: E501

        :param item_id: The item_id of this SDTHistory.  # noqa: E501
        :type: int
        """

        self._item_id = item_id

    @property
    def end_epoch(self):
        """Gets the end_epoch of this SDTHistory.  # noqa: E501

        The end epoch for the SDT  # noqa: E501

        :return: The end_epoch of this SDTHistory.  # noqa: E501
        :rtype: int
        """
        return self._end_epoch

    @end_epoch.setter
    def end_epoch(self, end_epoch):
        """Sets the end_epoch of this SDTHistory.

        The end epoch for the SDT  # noqa: E501

        :param end_epoch: The end_epoch of this SDTHistory.  # noqa: E501
        :type: int
        """

        self._end_epoch = end_epoch

    @property
    def admin(self):
        """Gets the admin of this SDTHistory.  # noqa: E501

        The user that added the SDT  # noqa: E501

        :return: The admin of this SDTHistory.  # noqa: E501
        :rtype: str
        """
        return self._admin

    @admin.setter
    def admin(self, admin):
        """Sets the admin of this SDTHistory.

        The user that added the SDT  # noqa: E501

        :param admin: The admin of this SDTHistory.  # noqa: E501
        :type: str
        """

        self._admin = admin

    @property
    def comment(self):
        """Gets the comment of this SDTHistory.  # noqa: E501

        The comment associated with the SDT  # noqa: E501

        :return: The comment of this SDTHistory.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this SDTHistory.

        The comment associated with the SDT  # noqa: E501

        :param comment: The comment of this SDTHistory.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def id(self):
        """Gets the id of this SDTHistory.  # noqa: E501

        The ID of the SDT  # noqa: E501

        :return: The id of this SDTHistory.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SDTHistory.

        The ID of the SDT  # noqa: E501

        :param id: The id of this SDTHistory.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this SDTHistory.  # noqa: E501

        The SDT type  # noqa: E501

        :return: The type of this SDTHistory.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SDTHistory.

        The SDT type  # noqa: E501

        :param type: The type of this SDTHistory.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def start_epoch(self):
        """Gets the start_epoch of this SDTHistory.  # noqa: E501

        The start epoch for the SDT  # noqa: E501

        :return: The start_epoch of this SDTHistory.  # noqa: E501
        :rtype: int
        """
        return self._start_epoch

    @start_epoch.setter
    def start_epoch(self, start_epoch):
        """Sets the start_epoch of this SDTHistory.

        The start epoch for the SDT  # noqa: E501

        :param start_epoch: The start_epoch of this SDTHistory.  # noqa: E501
        :type: int
        """

        self._start_epoch = start_epoch

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SDTHistory, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SDTHistory):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
