# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.exclude_duplicate_ips import ExcludeDuplicateIps  # noqa: F401,E501
from logicmonitor_sdk.models.netscan import Netscan  # noqa: F401,E501
from logicmonitor_sdk.models.rest_schedule import RestSchedule  # noqa: F401,E501


class ScriptNetscan(Netscan):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'creator': 'str',
        'collector_group_name': 'str',
        'method': 'str',
        'collector_group': 'int',
        'description': 'str',
        'next_start': 'str',
        'duplicate': 'ExcludeDuplicateIps',
        'version': 'int',
        'collector': 'int',
        'ignore_system_i_ps_duplicates': 'bool',
        'schedule': 'RestSchedule',
        'collector_description': 'str',
        'name': 'str',
        'next_start_epoch': 'int',
        'id': 'int',
        'nsg_id': 'int',
        'group': 'str',
        'script_path': 'str',
        'default_group_full_path': 'str',
        'default_group': 'int',
        'groovy_script': 'str',
        'linux_script_params': 'str',
        'script_type': 'str',
        'groovy_script_params': 'str',
        'windows_script': 'str',
        'windows_script_params': 'str',
        'script_params': 'str',
        'linux_script': 'str'
    }

    attribute_map = {
        'creator': 'creator',
        'collector_group_name': 'collectorGroupName',
        'method': 'method',
        'collector_group': 'collectorGroup',
        'description': 'description',
        'next_start': 'nextStart',
        'duplicate': 'duplicate',
        'version': 'version',
        'collector': 'collector',
        'ignore_system_i_ps_duplicates': 'ignoreSystemIPsDuplicates',
        'schedule': 'schedule',
        'collector_description': 'collectorDescription',
        'name': 'name',
        'next_start_epoch': 'nextStartEpoch',
        'id': 'id',
        'nsg_id': 'nsgId',
        'group': 'group',
        'script_path': 'scriptPath',
        'default_group_full_path': 'defaultGroupFullPath',
        'default_group': 'defaultGroup',
        'groovy_script': 'groovyScript',
        'linux_script_params': 'linuxScriptParams',
        'script_type': 'scriptType',
        'groovy_script_params': 'groovyScriptParams',
        'windows_script': 'windowsScript',
        'windows_script_params': 'windowsScriptParams',
        'script_params': 'scriptParams',
        'linux_script': 'linuxScript'
    }

    def __init__(self, creator=None, collector_group_name=None, method=None, collector_group=None, description=None, next_start=None, duplicate=None, version=None, collector=None, ignore_system_i_ps_duplicates=None, schedule=None, collector_description=None, name=None, next_start_epoch=None, id=None, nsg_id=None, group=None, script_path=None, default_group_full_path=None, default_group=None, groovy_script=None, linux_script_params=None, script_type=None, groovy_script_params=None, windows_script=None, windows_script_params=None, script_params=None, linux_script=None):  # noqa: E501
        """ScriptNetscan - a model defined in Swagger"""  # noqa: E501

        self._creator = None
        self._collector_group_name = None
        self._method = None
        self._collector_group = None
        self._description = None
        self._next_start = None
        self._duplicate = None
        self._version = None
        self._collector = None
        self._ignore_system_i_ps_duplicates = None
        self._schedule = None
        self._collector_description = None
        self._name = None
        self._next_start_epoch = None
        self._id = None
        self._nsg_id = None
        self._group = None
        self._script_path = None
        self._default_group_full_path = None
        self._default_group = None
        self._groovy_script = None
        self._linux_script_params = None
        self._script_type = None
        self._groovy_script_params = None
        self._windows_script = None
        self._windows_script_params = None
        self._script_params = None
        self._linux_script = None
        self.discriminator = None

        if creator is not None:
            self.creator = creator
        if collector_group_name is not None:
            self.collector_group_name = collector_group_name
        self.method = method
        if collector_group is not None:
            self.collector_group = collector_group
        if description is not None:
            self.description = description
        if next_start is not None:
            self.next_start = next_start
        self.duplicate = duplicate
        if version is not None:
            self.version = version
        self.collector = collector
        if ignore_system_i_ps_duplicates is not None:
            self.ignore_system_i_ps_duplicates = ignore_system_i_ps_duplicates
        if schedule is not None:
            self.schedule = schedule
        if collector_description is not None:
            self.collector_description = collector_description
        self.name = name
        if next_start_epoch is not None:
            self.next_start_epoch = next_start_epoch
        if id is not None:
            self.id = id
        if nsg_id is not None:
            self.nsg_id = nsg_id
        if group is not None:
            self.group = group
        if script_path is not None:
            self.script_path = script_path
        if default_group_full_path is not None:
            self.default_group_full_path = default_group_full_path
        if default_group is not None:
            self.default_group = default_group
        if groovy_script is not None:
            self.groovy_script = groovy_script
        if linux_script_params is not None:
            self.linux_script_params = linux_script_params
        self.script_type = script_type
        if groovy_script_params is not None:
            self.groovy_script_params = groovy_script_params
        if windows_script is not None:
            self.windows_script = windows_script
        if windows_script_params is not None:
            self.windows_script_params = windows_script_params
        if script_params is not None:
            self.script_params = script_params
        if linux_script is not None:
            self.linux_script = linux_script

    @property
    def creator(self):
        """Gets the creator of this ScriptNetscan.  # noqa: E501

        The user that created the policy  # noqa: E501

        :return: The creator of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._creator

    @creator.setter
    def creator(self, creator):
        """Sets the creator of this ScriptNetscan.

        The user that created the policy  # noqa: E501

        :param creator: The creator of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._creator = creator

    @property
    def collector_group_name(self):
        """Gets the collector_group_name of this ScriptNetscan.  # noqa: E501

        The name of the group of the Collector associated with this Netscan  # noqa: E501

        :return: The collector_group_name of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._collector_group_name

    @collector_group_name.setter
    def collector_group_name(self, collector_group_name):
        """Sets the collector_group_name of this ScriptNetscan.

        The name of the group of the Collector associated with this Netscan  # noqa: E501

        :param collector_group_name: The collector_group_name of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._collector_group_name = collector_group_name

    @property
    def method(self):
        """Gets the method of this ScriptNetscan.  # noqa: E501

        The method that should be used to discover devices. Options are nmap (ICMP Ping), nec2 (EC2), and script  # noqa: E501

        :return: The method of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this ScriptNetscan.

        The method that should be used to discover devices. Options are nmap (ICMP Ping), nec2 (EC2), and script  # noqa: E501

        :param method: The method of this ScriptNetscan.  # noqa: E501
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501

        self._method = method

    @property
    def collector_group(self):
        """Gets the collector_group of this ScriptNetscan.  # noqa: E501

        The ID of the group of the Collector associated with this Netscan  # noqa: E501

        :return: The collector_group of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._collector_group

    @collector_group.setter
    def collector_group(self, collector_group):
        """Sets the collector_group of this ScriptNetscan.

        The ID of the group of the Collector associated with this Netscan  # noqa: E501

        :param collector_group: The collector_group of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._collector_group = collector_group

    @property
    def description(self):
        """Gets the description of this ScriptNetscan.  # noqa: E501

        The description of the Netscan Policy  # noqa: E501

        :return: The description of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ScriptNetscan.

        The description of the Netscan Policy  # noqa: E501

        :param description: The description of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def next_start(self):
        """Gets the next_start of this ScriptNetscan.  # noqa: E501

        The date and time of the next start time of the scan - displayed as manual if the scan does not run on a schedule  # noqa: E501

        :return: The next_start of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._next_start

    @next_start.setter
    def next_start(self, next_start):
        """Sets the next_start of this ScriptNetscan.

        The date and time of the next start time of the scan - displayed as manual if the scan does not run on a schedule  # noqa: E501

        :param next_start: The next_start of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._next_start = next_start

    @property
    def duplicate(self):
        """Gets the duplicate of this ScriptNetscan.  # noqa: E501

        Information that determines how duplicate discovered devices should be handled  # noqa: E501

        :return: The duplicate of this ScriptNetscan.  # noqa: E501
        :rtype: ExcludeDuplicateIps
        """
        return self._duplicate

    @duplicate.setter
    def duplicate(self, duplicate):
        """Sets the duplicate of this ScriptNetscan.

        Information that determines how duplicate discovered devices should be handled  # noqa: E501

        :param duplicate: The duplicate of this ScriptNetscan.  # noqa: E501
        :type: ExcludeDuplicateIps
        """
        if duplicate is None:
            raise ValueError("Invalid value for `duplicate`, must not be `None`")  # noqa: E501

        self._duplicate = duplicate

    @property
    def version(self):
        """Gets the version of this ScriptNetscan.  # noqa: E501

        The Id of the device  # noqa: E501

        :return: The version of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ScriptNetscan.

        The Id of the device  # noqa: E501

        :param version: The version of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def collector(self):
        """Gets the collector of this ScriptNetscan.  # noqa: E501

        The ID of the Collector associated with this Netscan  # noqa: E501

        :return: The collector of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._collector

    @collector.setter
    def collector(self, collector):
        """Sets the collector of this ScriptNetscan.

        The ID of the Collector associated with this Netscan  # noqa: E501

        :param collector: The collector of this ScriptNetscan.  # noqa: E501
        :type: int
        """
        if collector is None:
            raise ValueError("Invalid value for `collector`, must not be `None`")  # noqa: E501

        self._collector = collector

    @property
    def ignore_system_i_ps_duplicates(self):
        """Gets the ignore_system_i_ps_duplicates of this ScriptNetscan.  # noqa: E501

        Ignore system.ips when checking for duplicate resources  # noqa: E501

        :return: The ignore_system_i_ps_duplicates of this ScriptNetscan.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_system_i_ps_duplicates

    @ignore_system_i_ps_duplicates.setter
    def ignore_system_i_ps_duplicates(self, ignore_system_i_ps_duplicates):
        """Sets the ignore_system_i_ps_duplicates of this ScriptNetscan.

        Ignore system.ips when checking for duplicate resources  # noqa: E501

        :param ignore_system_i_ps_duplicates: The ignore_system_i_ps_duplicates of this ScriptNetscan.  # noqa: E501
        :type: bool
        """

        self._ignore_system_i_ps_duplicates = ignore_system_i_ps_duplicates

    @property
    def schedule(self):
        """Gets the schedule of this ScriptNetscan.  # noqa: E501

        Information related to the recurring execution schedule for the Netscan Policy  # noqa: E501

        :return: The schedule of this ScriptNetscan.  # noqa: E501
        :rtype: RestSchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this ScriptNetscan.

        Information related to the recurring execution schedule for the Netscan Policy  # noqa: E501

        :param schedule: The schedule of this ScriptNetscan.  # noqa: E501
        :type: RestSchedule
        """

        self._schedule = schedule

    @property
    def collector_description(self):
        """Gets the collector_description of this ScriptNetscan.  # noqa: E501

        The description of the Collector associated with this Netscan  # noqa: E501

        :return: The collector_description of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._collector_description

    @collector_description.setter
    def collector_description(self, collector_description):
        """Sets the collector_description of this ScriptNetscan.

        The description of the Collector associated with this Netscan  # noqa: E501

        :param collector_description: The collector_description of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._collector_description = collector_description

    @property
    def name(self):
        """Gets the name of this ScriptNetscan.  # noqa: E501

        The name of the Netscan Policy  # noqa: E501

        :return: The name of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ScriptNetscan.

        The name of the Netscan Policy  # noqa: E501

        :param name: The name of this ScriptNetscan.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def next_start_epoch(self):
        """Gets the next_start_epoch of this ScriptNetscan.  # noqa: E501

        The epoch of the next start time of the scan - displayed as 0 if the scan does not run on a schedule  # noqa: E501

        :return: The next_start_epoch of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._next_start_epoch

    @next_start_epoch.setter
    def next_start_epoch(self, next_start_epoch):
        """Sets the next_start_epoch of this ScriptNetscan.

        The epoch of the next start time of the scan - displayed as 0 if the scan does not run on a schedule  # noqa: E501

        :param next_start_epoch: The next_start_epoch of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._next_start_epoch = next_start_epoch

    @property
    def id(self):
        """Gets the id of this ScriptNetscan.  # noqa: E501

        The ID of the Netscan Policy  # noqa: E501

        :return: The id of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ScriptNetscan.

        The ID of the Netscan Policy  # noqa: E501

        :param id: The id of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def nsg_id(self):
        """Gets the nsg_id of this ScriptNetscan.  # noqa: E501

        The ID of the group the policy belongs to  # noqa: E501

        :return: The nsg_id of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._nsg_id

    @nsg_id.setter
    def nsg_id(self, nsg_id):
        """Sets the nsg_id of this ScriptNetscan.

        The ID of the group the policy belongs to  # noqa: E501

        :param nsg_id: The nsg_id of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._nsg_id = nsg_id

    @property
    def group(self):
        """Gets the group of this ScriptNetscan.  # noqa: E501

        The group the Netscan policy should belong to  # noqa: E501

        :return: The group of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this ScriptNetscan.

        The group the Netscan policy should belong to  # noqa: E501

        :param group: The group of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._group = group

    @property
    def script_path(self):
        """Gets the script_path of this ScriptNetscan.  # noqa: E501

        The script path for an external script  # noqa: E501

        :return: The script_path of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._script_path

    @script_path.setter
    def script_path(self, script_path):
        """Sets the script_path of this ScriptNetscan.

        The script path for an external script  # noqa: E501

        :param script_path: The script_path of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._script_path = script_path

    @property
    def default_group_full_path(self):
        """Gets the default_group_full_path of this ScriptNetscan.  # noqa: E501

        The full path of the default group to add discovered devices to  # noqa: E501

        :return: The default_group_full_path of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._default_group_full_path

    @default_group_full_path.setter
    def default_group_full_path(self, default_group_full_path):
        """Sets the default_group_full_path of this ScriptNetscan.

        The full path of the default group to add discovered devices to  # noqa: E501

        :param default_group_full_path: The default_group_full_path of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._default_group_full_path = default_group_full_path

    @property
    def default_group(self):
        """Gets the default_group of this ScriptNetscan.  # noqa: E501

        The ID of the default group to add discovered devices to  # noqa: E501

        :return: The default_group of this ScriptNetscan.  # noqa: E501
        :rtype: int
        """
        return self._default_group

    @default_group.setter
    def default_group(self, default_group):
        """Sets the default_group of this ScriptNetscan.

        The ID of the default group to add discovered devices to  # noqa: E501

        :param default_group: The default_group of this ScriptNetscan.  # noqa: E501
        :type: int
        """

        self._default_group = default_group

    @property
    def groovy_script(self):
        """Gets the groovy_script of this ScriptNetscan.  # noqa: E501

        For embedded script scans, the groovy script contents  # noqa: E501

        :return: The groovy_script of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._groovy_script

    @groovy_script.setter
    def groovy_script(self, groovy_script):
        """Sets the groovy_script of this ScriptNetscan.

        For embedded script scans, the groovy script contents  # noqa: E501

        :param groovy_script: The groovy_script of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._groovy_script = groovy_script

    @property
    def linux_script_params(self):
        """Gets the linux_script_params of this ScriptNetscan.  # noqa: E501


        :return: The linux_script_params of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._linux_script_params

    @linux_script_params.setter
    def linux_script_params(self, linux_script_params):
        """Sets the linux_script_params of this ScriptNetscan.


        :param linux_script_params: The linux_script_params of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._linux_script_params = linux_script_params

    @property
    def script_type(self):
        """Gets the script_type of this ScriptNetscan.  # noqa: E501

        For script scans, the type of script. Options are embeded and external  # noqa: E501

        :return: The script_type of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._script_type

    @script_type.setter
    def script_type(self, script_type):
        """Sets the script_type of this ScriptNetscan.

        For script scans, the type of script. Options are embeded and external  # noqa: E501

        :param script_type: The script_type of this ScriptNetscan.  # noqa: E501
        :type: str
        """
        if script_type is None:
            raise ValueError("Invalid value for `script_type`, must not be `None`")  # noqa: E501

        self._script_type = script_type

    @property
    def groovy_script_params(self):
        """Gets the groovy_script_params of this ScriptNetscan.  # noqa: E501

        For embedded script scans, the groovy script parameters  # noqa: E501

        :return: The groovy_script_params of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._groovy_script_params

    @groovy_script_params.setter
    def groovy_script_params(self, groovy_script_params):
        """Sets the groovy_script_params of this ScriptNetscan.

        For embedded script scans, the groovy script parameters  # noqa: E501

        :param groovy_script_params: The groovy_script_params of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._groovy_script_params = groovy_script_params

    @property
    def windows_script(self):
        """Gets the windows_script of this ScriptNetscan.  # noqa: E501


        :return: The windows_script of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._windows_script

    @windows_script.setter
    def windows_script(self, windows_script):
        """Sets the windows_script of this ScriptNetscan.


        :param windows_script: The windows_script of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._windows_script = windows_script

    @property
    def windows_script_params(self):
        """Gets the windows_script_params of this ScriptNetscan.  # noqa: E501


        :return: The windows_script_params of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._windows_script_params

    @windows_script_params.setter
    def windows_script_params(self, windows_script_params):
        """Sets the windows_script_params of this ScriptNetscan.


        :param windows_script_params: The windows_script_params of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._windows_script_params = windows_script_params

    @property
    def script_params(self):
        """Gets the script_params of this ScriptNetscan.  # noqa: E501

        The parameters for an external script  # noqa: E501

        :return: The script_params of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._script_params

    @script_params.setter
    def script_params(self, script_params):
        """Sets the script_params of this ScriptNetscan.

        The parameters for an external script  # noqa: E501

        :param script_params: The script_params of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._script_params = script_params

    @property
    def linux_script(self):
        """Gets the linux_script of this ScriptNetscan.  # noqa: E501


        :return: The linux_script of this ScriptNetscan.  # noqa: E501
        :rtype: str
        """
        return self._linux_script

    @linux_script.setter
    def linux_script(self, linux_script):
        """Sets the linux_script of this ScriptNetscan.


        :param linux_script: The linux_script of this ScriptNetscan.  # noqa: E501
        :type: str
        """

        self._linux_script = linux_script

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ScriptNetscan, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScriptNetscan):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
