# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.cell_data import CellData  # noqa: F401,E501


class RowData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cells': 'list[CellData]',
        'device_id': 'int',
        'device_display_name': 'str'
    }

    attribute_map = {
        'cells': 'cells',
        'device_id': 'deviceId',
        'device_display_name': 'deviceDisplayName'
    }

    def __init__(self, cells=None, device_id=None, device_display_name=None):  # noqa: E501
        """RowData - a model defined in Swagger"""  # noqa: E501

        self._cells = None
        self._device_id = None
        self._device_display_name = None
        self.discriminator = None

        if cells is not None:
            self.cells = cells
        if device_id is not None:
            self.device_id = device_id
        if device_display_name is not None:
            self.device_display_name = device_display_name

    @property
    def cells(self):
        """Gets the cells of this RowData.  # noqa: E501


        :return: The cells of this RowData.  # noqa: E501
        :rtype: list[CellData]
        """
        return self._cells

    @cells.setter
    def cells(self, cells):
        """Sets the cells of this RowData.


        :param cells: The cells of this RowData.  # noqa: E501
        :type: list[CellData]
        """

        self._cells = cells

    @property
    def device_id(self):
        """Gets the device_id of this RowData.  # noqa: E501


        :return: The device_id of this RowData.  # noqa: E501
        :rtype: int
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """Sets the device_id of this RowData.


        :param device_id: The device_id of this RowData.  # noqa: E501
        :type: int
        """

        self._device_id = device_id

    @property
    def device_display_name(self):
        """Gets the device_display_name of this RowData.  # noqa: E501


        :return: The device_display_name of this RowData.  # noqa: E501
        :rtype: str
        """
        return self._device_display_name

    @device_display_name.setter
    def device_display_name(self, device_display_name):
        """Sets the device_display_name of this RowData.


        :param device_display_name: The device_display_name of this RowData.  # noqa: E501
        :type: str
        """

        self._device_display_name = device_display_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RowData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RowData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
