# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.privilege import Privilege  # noqa: F401,E501


class Role(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enable_remote_session_in_company_level': 'bool',
        'custom_help_label': 'str',
        'custom_help_url': 'str',
        'privileges': 'list[Privilege]',
        'associated_user_count': 'int',
        'name': 'str',
        'description': 'str',
        'id': 'int',
        'two_fa_required': 'bool',
        'require_eula': 'bool',
        'acct_require_two_fa': 'bool'
    }

    attribute_map = {
        'enable_remote_session_in_company_level': 'enableRemoteSessionInCompanyLevel',
        'custom_help_label': 'customHelpLabel',
        'custom_help_url': 'customHelpURL',
        'privileges': 'privileges',
        'associated_user_count': 'associatedUserCount',
        'name': 'name',
        'description': 'description',
        'id': 'id',
        'two_fa_required': 'twoFARequired',
        'require_eula': 'requireEULA',
        'acct_require_two_fa': 'acctRequireTwoFA'
    }

    def __init__(self, enable_remote_session_in_company_level=None, custom_help_label=None, custom_help_url=None, privileges=None, associated_user_count=None, name=None, description=None, id=None, two_fa_required=None, require_eula=None, acct_require_two_fa=None):  # noqa: E501
        """Role - a model defined in Swagger"""  # noqa: E501

        self._enable_remote_session_in_company_level = None
        self._custom_help_label = None
        self._custom_help_url = None
        self._privileges = None
        self._associated_user_count = None
        self._name = None
        self._description = None
        self._id = None
        self._two_fa_required = None
        self._require_eula = None
        self._acct_require_two_fa = None
        self.discriminator = None

        if enable_remote_session_in_company_level is not None:
            self.enable_remote_session_in_company_level = enable_remote_session_in_company_level
        if custom_help_label is not None:
            self.custom_help_label = custom_help_label
        if custom_help_url is not None:
            self.custom_help_url = custom_help_url
        self.privileges = privileges
        if associated_user_count is not None:
            self.associated_user_count = associated_user_count
        self.name = name
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if two_fa_required is not None:
            self.two_fa_required = two_fa_required
        if require_eula is not None:
            self.require_eula = require_eula
        if acct_require_two_fa is not None:
            self.acct_require_two_fa = acct_require_two_fa

    @property
    def enable_remote_session_in_company_level(self):
        """Gets the enable_remote_session_in_company_level of this Role.  # noqa: E501

        Whether Remote Session should be enabled at the account level  # noqa: E501

        :return: The enable_remote_session_in_company_level of this Role.  # noqa: E501
        :rtype: bool
        """
        return self._enable_remote_session_in_company_level

    @enable_remote_session_in_company_level.setter
    def enable_remote_session_in_company_level(self, enable_remote_session_in_company_level):
        """Sets the enable_remote_session_in_company_level of this Role.

        Whether Remote Session should be enabled at the account level  # noqa: E501

        :param enable_remote_session_in_company_level: The enable_remote_session_in_company_level of this Role.  # noqa: E501
        :type: bool
        """

        self._enable_remote_session_in_company_level = enable_remote_session_in_company_level

    @property
    def custom_help_label(self):
        """Gets the custom_help_label of this Role.  # noqa: E501

        The label for the custom help URL as it will appear in the Help & Support dropdown menu  # noqa: E501

        :return: The custom_help_label of this Role.  # noqa: E501
        :rtype: str
        """
        return self._custom_help_label

    @custom_help_label.setter
    def custom_help_label(self, custom_help_label):
        """Sets the custom_help_label of this Role.

        The label for the custom help URL as it will appear in the Help & Support dropdown menu  # noqa: E501

        :param custom_help_label: The custom_help_label of this Role.  # noqa: E501
        :type: str
        """

        self._custom_help_label = custom_help_label

    @property
    def custom_help_url(self):
        """Gets the custom_help_url of this Role.  # noqa: E501

        The URL that should be added to the Help & Support dropdown menu  # noqa: E501

        :return: The custom_help_url of this Role.  # noqa: E501
        :rtype: str
        """
        return self._custom_help_url

    @custom_help_url.setter
    def custom_help_url(self, custom_help_url):
        """Sets the custom_help_url of this Role.

        The URL that should be added to the Help & Support dropdown menu  # noqa: E501

        :param custom_help_url: The custom_help_url of this Role.  # noqa: E501
        :type: str
        """

        self._custom_help_url = custom_help_url

    @property
    def privileges(self):
        """Gets the privileges of this Role.  # noqa: E501

        The account privileges associated with the role. Privileges can be added to a role for each area of your account  # noqa: E501

        :return: The privileges of this Role.  # noqa: E501
        :rtype: list[Privilege]
        """
        return self._privileges

    @privileges.setter
    def privileges(self, privileges):
        """Sets the privileges of this Role.

        The account privileges associated with the role. Privileges can be added to a role for each area of your account  # noqa: E501

        :param privileges: The privileges of this Role.  # noqa: E501
        :type: list[Privilege]
        """
        if privileges is None:
            raise ValueError("Invalid value for `privileges`, must not be `None`")  # noqa: E501

        self._privileges = privileges

    @property
    def associated_user_count(self):
        """Gets the associated_user_count of this Role.  # noqa: E501

        The count of the users which are belongs to the role  # noqa: E501

        :return: The associated_user_count of this Role.  # noqa: E501
        :rtype: int
        """
        return self._associated_user_count

    @associated_user_count.setter
    def associated_user_count(self, associated_user_count):
        """Sets the associated_user_count of this Role.

        The count of the users which are belongs to the role  # noqa: E501

        :param associated_user_count: The associated_user_count of this Role.  # noqa: E501
        :type: int
        """

        self._associated_user_count = associated_user_count

    @property
    def name(self):
        """Gets the name of this Role.  # noqa: E501

        The name of the role  # noqa: E501

        :return: The name of this Role.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Role.

        The name of the role  # noqa: E501

        :param name: The name of this Role.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Role.  # noqa: E501

        The description of the role  # noqa: E501

        :return: The description of this Role.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Role.

        The description of the role  # noqa: E501

        :param description: The description of this Role.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this Role.  # noqa: E501

        The Id of the role  # noqa: E501

        :return: The id of this Role.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Role.

        The Id of the role  # noqa: E501

        :param id: The id of this Role.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def two_fa_required(self):
        """Gets the two_fa_required of this Role.  # noqa: E501

        Whether Two-Factor Authentication should be required for this role  # noqa: E501

        :return: The two_fa_required of this Role.  # noqa: E501
        :rtype: bool
        """
        return self._two_fa_required

    @two_fa_required.setter
    def two_fa_required(self, two_fa_required):
        """Sets the two_fa_required of this Role.

        Whether Two-Factor Authentication should be required for this role  # noqa: E501

        :param two_fa_required: The two_fa_required of this Role.  # noqa: E501
        :type: bool
        """

        self._two_fa_required = two_fa_required

    @property
    def require_eula(self):
        """Gets the require_eula of this Role.  # noqa: E501

        Whether or not users assigned this role should be required to acknowledge the EULA (end user license agreement)  # noqa: E501

        :return: The require_eula of this Role.  # noqa: E501
        :rtype: bool
        """
        return self._require_eula

    @require_eula.setter
    def require_eula(self, require_eula):
        """Sets the require_eula of this Role.

        Whether or not users assigned this role should be required to acknowledge the EULA (end user license agreement)  # noqa: E501

        :param require_eula: The require_eula of this Role.  # noqa: E501
        :type: bool
        """

        self._require_eula = require_eula

    @property
    def acct_require_two_fa(self):
        """Gets the acct_require_two_fa of this Role.  # noqa: E501

        Whether Two-Factor Authentication should be required for the entire account  # noqa: E501

        :return: The acct_require_two_fa of this Role.  # noqa: E501
        :rtype: bool
        """
        return self._acct_require_two_fa

    @acct_require_two_fa.setter
    def acct_require_two_fa(self, acct_require_two_fa):
        """Sets the acct_require_two_fa of this Role.

        Whether Two-Factor Authentication should be required for the entire account  # noqa: E501

        :param acct_require_two_fa: The acct_require_two_fa of this Role.  # noqa: E501
        :type: bool
        """

        self._acct_require_two_fa = acct_require_two_fa

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Role, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Role):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
