# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ReportRecipient(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'addition_info': 'str',
        'method': 'str',
        'type': 'str',
        'addr': 'str'
    }

    attribute_map = {
        'addition_info': 'additionInfo',
        'method': 'method',
        'type': 'type',
        'addr': 'addr'
    }

    def __init__(self, addition_info=None, method=None, type=None, addr=None):  # noqa: E501
        """ReportRecipient - a model defined in Swagger"""  # noqa: E501

        self._addition_info = None
        self._method = None
        self._type = None
        self._addr = None
        self.discriminator = None

        if addition_info is not None:
            self.addition_info = addition_info
        if method is not None:
            self.method = method
        self.type = type
        self.addr = addr

    @property
    def addition_info(self):
        """Gets the addition_info of this ReportRecipient.  # noqa: E501

        If the type is admin and the method is email, the field should indicate the actual email address of the admin  # noqa: E501

        :return: The addition_info of this ReportRecipient.  # noqa: E501
        :rtype: str
        """
        return self._addition_info

    @addition_info.setter
    def addition_info(self, addition_info):
        """Sets the addition_info of this ReportRecipient.

        If the type is admin and the method is email, the field should indicate the actual email address of the admin  # noqa: E501

        :param addition_info: The addition_info of this ReportRecipient.  # noqa: E501
        :type: str
        """

        self._addition_info = addition_info

    @property
    def method(self):
        """Gets the method of this ReportRecipient.  # noqa: E501

        This should always be email  # noqa: E501

        :return: The method of this ReportRecipient.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this ReportRecipient.

        This should always be email  # noqa: E501

        :param method: The method of this ReportRecipient.  # noqa: E501
        :type: str
        """

        self._method = method

    @property
    def type(self):
        """Gets the type of this ReportRecipient.  # noqa: E501

        Where admin refers to a user in the account and arbitrary refers to an email address not associated with a user account.Acceptable values are: admin, arbitrary  # noqa: E501

        :return: The type of this ReportRecipient.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ReportRecipient.

        Where admin refers to a user in the account and arbitrary refers to an email address not associated with a user account.Acceptable values are: admin, arbitrary  # noqa: E501

        :param type: The type of this ReportRecipient.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def addr(self):
        """Gets the addr of this ReportRecipient.  # noqa: E501

        This should be a username if type=admin, or an email address if type=arbitrary  # noqa: E501

        :return: The addr of this ReportRecipient.  # noqa: E501
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this ReportRecipient.

        This should be a username if type=admin, or an email address if type=arbitrary  # noqa: E501

        :param addr: The addr of this ReportRecipient.  # noqa: E501
        :type: str
        """
        if addr is None:
            raise ValueError("Invalid value for `addr`, must not be `None`")  # noqa: E501

        self._addr = addr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ReportRecipient, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReportRecipient):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
