# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Recipient(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'method': 'str',
        'contact': 'str',
        'type': 'str',
        'addr': 'str'
    }

    attribute_map = {
        'method': 'method',
        'contact': 'contact',
        'type': 'type',
        'addr': 'addr'
    }

    def __init__(self, method=None, contact=None, type=None, addr=None):  # noqa: E501
        """Recipient - a model defined in Swagger"""  # noqa: E501

        self._method = None
        self._contact = None
        self._type = None
        self._addr = None
        self.discriminator = None

        self.method = method
        if contact is not None:
            self.contact = contact
        self.type = type
        if addr is not None:
            self.addr = addr

    @property
    def method(self):
        """Gets the method of this Recipient.  # noqa: E501

        Admin | Arbitrary, where Admin = a user, and Arbitrary = an arbitrary email  # noqa: E501

        :return: The method of this Recipient.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this Recipient.

        Admin | Arbitrary, where Admin = a user, and Arbitrary = an arbitrary email  # noqa: E501

        :param method: The method of this Recipient.  # noqa: E501
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501

        self._method = method

    @property
    def contact(self):
        """Gets the contact of this Recipient.  # noqa: E501


        :return: The contact of this Recipient.  # noqa: E501
        :rtype: str
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this Recipient.


        :param contact: The contact of this Recipient.  # noqa: E501
        :type: str
        """

        self._contact = contact

    @property
    def type(self):
        """Gets the type of this Recipient.  # noqa: E501

        email | sms | voice, where type must be email if method = arbitrary  # noqa: E501

        :return: The type of this Recipient.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Recipient.

        email | sms | voice, where type must be email if method = arbitrary  # noqa: E501

        :param type: The type of this Recipient.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def addr(self):
        """Gets the addr of this Recipient.  # noqa: E501

        the user name if method = admin, or the email address if method = arbitrary  # noqa: E501

        :return: The addr of this Recipient.  # noqa: E501
        :rtype: str
        """
        return self._addr

    @addr.setter
    def addr(self, addr):
        """Sets the addr of this Recipient.

        the user name if method = admin, or the email address if method = arbitrary  # noqa: E501

        :param addr: The addr of this Recipient.  # noqa: E501
        :type: str
        """

        self._addr = addr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Recipient, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Recipient):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
