# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PointSource(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'has_location': 'bool',
        'type': 'str',
        'device_group_full_path': 'str',
        'device_display_name': 'str'
    }

    attribute_map = {
        'has_location': 'hasLocation',
        'type': 'type',
        'device_group_full_path': 'deviceGroupFullPath',
        'device_display_name': 'deviceDisplayName'
    }

    def __init__(self, has_location=None, type=None, device_group_full_path=None, device_display_name=None):  # noqa: E501
        """PointSource - a model defined in Swagger"""  # noqa: E501

        self._has_location = None
        self._type = None
        self._device_group_full_path = None
        self._device_display_name = None
        self.discriminator = None

        if has_location is not None:
            self.has_location = has_location
        if type is not None:
            self.type = type
        self.device_group_full_path = device_group_full_path
        if device_display_name is not None:
            self.device_display_name = device_display_name

    @property
    def has_location(self):
        """Gets the has_location of this PointSource.  # noqa: E501

        Whether or not the specified group or device has a location property defined  # noqa: E501

        :return: The has_location of this PointSource.  # noqa: E501
        :rtype: bool
        """
        return self._has_location

    @has_location.setter
    def has_location(self, has_location):
        """Sets the has_location of this PointSource.

        Whether or not the specified group or device has a location property defined  # noqa: E501

        :param has_location: The has_location of this PointSource.  # noqa: E501
        :type: bool
        """

        self._has_location = has_location

    @property
    def type(self):
        """Gets the type of this PointSource.  # noqa: E501

        Whether or not the mapPoint represents a device or a group  # noqa: E501

        :return: The type of this PointSource.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this PointSource.

        Whether or not the mapPoint represents a device or a group  # noqa: E501

        :param type: The type of this PointSource.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def device_group_full_path(self):
        """Gets the device_group_full_path of this PointSource.  # noqa: E501

        The full path of the device group associated with the map point. This may be the group the map point represents, or the group of the device that the map point represents  # noqa: E501

        :return: The device_group_full_path of this PointSource.  # noqa: E501
        :rtype: str
        """
        return self._device_group_full_path

    @device_group_full_path.setter
    def device_group_full_path(self, device_group_full_path):
        """Sets the device_group_full_path of this PointSource.

        The full path of the device group associated with the map point. This may be the group the map point represents, or the group of the device that the map point represents  # noqa: E501

        :param device_group_full_path: The device_group_full_path of this PointSource.  # noqa: E501
        :type: str
        """
        if device_group_full_path is None:
            raise ValueError("Invalid value for `device_group_full_path`, must not be `None`")  # noqa: E501

        self._device_group_full_path = device_group_full_path

    @property
    def device_display_name(self):
        """Gets the device_display_name of this PointSource.  # noqa: E501

        The display name of the device the map point represents (if type=device). This field supports Glob (*)  # noqa: E501

        :return: The device_display_name of this PointSource.  # noqa: E501
        :rtype: str
        """
        return self._device_display_name

    @device_display_name.setter
    def device_display_name(self, device_display_name):
        """Sets the device_display_name of this PointSource.

        The display name of the device the map point represents (if type=device). This field supports Glob (*)  # noqa: E501

        :param device_display_name: The device_display_name of this PointSource.  # noqa: E501
        :type: str
        """

        self._device_display_name = device_display_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PointSource, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PointSource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
