# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.counter import Counter  # noqa: F401,E501
from logicmonitor_sdk.models.pie_chart_data_point import PieChartDataPoint  # noqa: F401,E501
from logicmonitor_sdk.models.pie_chart_item import PieChartItem  # noqa: F401,E501
from logicmonitor_sdk.models.virtual_data_point import VirtualDataPoint  # noqa: F401,E501


class PieChartInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'max_slices_can_be_shown': 'int',
        'virtual_data_points': 'list[VirtualDataPoint]',
        'show_labels_and_lines_on_pc': 'bool',
        'counters': 'list[Counter]',
        'data_points': 'list[PieChartDataPoint]',
        'hide_zero_percent_slices': 'bool',
        'group_remaining_as_others': 'bool',
        'pie_chart_items': 'list[PieChartItem]',
        'title': 'str'
    }

    attribute_map = {
        'max_slices_can_be_shown': 'maxSlicesCanBeShown',
        'virtual_data_points': 'virtualDataPoints',
        'show_labels_and_lines_on_pc': 'showLabelsAndLinesOnPC',
        'counters': 'counters',
        'data_points': 'dataPoints',
        'hide_zero_percent_slices': 'hideZeroPercentSlices',
        'group_remaining_as_others': 'groupRemainingAsOthers',
        'pie_chart_items': 'pieChartItems',
        'title': 'title'
    }

    def __init__(self, max_slices_can_be_shown=None, virtual_data_points=None, show_labels_and_lines_on_pc=None, counters=None, data_points=None, hide_zero_percent_slices=None, group_remaining_as_others=None, pie_chart_items=None, title=None):  # noqa: E501
        """PieChartInfo - a model defined in Swagger"""  # noqa: E501

        self._max_slices_can_be_shown = None
        self._virtual_data_points = None
        self._show_labels_and_lines_on_pc = None
        self._counters = None
        self._data_points = None
        self._hide_zero_percent_slices = None
        self._group_remaining_as_others = None
        self._pie_chart_items = None
        self._title = None
        self.discriminator = None

        if max_slices_can_be_shown is not None:
            self.max_slices_can_be_shown = max_slices_can_be_shown
        if virtual_data_points is not None:
            self.virtual_data_points = virtual_data_points
        if show_labels_and_lines_on_pc is not None:
            self.show_labels_and_lines_on_pc = show_labels_and_lines_on_pc
        if counters is not None:
            self.counters = counters
        if data_points is not None:
            self.data_points = data_points
        if hide_zero_percent_slices is not None:
            self.hide_zero_percent_slices = hide_zero_percent_slices
        if group_remaining_as_others is not None:
            self.group_remaining_as_others = group_remaining_as_others
        self.pie_chart_items = pie_chart_items
        if title is not None:
            self.title = title

    @property
    def max_slices_can_be_shown(self):
        """Gets the max_slices_can_be_shown of this PieChartInfo.  # noqa: E501

        The maximum number of slices you'd like displayed in the pie chart  # noqa: E501

        :return: The max_slices_can_be_shown of this PieChartInfo.  # noqa: E501
        :rtype: int
        """
        return self._max_slices_can_be_shown

    @max_slices_can_be_shown.setter
    def max_slices_can_be_shown(self, max_slices_can_be_shown):
        """Sets the max_slices_can_be_shown of this PieChartInfo.

        The maximum number of slices you'd like displayed in the pie chart  # noqa: E501

        :param max_slices_can_be_shown: The max_slices_can_be_shown of this PieChartInfo.  # noqa: E501
        :type: int
        """

        self._max_slices_can_be_shown = max_slices_can_be_shown

    @property
    def virtual_data_points(self):
        """Gets the virtual_data_points of this PieChartInfo.  # noqa: E501

        The virtual datapoints added to the widget. Note that virtual datapoints must be included in the pieChartItems object to be displayed in the widget  # noqa: E501

        :return: The virtual_data_points of this PieChartInfo.  # noqa: E501
        :rtype: list[VirtualDataPoint]
        """
        return self._virtual_data_points

    @virtual_data_points.setter
    def virtual_data_points(self, virtual_data_points):
        """Sets the virtual_data_points of this PieChartInfo.

        The virtual datapoints added to the widget. Note that virtual datapoints must be included in the pieChartItems object to be displayed in the widget  # noqa: E501

        :param virtual_data_points: The virtual_data_points of this PieChartInfo.  # noqa: E501
        :type: list[VirtualDataPoint]
        """

        self._virtual_data_points = virtual_data_points

    @property
    def show_labels_and_lines_on_pc(self):
        """Gets the show_labels_and_lines_on_pc of this PieChartInfo.  # noqa: E501

        Whether or not labels and lines should be displayed on the pie chart  # noqa: E501

        :return: The show_labels_and_lines_on_pc of this PieChartInfo.  # noqa: E501
        :rtype: bool
        """
        return self._show_labels_and_lines_on_pc

    @show_labels_and_lines_on_pc.setter
    def show_labels_and_lines_on_pc(self, show_labels_and_lines_on_pc):
        """Sets the show_labels_and_lines_on_pc of this PieChartInfo.

        Whether or not labels and lines should be displayed on the pie chart  # noqa: E501

        :param show_labels_and_lines_on_pc: The show_labels_and_lines_on_pc of this PieChartInfo.  # noqa: E501
        :type: bool
        """

        self._show_labels_and_lines_on_pc = show_labels_and_lines_on_pc

    @property
    def counters(self):
        """Gets the counters of this PieChartInfo.  # noqa: E501

        The counter is used for saving applyTo expression, it's mainly used for count device  # noqa: E501

        :return: The counters of this PieChartInfo.  # noqa: E501
        :rtype: list[Counter]
        """
        return self._counters

    @counters.setter
    def counters(self, counters):
        """Sets the counters of this PieChartInfo.

        The counter is used for saving applyTo expression, it's mainly used for count device  # noqa: E501

        :param counters: The counters of this PieChartInfo.  # noqa: E501
        :type: list[Counter]
        """

        self._counters = counters

    @property
    def data_points(self):
        """Gets the data_points of this PieChartInfo.  # noqa: E501

        The datapoints added to the widget. Note that datapoints must be included in the pieChartItems object to be displayed in the widget  # noqa: E501

        :return: The data_points of this PieChartInfo.  # noqa: E501
        :rtype: list[PieChartDataPoint]
        """
        return self._data_points

    @data_points.setter
    def data_points(self, data_points):
        """Sets the data_points of this PieChartInfo.

        The datapoints added to the widget. Note that datapoints must be included in the pieChartItems object to be displayed in the widget  # noqa: E501

        :param data_points: The data_points of this PieChartInfo.  # noqa: E501
        :type: list[PieChartDataPoint]
        """

        self._data_points = data_points

    @property
    def hide_zero_percent_slices(self):
        """Gets the hide_zero_percent_slices of this PieChartInfo.  # noqa: E501

        Whether items at 0% should be hidden  # noqa: E501

        :return: The hide_zero_percent_slices of this PieChartInfo.  # noqa: E501
        :rtype: bool
        """
        return self._hide_zero_percent_slices

    @hide_zero_percent_slices.setter
    def hide_zero_percent_slices(self, hide_zero_percent_slices):
        """Sets the hide_zero_percent_slices of this PieChartInfo.

        Whether items at 0% should be hidden  # noqa: E501

        :param hide_zero_percent_slices: The hide_zero_percent_slices of this PieChartInfo.  # noqa: E501
        :type: bool
        """

        self._hide_zero_percent_slices = hide_zero_percent_slices

    @property
    def group_remaining_as_others(self):
        """Gets the group_remaining_as_others of this PieChartInfo.  # noqa: E501

        If the number of slices exceeds the maxSlicesCanBeShown, this value indicates whether the remaining slices should be grouped together  # noqa: E501

        :return: The group_remaining_as_others of this PieChartInfo.  # noqa: E501
        :rtype: bool
        """
        return self._group_remaining_as_others

    @group_remaining_as_others.setter
    def group_remaining_as_others(self, group_remaining_as_others):
        """Sets the group_remaining_as_others of this PieChartInfo.

        If the number of slices exceeds the maxSlicesCanBeShown, this value indicates whether the remaining slices should be grouped together  # noqa: E501

        :param group_remaining_as_others: The group_remaining_as_others of this PieChartInfo.  # noqa: E501
        :type: bool
        """

        self._group_remaining_as_others = group_remaining_as_others

    @property
    def pie_chart_items(self):
        """Gets the pie_chart_items of this PieChartInfo.  # noqa: E501

        The datapoints and virtual datapoints that will be displayed in the pie chart  # noqa: E501

        :return: The pie_chart_items of this PieChartInfo.  # noqa: E501
        :rtype: list[PieChartItem]
        """
        return self._pie_chart_items

    @pie_chart_items.setter
    def pie_chart_items(self, pie_chart_items):
        """Sets the pie_chart_items of this PieChartInfo.

        The datapoints and virtual datapoints that will be displayed in the pie chart  # noqa: E501

        :param pie_chart_items: The pie_chart_items of this PieChartInfo.  # noqa: E501
        :type: list[PieChartItem]
        """
        if pie_chart_items is None:
            raise ValueError("Invalid value for `pie_chart_items`, must not be `None`")  # noqa: E501

        self._pie_chart_items = pie_chart_items

    @property
    def title(self):
        """Gets the title of this PieChartInfo.  # noqa: E501

        The title that will be displayed above the pie chart  # noqa: E501

        :return: The title of this PieChartInfo.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this PieChartInfo.

        The title that will be displayed above the pie chart  # noqa: E501

        :param title: The title of this PieChartInfo.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PieChartInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PieChartInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
