# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PieChartDataPoint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data_source_id': 'int',
        'data_point_name': 'str',
        'top10': 'bool',
        'data_point_id': 'int',
        'instance_name': 'str',
        'data_source_full_name': 'str',
        'name': 'str',
        'aggregate_function': 'str',
        'device_group_full_path': 'str',
        'device_display_name': 'str',
        'aggregate': 'bool'
    }

    attribute_map = {
        'data_source_id': 'dataSourceId',
        'data_point_name': 'dataPointName',
        'top10': 'top10',
        'data_point_id': 'dataPointId',
        'instance_name': 'instanceName',
        'data_source_full_name': 'dataSourceFullName',
        'name': 'name',
        'aggregate_function': 'aggregateFunction',
        'device_group_full_path': 'deviceGroupFullPath',
        'device_display_name': 'deviceDisplayName',
        'aggregate': 'aggregate'
    }

    def __init__(self, data_source_id=None, data_point_name=None, top10=None, data_point_id=None, instance_name=None, data_source_full_name=None, name=None, aggregate_function=None, device_group_full_path=None, device_display_name=None, aggregate=None):  # noqa: E501
        """PieChartDataPoint - a model defined in Swagger"""  # noqa: E501

        self._data_source_id = None
        self._data_point_name = None
        self._top10 = None
        self._data_point_id = None
        self._instance_name = None
        self._data_source_full_name = None
        self._name = None
        self._aggregate_function = None
        self._device_group_full_path = None
        self._device_display_name = None
        self._aggregate = None
        self.discriminator = None

        if data_source_id is not None:
            self.data_source_id = data_source_id
        if data_point_name is not None:
            self.data_point_name = data_point_name
        if top10 is not None:
            self.top10 = top10
        if data_point_id is not None:
            self.data_point_id = data_point_id
        self.instance_name = instance_name
        if data_source_full_name is not None:
            self.data_source_full_name = data_source_full_name
        self.name = name
        if aggregate_function is not None:
            self.aggregate_function = aggregate_function
        self.device_group_full_path = device_group_full_path
        self.device_display_name = device_display_name
        if aggregate is not None:
            self.aggregate = aggregate

    @property
    def data_source_id(self):
        """Gets the data_source_id of this PieChartDataPoint.  # noqa: E501


        :return: The data_source_id of this PieChartDataPoint.  # noqa: E501
        :rtype: int
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this PieChartDataPoint.


        :param data_source_id: The data_source_id of this PieChartDataPoint.  # noqa: E501
        :type: int
        """

        self._data_source_id = data_source_id

    @property
    def data_point_name(self):
        """Gets the data_point_name of this PieChartDataPoint.  # noqa: E501


        :return: The data_point_name of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._data_point_name

    @data_point_name.setter
    def data_point_name(self, data_point_name):
        """Sets the data_point_name of this PieChartDataPoint.


        :param data_point_name: The data_point_name of this PieChartDataPoint.  # noqa: E501
        :type: str
        """

        self._data_point_name = data_point_name

    @property
    def top10(self):
        """Gets the top10 of this PieChartDataPoint.  # noqa: E501


        :return: The top10 of this PieChartDataPoint.  # noqa: E501
        :rtype: bool
        """
        return self._top10

    @top10.setter
    def top10(self, top10):
        """Sets the top10 of this PieChartDataPoint.


        :param top10: The top10 of this PieChartDataPoint.  # noqa: E501
        :type: bool
        """

        self._top10 = top10

    @property
    def data_point_id(self):
        """Gets the data_point_id of this PieChartDataPoint.  # noqa: E501


        :return: The data_point_id of this PieChartDataPoint.  # noqa: E501
        :rtype: int
        """
        return self._data_point_id

    @data_point_id.setter
    def data_point_id(self, data_point_id):
        """Sets the data_point_id of this PieChartDataPoint.


        :param data_point_id: The data_point_id of this PieChartDataPoint.  # noqa: E501
        :type: int
        """

        self._data_point_id = data_point_id

    @property
    def instance_name(self):
        """Gets the instance_name of this PieChartDataPoint.  # noqa: E501


        :return: The instance_name of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """Sets the instance_name of this PieChartDataPoint.


        :param instance_name: The instance_name of this PieChartDataPoint.  # noqa: E501
        :type: str
        """
        if instance_name is None:
            raise ValueError("Invalid value for `instance_name`, must not be `None`")  # noqa: E501

        self._instance_name = instance_name

    @property
    def data_source_full_name(self):
        """Gets the data_source_full_name of this PieChartDataPoint.  # noqa: E501


        :return: The data_source_full_name of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._data_source_full_name

    @data_source_full_name.setter
    def data_source_full_name(self, data_source_full_name):
        """Sets the data_source_full_name of this PieChartDataPoint.


        :param data_source_full_name: The data_source_full_name of this PieChartDataPoint.  # noqa: E501
        :type: str
        """

        self._data_source_full_name = data_source_full_name

    @property
    def name(self):
        """Gets the name of this PieChartDataPoint.  # noqa: E501


        :return: The name of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PieChartDataPoint.


        :param name: The name of this PieChartDataPoint.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def aggregate_function(self):
        """Gets the aggregate_function of this PieChartDataPoint.  # noqa: E501


        :return: The aggregate_function of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._aggregate_function

    @aggregate_function.setter
    def aggregate_function(self, aggregate_function):
        """Sets the aggregate_function of this PieChartDataPoint.


        :param aggregate_function: The aggregate_function of this PieChartDataPoint.  # noqa: E501
        :type: str
        """

        self._aggregate_function = aggregate_function

    @property
    def device_group_full_path(self):
        """Gets the device_group_full_path of this PieChartDataPoint.  # noqa: E501


        :return: The device_group_full_path of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._device_group_full_path

    @device_group_full_path.setter
    def device_group_full_path(self, device_group_full_path):
        """Sets the device_group_full_path of this PieChartDataPoint.


        :param device_group_full_path: The device_group_full_path of this PieChartDataPoint.  # noqa: E501
        :type: str
        """
        if device_group_full_path is None:
            raise ValueError("Invalid value for `device_group_full_path`, must not be `None`")  # noqa: E501

        self._device_group_full_path = device_group_full_path

    @property
    def device_display_name(self):
        """Gets the device_display_name of this PieChartDataPoint.  # noqa: E501


        :return: The device_display_name of this PieChartDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._device_display_name

    @device_display_name.setter
    def device_display_name(self, device_display_name):
        """Sets the device_display_name of this PieChartDataPoint.


        :param device_display_name: The device_display_name of this PieChartDataPoint.  # noqa: E501
        :type: str
        """
        if device_display_name is None:
            raise ValueError("Invalid value for `device_display_name`, must not be `None`")  # noqa: E501

        self._device_display_name = device_display_name

    @property
    def aggregate(self):
        """Gets the aggregate of this PieChartDataPoint.  # noqa: E501


        :return: The aggregate of this PieChartDataPoint.  # noqa: E501
        :rtype: bool
        """
        return self._aggregate

    @aggregate.setter
    def aggregate(self, aggregate):
        """Sets the aggregate of this PieChartDataPoint.


        :param aggregate: The aggregate of this PieChartDataPoint.  # noqa: E501
        :type: bool
        """

        self._aggregate = aggregate

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PieChartDataPoint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PieChartDataPoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
