# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.collector_attribute import CollectorAttribute  # noqa: F401,E501


class OpenMetricCollectorAttributeV2(CollectorAttribute):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'headers': 'str',
        'follow_redirect': 'bool',
        'read_timeout': 'int',
        'connect_timeout': 'int',
        'url': 'str'
    }

    attribute_map = {
        'name': 'name',
        'headers': 'headers',
        'follow_redirect': 'followRedirect',
        'read_timeout': 'readTimeout',
        'connect_timeout': 'connectTimeout',
        'url': 'url'
    }

    def __init__(self, name=None, headers=None, follow_redirect=None, read_timeout=None, connect_timeout=None, url=None):  # noqa: E501
        """OpenMetricCollectorAttributeV2 - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._headers = None
        self._follow_redirect = None
        self._read_timeout = None
        self._connect_timeout = None
        self._url = None
        self.discriminator = None

        self.name = name
        if headers is not None:
            self.headers = headers
        if follow_redirect is not None:
            self.follow_redirect = follow_redirect
        if read_timeout is not None:
            self.read_timeout = read_timeout
        if connect_timeout is not None:
            self.connect_timeout = connect_timeout
        if url is not None:
            self.url = url

    @property
    def name(self):
        """Gets the name of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The name of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OpenMetricCollectorAttributeV2.


        :param name: The name of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def headers(self):
        """Gets the headers of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The headers of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: str
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """Sets the headers of this OpenMetricCollectorAttributeV2.


        :param headers: The headers of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: str
        """

        self._headers = headers

    @property
    def follow_redirect(self):
        """Gets the follow_redirect of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The follow_redirect of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: bool
        """
        return self._follow_redirect

    @follow_redirect.setter
    def follow_redirect(self, follow_redirect):
        """Sets the follow_redirect of this OpenMetricCollectorAttributeV2.


        :param follow_redirect: The follow_redirect of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: bool
        """

        self._follow_redirect = follow_redirect

    @property
    def read_timeout(self):
        """Gets the read_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The read_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: int
        """
        return self._read_timeout

    @read_timeout.setter
    def read_timeout(self, read_timeout):
        """Sets the read_timeout of this OpenMetricCollectorAttributeV2.


        :param read_timeout: The read_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: int
        """

        self._read_timeout = read_timeout

    @property
    def connect_timeout(self):
        """Gets the connect_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The connect_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: int
        """
        return self._connect_timeout

    @connect_timeout.setter
    def connect_timeout(self, connect_timeout):
        """Sets the connect_timeout of this OpenMetricCollectorAttributeV2.


        :param connect_timeout: The connect_timeout of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: int
        """

        self._connect_timeout = connect_timeout

    @property
    def url(self):
        """Gets the url of this OpenMetricCollectorAttributeV2.  # noqa: E501


        :return: The url of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this OpenMetricCollectorAttributeV2.


        :param url: The url of this OpenMetricCollectorAttributeV2.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OpenMetricCollectorAttributeV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OpenMetricCollectorAttributeV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
