# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.noc_item_base import NOCItemBase  # noqa: F401,E501
from logicmonitor_sdk.models.widget import Widget  # noqa: F401,E501


class NOCWidget(Widget):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_updated_by': 'str',
        'user_permission': 'str',
        'dashboard_id': 'int',
        'name': 'str',
        'description': 'str',
        'last_updated_on': 'int',
        'theme': 'str',
        'interval': 'int',
        'id': 'int',
        'type': 'str',
        'timescale': 'str',
        'ack_checked': 'object',
        'display_error_alert': 'object',
        'display_column': 'int',
        'display_warn_alert': 'object',
        'display_critical_alert': 'object',
        'sort_by': 'str',
        'sdt_checked': 'object',
        'items': 'list[NOCItemBase]'
    }

    attribute_map = {
        'last_updated_by': 'lastUpdatedBy',
        'user_permission': 'userPermission',
        'dashboard_id': 'dashboardId',
        'name': 'name',
        'description': 'description',
        'last_updated_on': 'lastUpdatedOn',
        'theme': 'theme',
        'interval': 'interval',
        'id': 'id',
        'type': 'type',
        'timescale': 'timescale',
        'ack_checked': 'ackChecked',
        'display_error_alert': 'displayErrorAlert',
        'display_column': 'displayColumn',
        'display_warn_alert': 'displayWarnAlert',
        'display_critical_alert': 'displayCriticalAlert',
        'sort_by': 'sortBy',
        'sdt_checked': 'sdtChecked',
        'items': 'items'
    }

    def __init__(self, last_updated_by=None, user_permission=None, dashboard_id=None, name=None, description=None, last_updated_on=None, theme=None, interval=None, id=None, type=None, timescale=None, ack_checked=None, display_error_alert=None, display_column=None, display_warn_alert=None, display_critical_alert=None, sort_by=None, sdt_checked=None, items=None):  # noqa: E501
        """NOCWidget - a model defined in Swagger"""  # noqa: E501

        self._last_updated_by = None
        self._user_permission = None
        self._dashboard_id = None
        self._name = None
        self._description = None
        self._last_updated_on = None
        self._theme = None
        self._interval = None
        self._id = None
        self._type = None
        self._timescale = None
        self._ack_checked = None
        self._display_error_alert = None
        self._display_column = None
        self._display_warn_alert = None
        self._display_critical_alert = None
        self._sort_by = None
        self._sdt_checked = None
        self._items = None
        self.discriminator = None

        if last_updated_by is not None:
            self.last_updated_by = last_updated_by
        if user_permission is not None:
            self.user_permission = user_permission
        self.dashboard_id = dashboard_id
        self.name = name
        if description is not None:
            self.description = description
        if last_updated_on is not None:
            self.last_updated_on = last_updated_on
        if theme is not None:
            self.theme = theme
        if interval is not None:
            self.interval = interval
        if id is not None:
            self.id = id
        self.type = type
        if timescale is not None:
            self.timescale = timescale
        if ack_checked is not None:
            self.ack_checked = ack_checked
        if display_error_alert is not None:
            self.display_error_alert = display_error_alert
        if display_column is not None:
            self.display_column = display_column
        if display_warn_alert is not None:
            self.display_warn_alert = display_warn_alert
        if display_critical_alert is not None:
            self.display_critical_alert = display_critical_alert
        if sort_by is not None:
            self.sort_by = sort_by
        if sdt_checked is not None:
            self.sdt_checked = sdt_checked
        self.items = items

    @property
    def last_updated_by(self):
        """Gets the last_updated_by of this NOCWidget.  # noqa: E501

        The user that last updated the widget  # noqa: E501

        :return: The last_updated_by of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """Sets the last_updated_by of this NOCWidget.

        The user that last updated the widget  # noqa: E501

        :param last_updated_by: The last_updated_by of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._last_updated_by = last_updated_by

    @property
    def user_permission(self):
        """Gets the user_permission of this NOCWidget.  # noqa: E501

        The permission level of the user who last modified the widget  # noqa: E501

        :return: The user_permission of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this NOCWidget.

        The permission level of the user who last modified the widget  # noqa: E501

        :param user_permission: The user_permission of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def dashboard_id(self):
        """Gets the dashboard_id of this NOCWidget.  # noqa: E501

        The id of the dashboard the widget belongs to  # noqa: E501

        :return: The dashboard_id of this NOCWidget.  # noqa: E501
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """Sets the dashboard_id of this NOCWidget.

        The id of the dashboard the widget belongs to  # noqa: E501

        :param dashboard_id: The dashboard_id of this NOCWidget.  # noqa: E501
        :type: int
        """
        if dashboard_id is None:
            raise ValueError("Invalid value for `dashboard_id`, must not be `None`")  # noqa: E501

        self._dashboard_id = dashboard_id

    @property
    def name(self):
        """Gets the name of this NOCWidget.  # noqa: E501

        The name of the widget  # noqa: E501

        :return: The name of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NOCWidget.

        The name of the widget  # noqa: E501

        :param name: The name of this NOCWidget.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this NOCWidget.  # noqa: E501

        The description of the widget  # noqa: E501

        :return: The description of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NOCWidget.

        The description of the widget  # noqa: E501

        :param description: The description of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def last_updated_on(self):
        """Gets the last_updated_on of this NOCWidget.  # noqa: E501

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :return: The last_updated_on of this NOCWidget.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_on

    @last_updated_on.setter
    def last_updated_on(self, last_updated_on):
        """Sets the last_updated_on of this NOCWidget.

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :param last_updated_on: The last_updated_on of this NOCWidget.  # noqa: E501
        :type: int
        """

        self._last_updated_on = last_updated_on

    @property
    def theme(self):
        """Gets the theme of this NOCWidget.  # noqa: E501

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :return: The theme of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this NOCWidget.

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :param theme: The theme of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._theme = theme

    @property
    def interval(self):
        """Gets the interval of this NOCWidget.  # noqa: E501

        The refresh interval of the widget, in minutes  # noqa: E501

        :return: The interval of this NOCWidget.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this NOCWidget.

        The refresh interval of the widget, in minutes  # noqa: E501

        :param interval: The interval of this NOCWidget.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def id(self):
        """Gets the id of this NOCWidget.  # noqa: E501

        The Id of the widget  # noqa: E501

        :return: The id of this NOCWidget.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NOCWidget.

        The Id of the widget  # noqa: E501

        :param id: The id of this NOCWidget.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this NOCWidget.  # noqa: E501

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :return: The type of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NOCWidget.

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :param type: The type of this NOCWidget.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def timescale(self):
        """Gets the timescale of this NOCWidget.  # noqa: E501

        The default timescale of the widget  # noqa: E501

        :return: The timescale of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._timescale

    @timescale.setter
    def timescale(self, timescale):
        """Sets the timescale of this NOCWidget.

        The default timescale of the widget  # noqa: E501

        :param timescale: The timescale of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._timescale = timescale

    @property
    def ack_checked(self):
        """Gets the ack_checked of this NOCWidget.  # noqa: E501

        Whether or not acknowledgements are displayed in the NOC widget, the default value is true  # noqa: E501

        :return: The ack_checked of this NOCWidget.  # noqa: E501
        :rtype: object
        """
        return self._ack_checked

    @ack_checked.setter
    def ack_checked(self, ack_checked):
        """Sets the ack_checked of this NOCWidget.

        Whether or not acknowledgements are displayed in the NOC widget, the default value is true  # noqa: E501

        :param ack_checked: The ack_checked of this NOCWidget.  # noqa: E501
        :type: object
        """

        self._ack_checked = ack_checked

    @property
    def display_error_alert(self):
        """Gets the display_error_alert of this NOCWidget.  # noqa: E501

        Whether or not error alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :return: The display_error_alert of this NOCWidget.  # noqa: E501
        :rtype: object
        """
        return self._display_error_alert

    @display_error_alert.setter
    def display_error_alert(self, display_error_alert):
        """Sets the display_error_alert of this NOCWidget.

        Whether or not error alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :param display_error_alert: The display_error_alert of this NOCWidget.  # noqa: E501
        :type: object
        """

        self._display_error_alert = display_error_alert

    @property
    def display_column(self):
        """Gets the display_column of this NOCWidget.  # noqa: E501

        The maximum number columns displayed in the NOC widget  # noqa: E501

        :return: The display_column of this NOCWidget.  # noqa: E501
        :rtype: int
        """
        return self._display_column

    @display_column.setter
    def display_column(self, display_column):
        """Sets the display_column of this NOCWidget.

        The maximum number columns displayed in the NOC widget  # noqa: E501

        :param display_column: The display_column of this NOCWidget.  # noqa: E501
        :type: int
        """

        self._display_column = display_column

    @property
    def display_warn_alert(self):
        """Gets the display_warn_alert of this NOCWidget.  # noqa: E501

        Whether or not warning alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :return: The display_warn_alert of this NOCWidget.  # noqa: E501
        :rtype: object
        """
        return self._display_warn_alert

    @display_warn_alert.setter
    def display_warn_alert(self, display_warn_alert):
        """Sets the display_warn_alert of this NOCWidget.

        Whether or not warning alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :param display_warn_alert: The display_warn_alert of this NOCWidget.  # noqa: E501
        :type: object
        """

        self._display_warn_alert = display_warn_alert

    @property
    def display_critical_alert(self):
        """Gets the display_critical_alert of this NOCWidget.  # noqa: E501

        Whether or not critical alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :return: The display_critical_alert of this NOCWidget.  # noqa: E501
        :rtype: object
        """
        return self._display_critical_alert

    @display_critical_alert.setter
    def display_critical_alert(self, display_critical_alert):
        """Sets the display_critical_alert of this NOCWidget.

        Whether or not critical alerts are displayed in the NOC widget, the default value is true  # noqa: E501

        :param display_critical_alert: The display_critical_alert of this NOCWidget.  # noqa: E501
        :type: object
        """

        self._display_critical_alert = display_critical_alert

    @property
    def sort_by(self):
        """Gets the sort_by of this NOCWidget.  # noqa: E501

        How NOC items are sorted  # noqa: E501

        :return: The sort_by of this NOCWidget.  # noqa: E501
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """Sets the sort_by of this NOCWidget.

        How NOC items are sorted  # noqa: E501

        :param sort_by: The sort_by of this NOCWidget.  # noqa: E501
        :type: str
        """

        self._sort_by = sort_by

    @property
    def sdt_checked(self):
        """Gets the sdt_checked of this NOCWidget.  # noqa: E501

        Whether or not SDTs are displayed in the NOC widget, the default value is true  # noqa: E501

        :return: The sdt_checked of this NOCWidget.  # noqa: E501
        :rtype: object
        """
        return self._sdt_checked

    @sdt_checked.setter
    def sdt_checked(self, sdt_checked):
        """Sets the sdt_checked of this NOCWidget.

        Whether or not SDTs are displayed in the NOC widget, the default value is true  # noqa: E501

        :param sdt_checked: The sdt_checked of this NOCWidget.  # noqa: E501
        :type: object
        """

        self._sdt_checked = sdt_checked

    @property
    def items(self):
        """Gets the items of this NOCWidget.  # noqa: E501

        The NOC items  # noqa: E501

        :return: The items of this NOCWidget.  # noqa: E501
        :rtype: list[NOCItemBase]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this NOCWidget.

        The NOC items  # noqa: E501

        :param items: The items of this NOCWidget.  # noqa: E501
        :type: list[NOCItemBase]
        """
        if items is None:
            raise ValueError("Invalid value for `items`, must not be `None`")  # noqa: E501

        self._items = items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NOCWidget, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NOCWidget):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
