# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.netflow_filters import NetflowFilters  # noqa: F401,E501
from logicmonitor_sdk.models.widget import Widget  # noqa: F401,E501


class NetflowGroupWidget(Widget):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_updated_by': 'str',
        'user_permission': 'str',
        'dashboard_id': 'int',
        'name': 'str',
        'description': 'str',
        'last_updated_on': 'int',
        'theme': 'str',
        'interval': 'int',
        'id': 'int',
        'type': 'str',
        'timescale': 'str',
        'row_filters': 'str',
        'device_group_id': 'int',
        'data_type': 'str',
        'netflow_filter': 'NetflowFilters',
        'device_group_name': 'str'
    }

    attribute_map = {
        'last_updated_by': 'lastUpdatedBy',
        'user_permission': 'userPermission',
        'dashboard_id': 'dashboardId',
        'name': 'name',
        'description': 'description',
        'last_updated_on': 'lastUpdatedOn',
        'theme': 'theme',
        'interval': 'interval',
        'id': 'id',
        'type': 'type',
        'timescale': 'timescale',
        'row_filters': 'rowFilters',
        'device_group_id': 'deviceGroupId',
        'data_type': 'dataType',
        'netflow_filter': 'netflowFilter',
        'device_group_name': 'deviceGroupName'
    }

    def __init__(self, last_updated_by=None, user_permission=None, dashboard_id=None, name=None, description=None, last_updated_on=None, theme=None, interval=None, id=None, type=None, timescale=None, row_filters=None, device_group_id=None, data_type=None, netflow_filter=None, device_group_name=None):  # noqa: E501
        """NetflowGroupWidget - a model defined in Swagger"""  # noqa: E501

        self._last_updated_by = None
        self._user_permission = None
        self._dashboard_id = None
        self._name = None
        self._description = None
        self._last_updated_on = None
        self._theme = None
        self._interval = None
        self._id = None
        self._type = None
        self._timescale = None
        self._row_filters = None
        self._device_group_id = None
        self._data_type = None
        self._netflow_filter = None
        self._device_group_name = None
        self.discriminator = None

        if last_updated_by is not None:
            self.last_updated_by = last_updated_by
        if user_permission is not None:
            self.user_permission = user_permission
        self.dashboard_id = dashboard_id
        self.name = name
        if description is not None:
            self.description = description
        if last_updated_on is not None:
            self.last_updated_on = last_updated_on
        if theme is not None:
            self.theme = theme
        if interval is not None:
            self.interval = interval
        if id is not None:
            self.id = id
        self.type = type
        if timescale is not None:
            self.timescale = timescale
        if row_filters is not None:
            self.row_filters = row_filters
        self.device_group_id = device_group_id
        if data_type is not None:
            self.data_type = data_type
        if netflow_filter is not None:
            self.netflow_filter = netflow_filter
        if device_group_name is not None:
            self.device_group_name = device_group_name

    @property
    def last_updated_by(self):
        """Gets the last_updated_by of this NetflowGroupWidget.  # noqa: E501

        The user that last updated the widget  # noqa: E501

        :return: The last_updated_by of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """Sets the last_updated_by of this NetflowGroupWidget.

        The user that last updated the widget  # noqa: E501

        :param last_updated_by: The last_updated_by of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._last_updated_by = last_updated_by

    @property
    def user_permission(self):
        """Gets the user_permission of this NetflowGroupWidget.  # noqa: E501

        The permission level of the user who last modified the widget  # noqa: E501

        :return: The user_permission of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this NetflowGroupWidget.

        The permission level of the user who last modified the widget  # noqa: E501

        :param user_permission: The user_permission of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def dashboard_id(self):
        """Gets the dashboard_id of this NetflowGroupWidget.  # noqa: E501

        The id of the dashboard the widget belongs to  # noqa: E501

        :return: The dashboard_id of this NetflowGroupWidget.  # noqa: E501
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """Sets the dashboard_id of this NetflowGroupWidget.

        The id of the dashboard the widget belongs to  # noqa: E501

        :param dashboard_id: The dashboard_id of this NetflowGroupWidget.  # noqa: E501
        :type: int
        """
        if dashboard_id is None:
            raise ValueError("Invalid value for `dashboard_id`, must not be `None`")  # noqa: E501

        self._dashboard_id = dashboard_id

    @property
    def name(self):
        """Gets the name of this NetflowGroupWidget.  # noqa: E501

        The name of the widget  # noqa: E501

        :return: The name of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NetflowGroupWidget.

        The name of the widget  # noqa: E501

        :param name: The name of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this NetflowGroupWidget.  # noqa: E501

        The description of the widget  # noqa: E501

        :return: The description of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NetflowGroupWidget.

        The description of the widget  # noqa: E501

        :param description: The description of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def last_updated_on(self):
        """Gets the last_updated_on of this NetflowGroupWidget.  # noqa: E501

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :return: The last_updated_on of this NetflowGroupWidget.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_on

    @last_updated_on.setter
    def last_updated_on(self, last_updated_on):
        """Sets the last_updated_on of this NetflowGroupWidget.

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :param last_updated_on: The last_updated_on of this NetflowGroupWidget.  # noqa: E501
        :type: int
        """

        self._last_updated_on = last_updated_on

    @property
    def theme(self):
        """Gets the theme of this NetflowGroupWidget.  # noqa: E501

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :return: The theme of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this NetflowGroupWidget.

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :param theme: The theme of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._theme = theme

    @property
    def interval(self):
        """Gets the interval of this NetflowGroupWidget.  # noqa: E501

        The refresh interval of the widget, in minutes  # noqa: E501

        :return: The interval of this NetflowGroupWidget.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this NetflowGroupWidget.

        The refresh interval of the widget, in minutes  # noqa: E501

        :param interval: The interval of this NetflowGroupWidget.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def id(self):
        """Gets the id of this NetflowGroupWidget.  # noqa: E501

        The Id of the widget  # noqa: E501

        :return: The id of this NetflowGroupWidget.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NetflowGroupWidget.

        The Id of the widget  # noqa: E501

        :param id: The id of this NetflowGroupWidget.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this NetflowGroupWidget.  # noqa: E501

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :return: The type of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NetflowGroupWidget.

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :param type: The type of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def timescale(self):
        """Gets the timescale of this NetflowGroupWidget.  # noqa: E501

        The default timescale of the widget  # noqa: E501

        :return: The timescale of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._timescale

    @timescale.setter
    def timescale(self, timescale):
        """Sets the timescale of this NetflowGroupWidget.

        The default timescale of the widget  # noqa: E501

        :param timescale: The timescale of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._timescale = timescale

    @property
    def row_filters(self):
        """Gets the row_filters of this NetflowGroupWidget.  # noqa: E501


        :return: The row_filters of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._row_filters

    @row_filters.setter
    def row_filters(self, row_filters):
        """Sets the row_filters of this NetflowGroupWidget.


        :param row_filters: The row_filters of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._row_filters = row_filters

    @property
    def device_group_id(self):
        """Gets the device_group_id of this NetflowGroupWidget.  # noqa: E501


        :return: The device_group_id of this NetflowGroupWidget.  # noqa: E501
        :rtype: int
        """
        return self._device_group_id

    @device_group_id.setter
    def device_group_id(self, device_group_id):
        """Sets the device_group_id of this NetflowGroupWidget.


        :param device_group_id: The device_group_id of this NetflowGroupWidget.  # noqa: E501
        :type: int
        """
        if device_group_id is None:
            raise ValueError("Invalid value for `device_group_id`, must not be `None`")  # noqa: E501

        self._device_group_id = device_group_id

    @property
    def data_type(self):
        """Gets the data_type of this NetflowGroupWidget.  # noqa: E501


        :return: The data_type of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this NetflowGroupWidget.


        :param data_type: The data_type of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._data_type = data_type

    @property
    def netflow_filter(self):
        """Gets the netflow_filter of this NetflowGroupWidget.  # noqa: E501


        :return: The netflow_filter of this NetflowGroupWidget.  # noqa: E501
        :rtype: NetflowFilters
        """
        return self._netflow_filter

    @netflow_filter.setter
    def netflow_filter(self, netflow_filter):
        """Sets the netflow_filter of this NetflowGroupWidget.


        :param netflow_filter: The netflow_filter of this NetflowGroupWidget.  # noqa: E501
        :type: NetflowFilters
        """

        self._netflow_filter = netflow_filter

    @property
    def device_group_name(self):
        """Gets the device_group_name of this NetflowGroupWidget.  # noqa: E501


        :return: The device_group_name of this NetflowGroupWidget.  # noqa: E501
        :rtype: str
        """
        return self._device_group_name

    @device_group_name.setter
    def device_group_name(self, device_group_name):
        """Sets the device_group_name of this NetflowGroupWidget.


        :param device_group_name: The device_group_name of this NetflowGroupWidget.  # noqa: E501
        :type: str
        """

        self._device_group_name = device_group_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetflowGroupWidget, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetflowGroupWidget):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
