# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NetflowEndpoint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_seen': 'int',
        'percent_usage': 'float',
        'data_type': 'str',
        'ip': 'str',
        'usage': 'float',
        'dns': 'str',
        'type': 'str'
    }

    attribute_map = {
        'last_seen': 'lastSeen',
        'percent_usage': 'percentUsage',
        'data_type': 'dataType',
        'ip': 'IP',
        'usage': 'usage',
        'dns': 'dns',
        'type': 'type'
    }

    def __init__(self, last_seen=None, percent_usage=None, data_type=None, ip=None, usage=None, dns=None, type=None):  # noqa: E501
        """NetflowEndpoint - a model defined in Swagger"""  # noqa: E501

        self._last_seen = None
        self._percent_usage = None
        self._data_type = None
        self._ip = None
        self._usage = None
        self._dns = None
        self._type = None
        self.discriminator = None

        if last_seen is not None:
            self.last_seen = last_seen
        if percent_usage is not None:
            self.percent_usage = percent_usage
        if data_type is not None:
            self.data_type = data_type
        if ip is not None:
            self.ip = ip
        if usage is not None:
            self.usage = usage
        if dns is not None:
            self.dns = dns
        if type is not None:
            self.type = type

    @property
    def last_seen(self):
        """Gets the last_seen of this NetflowEndpoint.  # noqa: E501


        :return: The last_seen of this NetflowEndpoint.  # noqa: E501
        :rtype: int
        """
        return self._last_seen

    @last_seen.setter
    def last_seen(self, last_seen):
        """Sets the last_seen of this NetflowEndpoint.


        :param last_seen: The last_seen of this NetflowEndpoint.  # noqa: E501
        :type: int
        """

        self._last_seen = last_seen

    @property
    def percent_usage(self):
        """Gets the percent_usage of this NetflowEndpoint.  # noqa: E501


        :return: The percent_usage of this NetflowEndpoint.  # noqa: E501
        :rtype: float
        """
        return self._percent_usage

    @percent_usage.setter
    def percent_usage(self, percent_usage):
        """Sets the percent_usage of this NetflowEndpoint.


        :param percent_usage: The percent_usage of this NetflowEndpoint.  # noqa: E501
        :type: float
        """

        self._percent_usage = percent_usage

    @property
    def data_type(self):
        """Gets the data_type of this NetflowEndpoint.  # noqa: E501


        :return: The data_type of this NetflowEndpoint.  # noqa: E501
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this NetflowEndpoint.


        :param data_type: The data_type of this NetflowEndpoint.  # noqa: E501
        :type: str
        """

        self._data_type = data_type

    @property
    def ip(self):
        """Gets the ip of this NetflowEndpoint.  # noqa: E501


        :return: The ip of this NetflowEndpoint.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this NetflowEndpoint.


        :param ip: The ip of this NetflowEndpoint.  # noqa: E501
        :type: str
        """

        self._ip = ip

    @property
    def usage(self):
        """Gets the usage of this NetflowEndpoint.  # noqa: E501


        :return: The usage of this NetflowEndpoint.  # noqa: E501
        :rtype: float
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """Sets the usage of this NetflowEndpoint.


        :param usage: The usage of this NetflowEndpoint.  # noqa: E501
        :type: float
        """

        self._usage = usage

    @property
    def dns(self):
        """Gets the dns of this NetflowEndpoint.  # noqa: E501


        :return: The dns of this NetflowEndpoint.  # noqa: E501
        :rtype: str
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """Sets the dns of this NetflowEndpoint.


        :param dns: The dns of this NetflowEndpoint.  # noqa: E501
        :type: str
        """

        self._dns = dns

    @property
    def type(self):
        """Gets the type of this NetflowEndpoint.  # noqa: E501


        :return: The type of this NetflowEndpoint.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NetflowEndpoint.


        :param type: The type of this NetflowEndpoint.  # noqa: E501
        :type: str
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetflowEndpoint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetflowEndpoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
