# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.netflow_data_base import NetflowDataBase  # noqa: F401,E501


class NetflowBandwidth(NetflowDataBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data_type': 'str',
        'receive': 'float',
        'usage': 'float',
        'send': 'float',
        'device_display_name': 'str'
    }

    attribute_map = {
        'data_type': 'dataType',
        'receive': 'receive',
        'usage': 'usage',
        'send': 'send',
        'device_display_name': 'deviceDisplayName'
    }

    def __init__(self, data_type=None, receive=None, usage=None, send=None, device_display_name=None):  # noqa: E501
        """NetflowBandwidth - a model defined in Swagger"""  # noqa: E501

        self._data_type = None
        self._receive = None
        self._usage = None
        self._send = None
        self._device_display_name = None
        self.discriminator = None

        if data_type is not None:
            self.data_type = data_type
        if receive is not None:
            self.receive = receive
        if usage is not None:
            self.usage = usage
        if send is not None:
            self.send = send
        if device_display_name is not None:
            self.device_display_name = device_display_name

    @property
    def data_type(self):
        """Gets the data_type of this NetflowBandwidth.  # noqa: E501


        :return: The data_type of this NetflowBandwidth.  # noqa: E501
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this NetflowBandwidth.


        :param data_type: The data_type of this NetflowBandwidth.  # noqa: E501
        :type: str
        """

        self._data_type = data_type

    @property
    def receive(self):
        """Gets the receive of this NetflowBandwidth.  # noqa: E501


        :return: The receive of this NetflowBandwidth.  # noqa: E501
        :rtype: float
        """
        return self._receive

    @receive.setter
    def receive(self, receive):
        """Sets the receive of this NetflowBandwidth.


        :param receive: The receive of this NetflowBandwidth.  # noqa: E501
        :type: float
        """

        self._receive = receive

    @property
    def usage(self):
        """Gets the usage of this NetflowBandwidth.  # noqa: E501


        :return: The usage of this NetflowBandwidth.  # noqa: E501
        :rtype: float
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """Sets the usage of this NetflowBandwidth.


        :param usage: The usage of this NetflowBandwidth.  # noqa: E501
        :type: float
        """

        self._usage = usage

    @property
    def send(self):
        """Gets the send of this NetflowBandwidth.  # noqa: E501


        :return: The send of this NetflowBandwidth.  # noqa: E501
        :rtype: float
        """
        return self._send

    @send.setter
    def send(self, send):
        """Sets the send of this NetflowBandwidth.


        :param send: The send of this NetflowBandwidth.  # noqa: E501
        :type: float
        """

        self._send = send

    @property
    def device_display_name(self):
        """Gets the device_display_name of this NetflowBandwidth.  # noqa: E501


        :return: The device_display_name of this NetflowBandwidth.  # noqa: E501
        :rtype: str
        """
        return self._device_display_name

    @device_display_name.setter
    def device_display_name(self, device_display_name):
        """Sets the device_display_name of this NetflowBandwidth.


        :param device_display_name: The device_display_name of this NetflowBandwidth.  # noqa: E501
        :type: str
        """

        self._device_display_name = device_display_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetflowBandwidth, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetflowBandwidth):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
