# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.netflow_data_base import NetflowDataBase  # noqa: F401,E501


class NetflowApplication(NetflowDataBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data_type': 'str',
        'first_epoch_in_sec': 'int',
        'protocol': 'str',
        'source_m_bytes': 'float',
        'percent_usage': 'float',
        'port': 'int',
        'last_epoch_in_sec': 'int',
        'destination_m_bytes': 'float',
        'ip': 'str',
        'usage': 'float',
        'dns': 'str',
        'flow_count': 'int',
        'client_count': 'int'
    }

    attribute_map = {
        'data_type': 'dataType',
        'first_epoch_in_sec': 'firstEpochInSec',
        'protocol': 'protocol',
        'source_m_bytes': 'sourceMBytes',
        'percent_usage': 'percentUsage',
        'port': 'port',
        'last_epoch_in_sec': 'lastEpochInSec',
        'destination_m_bytes': 'destinationMBytes',
        'ip': 'IP',
        'usage': 'usage',
        'dns': 'dns',
        'flow_count': 'flowCount',
        'client_count': 'clientCount'
    }

    def __init__(self, data_type=None, first_epoch_in_sec=None, protocol=None, source_m_bytes=None, percent_usage=None, port=None, last_epoch_in_sec=None, destination_m_bytes=None, ip=None, usage=None, dns=None, flow_count=None, client_count=None):  # noqa: E501
        """NetflowApplication - a model defined in Swagger"""  # noqa: E501

        self._data_type = None
        self._first_epoch_in_sec = None
        self._protocol = None
        self._source_m_bytes = None
        self._percent_usage = None
        self._port = None
        self._last_epoch_in_sec = None
        self._destination_m_bytes = None
        self._ip = None
        self._usage = None
        self._dns = None
        self._flow_count = None
        self._client_count = None
        self.discriminator = None

        if data_type is not None:
            self.data_type = data_type
        if first_epoch_in_sec is not None:
            self.first_epoch_in_sec = first_epoch_in_sec
        if protocol is not None:
            self.protocol = protocol
        if source_m_bytes is not None:
            self.source_m_bytes = source_m_bytes
        if percent_usage is not None:
            self.percent_usage = percent_usage
        if port is not None:
            self.port = port
        if last_epoch_in_sec is not None:
            self.last_epoch_in_sec = last_epoch_in_sec
        if destination_m_bytes is not None:
            self.destination_m_bytes = destination_m_bytes
        if ip is not None:
            self.ip = ip
        if usage is not None:
            self.usage = usage
        if dns is not None:
            self.dns = dns
        if flow_count is not None:
            self.flow_count = flow_count
        if client_count is not None:
            self.client_count = client_count

    @property
    def data_type(self):
        """Gets the data_type of this NetflowApplication.  # noqa: E501


        :return: The data_type of this NetflowApplication.  # noqa: E501
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """Sets the data_type of this NetflowApplication.


        :param data_type: The data_type of this NetflowApplication.  # noqa: E501
        :type: str
        """

        self._data_type = data_type

    @property
    def first_epoch_in_sec(self):
        """Gets the first_epoch_in_sec of this NetflowApplication.  # noqa: E501


        :return: The first_epoch_in_sec of this NetflowApplication.  # noqa: E501
        :rtype: int
        """
        return self._first_epoch_in_sec

    @first_epoch_in_sec.setter
    def first_epoch_in_sec(self, first_epoch_in_sec):
        """Sets the first_epoch_in_sec of this NetflowApplication.


        :param first_epoch_in_sec: The first_epoch_in_sec of this NetflowApplication.  # noqa: E501
        :type: int
        """

        self._first_epoch_in_sec = first_epoch_in_sec

    @property
    def protocol(self):
        """Gets the protocol of this NetflowApplication.  # noqa: E501


        :return: The protocol of this NetflowApplication.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this NetflowApplication.


        :param protocol: The protocol of this NetflowApplication.  # noqa: E501
        :type: str
        """

        self._protocol = protocol

    @property
    def source_m_bytes(self):
        """Gets the source_m_bytes of this NetflowApplication.  # noqa: E501


        :return: The source_m_bytes of this NetflowApplication.  # noqa: E501
        :rtype: float
        """
        return self._source_m_bytes

    @source_m_bytes.setter
    def source_m_bytes(self, source_m_bytes):
        """Sets the source_m_bytes of this NetflowApplication.


        :param source_m_bytes: The source_m_bytes of this NetflowApplication.  # noqa: E501
        :type: float
        """

        self._source_m_bytes = source_m_bytes

    @property
    def percent_usage(self):
        """Gets the percent_usage of this NetflowApplication.  # noqa: E501


        :return: The percent_usage of this NetflowApplication.  # noqa: E501
        :rtype: float
        """
        return self._percent_usage

    @percent_usage.setter
    def percent_usage(self, percent_usage):
        """Sets the percent_usage of this NetflowApplication.


        :param percent_usage: The percent_usage of this NetflowApplication.  # noqa: E501
        :type: float
        """

        self._percent_usage = percent_usage

    @property
    def port(self):
        """Gets the port of this NetflowApplication.  # noqa: E501


        :return: The port of this NetflowApplication.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this NetflowApplication.


        :param port: The port of this NetflowApplication.  # noqa: E501
        :type: int
        """

        self._port = port

    @property
    def last_epoch_in_sec(self):
        """Gets the last_epoch_in_sec of this NetflowApplication.  # noqa: E501


        :return: The last_epoch_in_sec of this NetflowApplication.  # noqa: E501
        :rtype: int
        """
        return self._last_epoch_in_sec

    @last_epoch_in_sec.setter
    def last_epoch_in_sec(self, last_epoch_in_sec):
        """Sets the last_epoch_in_sec of this NetflowApplication.


        :param last_epoch_in_sec: The last_epoch_in_sec of this NetflowApplication.  # noqa: E501
        :type: int
        """

        self._last_epoch_in_sec = last_epoch_in_sec

    @property
    def destination_m_bytes(self):
        """Gets the destination_m_bytes of this NetflowApplication.  # noqa: E501


        :return: The destination_m_bytes of this NetflowApplication.  # noqa: E501
        :rtype: float
        """
        return self._destination_m_bytes

    @destination_m_bytes.setter
    def destination_m_bytes(self, destination_m_bytes):
        """Sets the destination_m_bytes of this NetflowApplication.


        :param destination_m_bytes: The destination_m_bytes of this NetflowApplication.  # noqa: E501
        :type: float
        """

        self._destination_m_bytes = destination_m_bytes

    @property
    def ip(self):
        """Gets the ip of this NetflowApplication.  # noqa: E501


        :return: The ip of this NetflowApplication.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this NetflowApplication.


        :param ip: The ip of this NetflowApplication.  # noqa: E501
        :type: str
        """

        self._ip = ip

    @property
    def usage(self):
        """Gets the usage of this NetflowApplication.  # noqa: E501


        :return: The usage of this NetflowApplication.  # noqa: E501
        :rtype: float
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """Sets the usage of this NetflowApplication.


        :param usage: The usage of this NetflowApplication.  # noqa: E501
        :type: float
        """

        self._usage = usage

    @property
    def dns(self):
        """Gets the dns of this NetflowApplication.  # noqa: E501


        :return: The dns of this NetflowApplication.  # noqa: E501
        :rtype: str
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """Sets the dns of this NetflowApplication.


        :param dns: The dns of this NetflowApplication.  # noqa: E501
        :type: str
        """

        self._dns = dns

    @property
    def flow_count(self):
        """Gets the flow_count of this NetflowApplication.  # noqa: E501


        :return: The flow_count of this NetflowApplication.  # noqa: E501
        :rtype: int
        """
        return self._flow_count

    @flow_count.setter
    def flow_count(self, flow_count):
        """Sets the flow_count of this NetflowApplication.


        :param flow_count: The flow_count of this NetflowApplication.  # noqa: E501
        :type: int
        """

        self._flow_count = flow_count

    @property
    def client_count(self):
        """Gets the client_count of this NetflowApplication.  # noqa: E501


        :return: The client_count of this NetflowApplication.  # noqa: E501
        :rtype: int
        """
        return self._client_count

    @client_count.setter
    def client_count(self, client_count):
        """Sets the client_count of this NetflowApplication.


        :param client_count: The client_count of this NetflowApplication.  # noqa: E501
        :type: int
        """

        self._client_count = client_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetflowApplication, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetflowApplication):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
