# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.auto_discovery_method import AutoDiscoveryMethod  # noqa: F401,E501


class NetAppAutoDiscoveryMethod(AutoDiscoveryMethod):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'request': 'str',
        'instance_name': 'str',
        'type': 'str',
        'instance_group_name': 'str',
        'instance_value': 'str',
        'instance_description': 'str',
        'object': 'str',
        'instance_locator': 'str'
    }

    attribute_map = {
        'name': 'name',
        'request': 'request',
        'instance_name': 'instanceName',
        'type': 'type',
        'instance_group_name': 'instanceGroupName',
        'instance_value': 'instanceValue',
        'instance_description': 'instanceDescription',
        'object': 'object',
        'instance_locator': 'instanceLocator'
    }

    def __init__(self, name=None, request=None, instance_name=None, type=None, instance_group_name=None, instance_value=None, instance_description=None, object=None, instance_locator=None):  # noqa: E501
        """NetAppAutoDiscoveryMethod - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._request = None
        self._instance_name = None
        self._type = None
        self._instance_group_name = None
        self._instance_value = None
        self._instance_description = None
        self._object = None
        self._instance_locator = None
        self.discriminator = None

        self.name = name
        if request is not None:
            self.request = request
        if instance_name is not None:
            self.instance_name = instance_name
        self.type = type
        if instance_group_name is not None:
            self.instance_group_name = instance_group_name
        if instance_value is not None:
            self.instance_value = instance_value
        if instance_description is not None:
            self.instance_description = instance_description
        if object is not None:
            self.object = object
        if instance_locator is not None:
            self.instance_locator = instance_locator

    @property
    def name(self):
        """Gets the name of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NetAppAutoDiscoveryMethod.


        :param name: The name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def request(self):
        """Gets the request of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The request of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._request

    @request.setter
    def request(self, request):
        """Sets the request of this NetAppAutoDiscoveryMethod.


        :param request: The request of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._request = request

    @property
    def instance_name(self):
        """Gets the instance_name of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The instance_name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """Sets the instance_name of this NetAppAutoDiscoveryMethod.


        :param instance_name: The instance_name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._instance_name = instance_name

    @property
    def type(self):
        """Gets the type of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The type of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NetAppAutoDiscoveryMethod.


        :param type: The type of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def instance_group_name(self):
        """Gets the instance_group_name of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The instance_group_name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._instance_group_name

    @instance_group_name.setter
    def instance_group_name(self, instance_group_name):
        """Sets the instance_group_name of this NetAppAutoDiscoveryMethod.


        :param instance_group_name: The instance_group_name of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._instance_group_name = instance_group_name

    @property
    def instance_value(self):
        """Gets the instance_value of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The instance_value of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._instance_value

    @instance_value.setter
    def instance_value(self, instance_value):
        """Sets the instance_value of this NetAppAutoDiscoveryMethod.


        :param instance_value: The instance_value of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._instance_value = instance_value

    @property
    def instance_description(self):
        """Gets the instance_description of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The instance_description of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._instance_description

    @instance_description.setter
    def instance_description(self, instance_description):
        """Sets the instance_description of this NetAppAutoDiscoveryMethod.


        :param instance_description: The instance_description of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._instance_description = instance_description

    @property
    def object(self):
        """Gets the object of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The object of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._object

    @object.setter
    def object(self, object):
        """Sets the object of this NetAppAutoDiscoveryMethod.


        :param object: The object of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._object = object

    @property
    def instance_locator(self):
        """Gets the instance_locator of this NetAppAutoDiscoveryMethod.  # noqa: E501


        :return: The instance_locator of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :rtype: str
        """
        return self._instance_locator

    @instance_locator.setter
    def instance_locator(self, instance_locator):
        """Sets the instance_locator of this NetAppAutoDiscoveryMethod.


        :param instance_locator: The instance_locator of this NetAppAutoDiscoveryMethod.  # noqa: E501
        :type: str
        """

        self._instance_locator = instance_locator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NetAppAutoDiscoveryMethod, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetAppAutoDiscoveryMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
