# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.assignment import Assignment  # noqa: F401,E501


class NMapDDR(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'change_name': 'str',
        'assignment': 'list[Assignment]'
    }

    attribute_map = {
        'change_name': 'changeName',
        'assignment': 'assignment'
    }

    def __init__(self, change_name=None, assignment=None):  # noqa: E501
        """NMapDDR - a model defined in Swagger"""  # noqa: E501

        self._change_name = None
        self._assignment = None
        self.discriminator = None

        if change_name is not None:
            self.change_name = change_name
        if assignment is not None:
            self.assignment = assignment

    @property
    def change_name(self):
        """Gets the change_name of this NMapDDR.  # noqa: E501


        :return: The change_name of this NMapDDR.  # noqa: E501
        :rtype: str
        """
        return self._change_name

    @change_name.setter
    def change_name(self, change_name):
        """Sets the change_name of this NMapDDR.


        :param change_name: The change_name of this NMapDDR.  # noqa: E501
        :type: str
        """

        self._change_name = change_name

    @property
    def assignment(self):
        """Gets the assignment of this NMapDDR.  # noqa: E501

        Information about how discovered devices are included in or excluded from monitoring. Assignment objects can be created for different types of discovered devices  # noqa: E501

        :return: The assignment of this NMapDDR.  # noqa: E501
        :rtype: list[Assignment]
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """Sets the assignment of this NMapDDR.

        Information about how discovered devices are included in or excluded from monitoring. Assignment objects can be created for different types of discovered devices  # noqa: E501

        :param assignment: The assignment of this NMapDDR.  # noqa: E501
        :type: list[Assignment]
        """

        self._assignment = assignment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NMapDDR, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NMapDDR):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
