# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.match_pattern import MatchPattern  # noqa: F401,E501


class LogFile(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'path': 'str',
        'excludes': 'list[str]',
        'use_glob': 'bool',
        'encoding': 'str',
        'matches': 'list[MatchPattern]'
    }

    attribute_map = {
        'path': 'path',
        'excludes': 'excludes',
        'use_glob': 'useGlob',
        'encoding': 'encoding',
        'matches': 'matches'
    }

    def __init__(self, path=None, excludes=None, use_glob=None, encoding=None, matches=None):  # noqa: E501
        """LogFile - a model defined in Swagger"""  # noqa: E501

        self._path = None
        self._excludes = None
        self._use_glob = None
        self._encoding = None
        self._matches = None
        self.discriminator = None

        if path is not None:
            self.path = path
        if excludes is not None:
            self.excludes = excludes
        if use_glob is not None:
            self.use_glob = use_glob
        if encoding is not None:
            self.encoding = encoding
        if matches is not None:
            self.matches = matches

    @property
    def path(self):
        """Gets the path of this LogFile.  # noqa: E501

        The path of the log file to monitor  # noqa: E501

        :return: The path of this LogFile.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this LogFile.

        The path of the log file to monitor  # noqa: E501

        :param path: The path of this LogFile.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def excludes(self):
        """Gets the excludes of this LogFile.  # noqa: E501

        The regex or plain text to look for in the file and not trigger alert if found  # noqa: E501

        :return: The excludes of this LogFile.  # noqa: E501
        :rtype: list[str]
        """
        return self._excludes

    @excludes.setter
    def excludes(self, excludes):
        """Sets the excludes of this LogFile.

        The regex or plain text to look for in the file and not trigger alert if found  # noqa: E501

        :param excludes: The excludes of this LogFile.  # noqa: E501
        :type: list[str]
        """

        self._excludes = excludes

    @property
    def use_glob(self):
        """Gets the use_glob of this LogFile.  # noqa: E501

        Whether or not glob is used in the path  # noqa: E501

        :return: The use_glob of this LogFile.  # noqa: E501
        :rtype: bool
        """
        return self._use_glob

    @use_glob.setter
    def use_glob(self, use_glob):
        """Sets the use_glob of this LogFile.

        Whether or not glob is used in the path  # noqa: E501

        :param use_glob: The use_glob of this LogFile.  # noqa: E501
        :type: bool
        """

        self._use_glob = use_glob

    @property
    def encoding(self):
        """Gets the encoding of this LogFile.  # noqa: E501

        The file encoding: default | auto | UTF-8 | UTF-16  # noqa: E501

        :return: The encoding of this LogFile.  # noqa: E501
        :rtype: str
        """
        return self._encoding

    @encoding.setter
    def encoding(self, encoding):
        """Sets the encoding of this LogFile.

        The file encoding: default | auto | UTF-8 | UTF-16  # noqa: E501

        :param encoding: The encoding of this LogFile.  # noqa: E501
        :type: str
        """

        self._encoding = encoding

    @property
    def matches(self):
        """Gets the matches of this LogFile.  # noqa: E501


        :return: The matches of this LogFile.  # noqa: E501
        :rtype: list[MatchPattern]
        """
        return self._matches

    @matches.setter
    def matches(self, matches):
        """Sets the matches of this LogFile.


        :param matches: The matches of this LogFile.  # noqa: E501
        :type: list[MatchPattern]
        """

        self._matches = matches

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LogFile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LogFile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
