# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.ilp import ILP  # noqa: F401,E501
from logicmonitor_sdk.models.property_match_rule import PropertyMatchRule  # noqa: F401,E501


class LinkedWmiClass(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'anchor_class_wmi_property': 'str',
        'linked_wmi_class': 'str',
        'match': 'PropertyMatchRule',
        'my_link_wmi_property': 'str',
        'ilp': 'list[ILP]'
    }

    attribute_map = {
        'anchor_class_wmi_property': 'anchorClassWMIProperty',
        'linked_wmi_class': 'linkedWmiClass',
        'match': 'match',
        'my_link_wmi_property': 'myLinkWMIProperty',
        'ilp': 'ILP'
    }

    def __init__(self, anchor_class_wmi_property=None, linked_wmi_class=None, match=None, my_link_wmi_property=None, ilp=None):  # noqa: E501
        """LinkedWmiClass - a model defined in Swagger"""  # noqa: E501

        self._anchor_class_wmi_property = None
        self._linked_wmi_class = None
        self._match = None
        self._my_link_wmi_property = None
        self._ilp = None
        self.discriminator = None

        self.anchor_class_wmi_property = anchor_class_wmi_property
        self.linked_wmi_class = linked_wmi_class
        if match is not None:
            self.match = match
        if my_link_wmi_property is not None:
            self.my_link_wmi_property = my_link_wmi_property
        if ilp is not None:
            self.ilp = ilp

    @property
    def anchor_class_wmi_property(self):
        """Gets the anchor_class_wmi_property of this LinkedWmiClass.  # noqa: E501


        :return: The anchor_class_wmi_property of this LinkedWmiClass.  # noqa: E501
        :rtype: str
        """
        return self._anchor_class_wmi_property

    @anchor_class_wmi_property.setter
    def anchor_class_wmi_property(self, anchor_class_wmi_property):
        """Sets the anchor_class_wmi_property of this LinkedWmiClass.


        :param anchor_class_wmi_property: The anchor_class_wmi_property of this LinkedWmiClass.  # noqa: E501
        :type: str
        """
        if anchor_class_wmi_property is None:
            raise ValueError("Invalid value for `anchor_class_wmi_property`, must not be `None`")  # noqa: E501

        self._anchor_class_wmi_property = anchor_class_wmi_property

    @property
    def linked_wmi_class(self):
        """Gets the linked_wmi_class of this LinkedWmiClass.  # noqa: E501


        :return: The linked_wmi_class of this LinkedWmiClass.  # noqa: E501
        :rtype: str
        """
        return self._linked_wmi_class

    @linked_wmi_class.setter
    def linked_wmi_class(self, linked_wmi_class):
        """Sets the linked_wmi_class of this LinkedWmiClass.


        :param linked_wmi_class: The linked_wmi_class of this LinkedWmiClass.  # noqa: E501
        :type: str
        """
        if linked_wmi_class is None:
            raise ValueError("Invalid value for `linked_wmi_class`, must not be `None`")  # noqa: E501

        self._linked_wmi_class = linked_wmi_class

    @property
    def match(self):
        """Gets the match of this LinkedWmiClass.  # noqa: E501


        :return: The match of this LinkedWmiClass.  # noqa: E501
        :rtype: PropertyMatchRule
        """
        return self._match

    @match.setter
    def match(self, match):
        """Sets the match of this LinkedWmiClass.


        :param match: The match of this LinkedWmiClass.  # noqa: E501
        :type: PropertyMatchRule
        """

        self._match = match

    @property
    def my_link_wmi_property(self):
        """Gets the my_link_wmi_property of this LinkedWmiClass.  # noqa: E501


        :return: The my_link_wmi_property of this LinkedWmiClass.  # noqa: E501
        :rtype: str
        """
        return self._my_link_wmi_property

    @my_link_wmi_property.setter
    def my_link_wmi_property(self, my_link_wmi_property):
        """Sets the my_link_wmi_property of this LinkedWmiClass.


        :param my_link_wmi_property: The my_link_wmi_property of this LinkedWmiClass.  # noqa: E501
        :type: str
        """

        self._my_link_wmi_property = my_link_wmi_property

    @property
    def ilp(self):
        """Gets the ilp of this LinkedWmiClass.  # noqa: E501


        :return: The ilp of this LinkedWmiClass.  # noqa: E501
        :rtype: list[ILP]
        """
        return self._ilp

    @ilp.setter
    def ilp(self, ilp):
        """Sets the ilp of this LinkedWmiClass.


        :param ilp: The ilp of this LinkedWmiClass.  # noqa: E501
        :type: list[ILP]
        """

        self._ilp = ilp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LinkedWmiClass, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LinkedWmiClass):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
