# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.collector_attribute import CollectorAttribute  # noqa: F401,E501


class JDBCCollectorAttribute(CollectorAttribute):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'password': 'str',
        'query': 'str',
        'url': 'str',
        'username': 'str'
    }

    attribute_map = {
        'name': 'name',
        'password': 'password',
        'query': 'query',
        'url': 'url',
        'username': 'username'
    }

    def __init__(self, name=None, password=None, query=None, url=None, username=None):  # noqa: E501
        """JDBCCollectorAttribute - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._password = None
        self._query = None
        self._url = None
        self._username = None
        self.discriminator = None

        self.name = name
        if password is not None:
            self.password = password
        if query is not None:
            self.query = query
        if url is not None:
            self.url = url
        if username is not None:
            self.username = username

    @property
    def name(self):
        """Gets the name of this JDBCCollectorAttribute.  # noqa: E501


        :return: The name of this JDBCCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JDBCCollectorAttribute.


        :param name: The name of this JDBCCollectorAttribute.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def password(self):
        """Gets the password of this JDBCCollectorAttribute.  # noqa: E501


        :return: The password of this JDBCCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this JDBCCollectorAttribute.


        :param password: The password of this JDBCCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._password = password

    @property
    def query(self):
        """Gets the query of this JDBCCollectorAttribute.  # noqa: E501


        :return: The query of this JDBCCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this JDBCCollectorAttribute.


        :param query: The query of this JDBCCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._query = query

    @property
    def url(self):
        """Gets the url of this JDBCCollectorAttribute.  # noqa: E501


        :return: The url of this JDBCCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this JDBCCollectorAttribute.


        :param url: The url of this JDBCCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def username(self):
        """Gets the username of this JDBCCollectorAttribute.  # noqa: E501


        :return: The username of this JDBCCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this JDBCCollectorAttribute.


        :param username: The username of this JDBCCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(JDBCCollectorAttribute, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JDBCCollectorAttribute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
