# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GenerateReportRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'with_admin_id': 'int',
        'report_id': 'int',
        'receive_emails': 'str'
    }

    attribute_map = {
        'with_admin_id': 'withAdminId',
        'report_id': 'reportId',
        'receive_emails': 'receiveEmails'
    }

    def __init__(self, with_admin_id=None, report_id=None, receive_emails=None):  # noqa: E501
        """GenerateReportRequest - a model defined in Swagger"""  # noqa: E501

        self._with_admin_id = None
        self._report_id = None
        self._receive_emails = None
        self.discriminator = None

        if with_admin_id is not None:
            self.with_admin_id = with_admin_id
        if report_id is not None:
            self.report_id = report_id
        if receive_emails is not None:
            self.receive_emails = receive_emails

    @property
    def with_admin_id(self):
        """Gets the with_admin_id of this GenerateReportRequest.  # noqa: E501

        Generate the report with the admin. 0 mean current user  # noqa: E501

        :return: The with_admin_id of this GenerateReportRequest.  # noqa: E501
        :rtype: int
        """
        return self._with_admin_id

    @with_admin_id.setter
    def with_admin_id(self, with_admin_id):
        """Sets the with_admin_id of this GenerateReportRequest.

        Generate the report with the admin. 0 mean current user  # noqa: E501

        :param with_admin_id: The with_admin_id of this GenerateReportRequest.  # noqa: E501
        :type: int
        """

        self._with_admin_id = with_admin_id

    @property
    def report_id(self):
        """Gets the report_id of this GenerateReportRequest.  # noqa: E501

        The id of the report to run  # noqa: E501

        :return: The report_id of this GenerateReportRequest.  # noqa: E501
        :rtype: int
        """
        return self._report_id

    @report_id.setter
    def report_id(self, report_id):
        """Sets the report_id of this GenerateReportRequest.

        The id of the report to run  # noqa: E501

        :param report_id: The report_id of this GenerateReportRequest.  # noqa: E501
        :type: int
        """

        self._report_id = report_id

    @property
    def receive_emails(self):
        """Gets the receive_emails of this GenerateReportRequest.  # noqa: E501

        The email addresses that LogicMonitor should send the report to, separated by commas  # noqa: E501

        :return: The receive_emails of this GenerateReportRequest.  # noqa: E501
        :rtype: str
        """
        return self._receive_emails

    @receive_emails.setter
    def receive_emails(self, receive_emails):
        """Sets the receive_emails of this GenerateReportRequest.

        The email addresses that LogicMonitor should send the report to, separated by commas  # noqa: E501

        :param receive_emails: The receive_emails of this GenerateReportRequest.  # noqa: E501
        :type: str
        """

        self._receive_emails = receive_emails

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerateReportRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerateReportRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
