# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.widget_data import WidgetData  # noqa: F401,E501


class GaugeWidgetData(WidgetData):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'title': 'str',
        'max_value': 'float',
        'legend': 'str',
        'peak_time': 'int',
        'history_timestamps': 'list[int]',
        'display_unit': 'str',
        'peak_time_on_local': 'str',
        'color_level': 'int',
        'peak_value': 'float',
        'min_value': 'float',
        'display_type': 'int',
        'show_peak': 'bool',
        'current_value': 'float',
        'history_values': 'object'
    }

    attribute_map = {
        'type': 'type',
        'title': 'title',
        'max_value': 'maxValue',
        'legend': 'legend',
        'peak_time': 'peakTime',
        'history_timestamps': 'historyTimestamps',
        'display_unit': 'displayUnit',
        'peak_time_on_local': 'peakTimeOnLocal',
        'color_level': 'colorLevel',
        'peak_value': 'peakValue',
        'min_value': 'minValue',
        'display_type': 'displayType',
        'show_peak': 'showPeak',
        'current_value': 'currentValue',
        'history_values': 'historyValues'
    }

    def __init__(self, type=None, title=None, max_value=None, legend=None, peak_time=None, history_timestamps=None, display_unit=None, peak_time_on_local=None, color_level=None, peak_value=None, min_value=None, display_type=None, show_peak=None, current_value=None, history_values=None):  # noqa: E501
        """GaugeWidgetData - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._title = None
        self._max_value = None
        self._legend = None
        self._peak_time = None
        self._history_timestamps = None
        self._display_unit = None
        self._peak_time_on_local = None
        self._color_level = None
        self._peak_value = None
        self._min_value = None
        self._display_type = None
        self._show_peak = None
        self._current_value = None
        self._history_values = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if title is not None:
            self.title = title
        if max_value is not None:
            self.max_value = max_value
        if legend is not None:
            self.legend = legend
        if peak_time is not None:
            self.peak_time = peak_time
        if history_timestamps is not None:
            self.history_timestamps = history_timestamps
        if display_unit is not None:
            self.display_unit = display_unit
        if peak_time_on_local is not None:
            self.peak_time_on_local = peak_time_on_local
        if color_level is not None:
            self.color_level = color_level
        if peak_value is not None:
            self.peak_value = peak_value
        if min_value is not None:
            self.min_value = min_value
        if display_type is not None:
            self.display_type = display_type
        if show_peak is not None:
            self.show_peak = show_peak
        if current_value is not None:
            self.current_value = current_value
        if history_values is not None:
            self.history_values = history_values

    @property
    def type(self):
        """Gets the type of this GaugeWidgetData.  # noqa: E501


        :return: The type of this GaugeWidgetData.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this GaugeWidgetData.


        :param type: The type of this GaugeWidgetData.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def title(self):
        """Gets the title of this GaugeWidgetData.  # noqa: E501


        :return: The title of this GaugeWidgetData.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this GaugeWidgetData.


        :param title: The title of this GaugeWidgetData.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def max_value(self):
        """Gets the max_value of this GaugeWidgetData.  # noqa: E501


        :return: The max_value of this GaugeWidgetData.  # noqa: E501
        :rtype: float
        """
        return self._max_value

    @max_value.setter
    def max_value(self, max_value):
        """Sets the max_value of this GaugeWidgetData.


        :param max_value: The max_value of this GaugeWidgetData.  # noqa: E501
        :type: float
        """

        self._max_value = max_value

    @property
    def legend(self):
        """Gets the legend of this GaugeWidgetData.  # noqa: E501


        :return: The legend of this GaugeWidgetData.  # noqa: E501
        :rtype: str
        """
        return self._legend

    @legend.setter
    def legend(self, legend):
        """Sets the legend of this GaugeWidgetData.


        :param legend: The legend of this GaugeWidgetData.  # noqa: E501
        :type: str
        """

        self._legend = legend

    @property
    def peak_time(self):
        """Gets the peak_time of this GaugeWidgetData.  # noqa: E501


        :return: The peak_time of this GaugeWidgetData.  # noqa: E501
        :rtype: int
        """
        return self._peak_time

    @peak_time.setter
    def peak_time(self, peak_time):
        """Sets the peak_time of this GaugeWidgetData.


        :param peak_time: The peak_time of this GaugeWidgetData.  # noqa: E501
        :type: int
        """

        self._peak_time = peak_time

    @property
    def history_timestamps(self):
        """Gets the history_timestamps of this GaugeWidgetData.  # noqa: E501


        :return: The history_timestamps of this GaugeWidgetData.  # noqa: E501
        :rtype: list[int]
        """
        return self._history_timestamps

    @history_timestamps.setter
    def history_timestamps(self, history_timestamps):
        """Sets the history_timestamps of this GaugeWidgetData.


        :param history_timestamps: The history_timestamps of this GaugeWidgetData.  # noqa: E501
        :type: list[int]
        """

        self._history_timestamps = history_timestamps

    @property
    def display_unit(self):
        """Gets the display_unit of this GaugeWidgetData.  # noqa: E501


        :return: The display_unit of this GaugeWidgetData.  # noqa: E501
        :rtype: str
        """
        return self._display_unit

    @display_unit.setter
    def display_unit(self, display_unit):
        """Sets the display_unit of this GaugeWidgetData.


        :param display_unit: The display_unit of this GaugeWidgetData.  # noqa: E501
        :type: str
        """

        self._display_unit = display_unit

    @property
    def peak_time_on_local(self):
        """Gets the peak_time_on_local of this GaugeWidgetData.  # noqa: E501


        :return: The peak_time_on_local of this GaugeWidgetData.  # noqa: E501
        :rtype: str
        """
        return self._peak_time_on_local

    @peak_time_on_local.setter
    def peak_time_on_local(self, peak_time_on_local):
        """Sets the peak_time_on_local of this GaugeWidgetData.


        :param peak_time_on_local: The peak_time_on_local of this GaugeWidgetData.  # noqa: E501
        :type: str
        """

        self._peak_time_on_local = peak_time_on_local

    @property
    def color_level(self):
        """Gets the color_level of this GaugeWidgetData.  # noqa: E501


        :return: The color_level of this GaugeWidgetData.  # noqa: E501
        :rtype: int
        """
        return self._color_level

    @color_level.setter
    def color_level(self, color_level):
        """Sets the color_level of this GaugeWidgetData.


        :param color_level: The color_level of this GaugeWidgetData.  # noqa: E501
        :type: int
        """

        self._color_level = color_level

    @property
    def peak_value(self):
        """Gets the peak_value of this GaugeWidgetData.  # noqa: E501


        :return: The peak_value of this GaugeWidgetData.  # noqa: E501
        :rtype: float
        """
        return self._peak_value

    @peak_value.setter
    def peak_value(self, peak_value):
        """Sets the peak_value of this GaugeWidgetData.


        :param peak_value: The peak_value of this GaugeWidgetData.  # noqa: E501
        :type: float
        """

        self._peak_value = peak_value

    @property
    def min_value(self):
        """Gets the min_value of this GaugeWidgetData.  # noqa: E501


        :return: The min_value of this GaugeWidgetData.  # noqa: E501
        :rtype: float
        """
        return self._min_value

    @min_value.setter
    def min_value(self, min_value):
        """Sets the min_value of this GaugeWidgetData.


        :param min_value: The min_value of this GaugeWidgetData.  # noqa: E501
        :type: float
        """

        self._min_value = min_value

    @property
    def display_type(self):
        """Gets the display_type of this GaugeWidgetData.  # noqa: E501


        :return: The display_type of this GaugeWidgetData.  # noqa: E501
        :rtype: int
        """
        return self._display_type

    @display_type.setter
    def display_type(self, display_type):
        """Sets the display_type of this GaugeWidgetData.


        :param display_type: The display_type of this GaugeWidgetData.  # noqa: E501
        :type: int
        """

        self._display_type = display_type

    @property
    def show_peak(self):
        """Gets the show_peak of this GaugeWidgetData.  # noqa: E501


        :return: The show_peak of this GaugeWidgetData.  # noqa: E501
        :rtype: bool
        """
        return self._show_peak

    @show_peak.setter
    def show_peak(self, show_peak):
        """Sets the show_peak of this GaugeWidgetData.


        :param show_peak: The show_peak of this GaugeWidgetData.  # noqa: E501
        :type: bool
        """

        self._show_peak = show_peak

    @property
    def current_value(self):
        """Gets the current_value of this GaugeWidgetData.  # noqa: E501


        :return: The current_value of this GaugeWidgetData.  # noqa: E501
        :rtype: float
        """
        return self._current_value

    @current_value.setter
    def current_value(self, current_value):
        """Sets the current_value of this GaugeWidgetData.


        :param current_value: The current_value of this GaugeWidgetData.  # noqa: E501
        :type: float
        """

        self._current_value = current_value

    @property
    def history_values(self):
        """Gets the history_values of this GaugeWidgetData.  # noqa: E501


        :return: The history_values of this GaugeWidgetData.  # noqa: E501
        :rtype: object
        """
        return self._history_values

    @history_values.setter
    def history_values(self, history_values):
        """Sets the history_values of this GaugeWidgetData.


        :param history_values: The history_values of this GaugeWidgetData.  # noqa: E501
        :type: object
        """

        self._history_values = history_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GaugeWidgetData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GaugeWidgetData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
