# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.color_threshold import ColorThreshold  # noqa: F401,E501
from logicmonitor_sdk.models.gauge_data_point import GaugeDataPoint  # noqa: F401,E501
from logicmonitor_sdk.models.widget import Widget  # noqa: F401,E501


class GaugeWidget(Widget):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_updated_by': 'str',
        'user_permission': 'str',
        'dashboard_id': 'int',
        'name': 'str',
        'description': 'str',
        'last_updated_on': 'int',
        'theme': 'str',
        'interval': 'int',
        'id': 'int',
        'type': 'str',
        'timescale': 'str',
        'min_value': 'float',
        'display_type': 'int',
        'peak_time_range': 'str',
        'legend': 'str',
        'max_value': 'float',
        'show_peak': 'bool',
        'data_point': 'GaugeDataPoint',
        'display_unit': 'str',
        'color_thresholds': 'list[ColorThreshold]'
    }

    attribute_map = {
        'last_updated_by': 'lastUpdatedBy',
        'user_permission': 'userPermission',
        'dashboard_id': 'dashboardId',
        'name': 'name',
        'description': 'description',
        'last_updated_on': 'lastUpdatedOn',
        'theme': 'theme',
        'interval': 'interval',
        'id': 'id',
        'type': 'type',
        'timescale': 'timescale',
        'min_value': 'minValue',
        'display_type': 'displayType',
        'peak_time_range': 'peakTimeRange',
        'legend': 'legend',
        'max_value': 'maxValue',
        'show_peak': 'showPeak',
        'data_point': 'dataPoint',
        'display_unit': 'displayUnit',
        'color_thresholds': 'colorThresholds'
    }

    def __init__(self, last_updated_by=None, user_permission=None, dashboard_id=None, name=None, description=None, last_updated_on=None, theme=None, interval=None, id=None, type=None, timescale=None, min_value=None, display_type=None, peak_time_range=None, legend=None, max_value=None, show_peak=None, data_point=None, display_unit=None, color_thresholds=None):  # noqa: E501
        """GaugeWidget - a model defined in Swagger"""  # noqa: E501

        self._last_updated_by = None
        self._user_permission = None
        self._dashboard_id = None
        self._name = None
        self._description = None
        self._last_updated_on = None
        self._theme = None
        self._interval = None
        self._id = None
        self._type = None
        self._timescale = None
        self._min_value = None
        self._display_type = None
        self._peak_time_range = None
        self._legend = None
        self._max_value = None
        self._show_peak = None
        self._data_point = None
        self._display_unit = None
        self._color_thresholds = None
        self.discriminator = None

        if last_updated_by is not None:
            self.last_updated_by = last_updated_by
        if user_permission is not None:
            self.user_permission = user_permission
        self.dashboard_id = dashboard_id
        self.name = name
        if description is not None:
            self.description = description
        if last_updated_on is not None:
            self.last_updated_on = last_updated_on
        if theme is not None:
            self.theme = theme
        if interval is not None:
            self.interval = interval
        if id is not None:
            self.id = id
        self.type = type
        if timescale is not None:
            self.timescale = timescale
        if min_value is not None:
            self.min_value = min_value
        if display_type is not None:
            self.display_type = display_type
        if peak_time_range is not None:
            self.peak_time_range = peak_time_range
        if legend is not None:
            self.legend = legend
        if max_value is not None:
            self.max_value = max_value
        if show_peak is not None:
            self.show_peak = show_peak
        self.data_point = data_point
        if display_unit is not None:
            self.display_unit = display_unit
        if color_thresholds is not None:
            self.color_thresholds = color_thresholds

    @property
    def last_updated_by(self):
        """Gets the last_updated_by of this GaugeWidget.  # noqa: E501

        The user that last updated the widget  # noqa: E501

        :return: The last_updated_by of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """Sets the last_updated_by of this GaugeWidget.

        The user that last updated the widget  # noqa: E501

        :param last_updated_by: The last_updated_by of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._last_updated_by = last_updated_by

    @property
    def user_permission(self):
        """Gets the user_permission of this GaugeWidget.  # noqa: E501

        The permission level of the user who last modified the widget  # noqa: E501

        :return: The user_permission of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this GaugeWidget.

        The permission level of the user who last modified the widget  # noqa: E501

        :param user_permission: The user_permission of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def dashboard_id(self):
        """Gets the dashboard_id of this GaugeWidget.  # noqa: E501

        The id of the dashboard the widget belongs to  # noqa: E501

        :return: The dashboard_id of this GaugeWidget.  # noqa: E501
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """Sets the dashboard_id of this GaugeWidget.

        The id of the dashboard the widget belongs to  # noqa: E501

        :param dashboard_id: The dashboard_id of this GaugeWidget.  # noqa: E501
        :type: int
        """
        if dashboard_id is None:
            raise ValueError("Invalid value for `dashboard_id`, must not be `None`")  # noqa: E501

        self._dashboard_id = dashboard_id

    @property
    def name(self):
        """Gets the name of this GaugeWidget.  # noqa: E501

        The name of the widget  # noqa: E501

        :return: The name of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GaugeWidget.

        The name of the widget  # noqa: E501

        :param name: The name of this GaugeWidget.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this GaugeWidget.  # noqa: E501

        The description of the widget  # noqa: E501

        :return: The description of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this GaugeWidget.

        The description of the widget  # noqa: E501

        :param description: The description of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def last_updated_on(self):
        """Gets the last_updated_on of this GaugeWidget.  # noqa: E501

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :return: The last_updated_on of this GaugeWidget.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_on

    @last_updated_on.setter
    def last_updated_on(self, last_updated_on):
        """Sets the last_updated_on of this GaugeWidget.

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :param last_updated_on: The last_updated_on of this GaugeWidget.  # noqa: E501
        :type: int
        """

        self._last_updated_on = last_updated_on

    @property
    def theme(self):
        """Gets the theme of this GaugeWidget.  # noqa: E501

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :return: The theme of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this GaugeWidget.

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :param theme: The theme of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._theme = theme

    @property
    def interval(self):
        """Gets the interval of this GaugeWidget.  # noqa: E501

        The refresh interval of the widget, in minutes  # noqa: E501

        :return: The interval of this GaugeWidget.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this GaugeWidget.

        The refresh interval of the widget, in minutes  # noqa: E501

        :param interval: The interval of this GaugeWidget.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def id(self):
        """Gets the id of this GaugeWidget.  # noqa: E501

        The Id of the widget  # noqa: E501

        :return: The id of this GaugeWidget.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GaugeWidget.

        The Id of the widget  # noqa: E501

        :param id: The id of this GaugeWidget.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this GaugeWidget.  # noqa: E501

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :return: The type of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this GaugeWidget.

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :param type: The type of this GaugeWidget.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def timescale(self):
        """Gets the timescale of this GaugeWidget.  # noqa: E501

        The default timescale of the widget  # noqa: E501

        :return: The timescale of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._timescale

    @timescale.setter
    def timescale(self, timescale):
        """Sets the timescale of this GaugeWidget.

        The default timescale of the widget  # noqa: E501

        :param timescale: The timescale of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._timescale = timescale

    @property
    def min_value(self):
        """Gets the min_value of this GaugeWidget.  # noqa: E501

        The minimum value of the gauge widget, displayed on the left side of the gauge  # noqa: E501

        :return: The min_value of this GaugeWidget.  # noqa: E501
        :rtype: float
        """
        return self._min_value

    @min_value.setter
    def min_value(self, min_value):
        """Sets the min_value of this GaugeWidget.

        The minimum value of the gauge widget, displayed on the left side of the gauge  # noqa: E501

        :param min_value: The min_value of this GaugeWidget.  # noqa: E501
        :type: float
        """

        self._min_value = min_value

    @property
    def display_type(self):
        """Gets the display_type of this GaugeWidget.  # noqa: E501

        Display as \"Raw Value\" or \"Percent\"  # noqa: E501

        :return: The display_type of this GaugeWidget.  # noqa: E501
        :rtype: int
        """
        return self._display_type

    @display_type.setter
    def display_type(self, display_type):
        """Sets the display_type of this GaugeWidget.

        Display as \"Raw Value\" or \"Percent\"  # noqa: E501

        :param display_type: The display_type of this GaugeWidget.  # noqa: E501
        :type: int
        """

        self._display_type = display_type

    @property
    def peak_time_range(self):
        """Gets the peak_time_range of this GaugeWidget.  # noqa: E501

        The time range over which the peak value is determined  # noqa: E501

        :return: The peak_time_range of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._peak_time_range

    @peak_time_range.setter
    def peak_time_range(self, peak_time_range):
        """Sets the peak_time_range of this GaugeWidget.

        The time range over which the peak value is determined  # noqa: E501

        :param peak_time_range: The peak_time_range of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._peak_time_range = peak_time_range

    @property
    def legend(self):
        """Gets the legend of this GaugeWidget.  # noqa: E501

        The legend for the widget, displayed underneath the gauge  # noqa: E501

        :return: The legend of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._legend

    @legend.setter
    def legend(self, legend):
        """Sets the legend of this GaugeWidget.

        The legend for the widget, displayed underneath the gauge  # noqa: E501

        :param legend: The legend of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._legend = legend

    @property
    def max_value(self):
        """Gets the max_value of this GaugeWidget.  # noqa: E501

        The maximum value of the gauge widget, displayed on the right side of the gauge  # noqa: E501

        :return: The max_value of this GaugeWidget.  # noqa: E501
        :rtype: float
        """
        return self._max_value

    @max_value.setter
    def max_value(self, max_value):
        """Sets the max_value of this GaugeWidget.

        The maximum value of the gauge widget, displayed on the right side of the gauge  # noqa: E501

        :param max_value: The max_value of this GaugeWidget.  # noqa: E501
        :type: float
        """

        self._max_value = max_value

    @property
    def show_peak(self):
        """Gets the show_peak of this GaugeWidget.  # noqa: E501

        Whether or not the peak value is displayed on the gauge widget  # noqa: E501

        :return: The show_peak of this GaugeWidget.  # noqa: E501
        :rtype: bool
        """
        return self._show_peak

    @show_peak.setter
    def show_peak(self, show_peak):
        """Sets the show_peak of this GaugeWidget.

        Whether or not the peak value is displayed on the gauge widget  # noqa: E501

        :param show_peak: The show_peak of this GaugeWidget.  # noqa: E501
        :type: bool
        """

        self._show_peak = show_peak

    @property
    def data_point(self):
        """Gets the data_point of this GaugeWidget.  # noqa: E501

        The datapoint whose value is displayed in the gauge widget  # noqa: E501

        :return: The data_point of this GaugeWidget.  # noqa: E501
        :rtype: GaugeDataPoint
        """
        return self._data_point

    @data_point.setter
    def data_point(self, data_point):
        """Sets the data_point of this GaugeWidget.

        The datapoint whose value is displayed in the gauge widget  # noqa: E501

        :param data_point: The data_point of this GaugeWidget.  # noqa: E501
        :type: GaugeDataPoint
        """
        if data_point is None:
            raise ValueError("Invalid value for `data_point`, must not be `None`")  # noqa: E501

        self._data_point = data_point

    @property
    def display_unit(self):
        """Gets the display_unit of this GaugeWidget.  # noqa: E501

        The unit for the raw value  # noqa: E501

        :return: The display_unit of this GaugeWidget.  # noqa: E501
        :rtype: str
        """
        return self._display_unit

    @display_unit.setter
    def display_unit(self, display_unit):
        """Sets the display_unit of this GaugeWidget.

        The unit for the raw value  # noqa: E501

        :param display_unit: The display_unit of this GaugeWidget.  # noqa: E501
        :type: str
        """

        self._display_unit = display_unit

    @property
    def color_thresholds(self):
        """Gets the color_thresholds of this GaugeWidget.  # noqa: E501

        The threshold of Gauge color changes  # noqa: E501

        :return: The color_thresholds of this GaugeWidget.  # noqa: E501
        :rtype: list[ColorThreshold]
        """
        return self._color_thresholds

    @color_thresholds.setter
    def color_thresholds(self, color_thresholds):
        """Sets the color_thresholds of this GaugeWidget.

        The threshold of Gauge color changes  # noqa: E501

        :param color_thresholds: The color_thresholds of this GaugeWidget.  # noqa: E501
        :type: list[ColorThreshold]
        """

        self._color_thresholds = color_thresholds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GaugeWidget, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GaugeWidget):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
