# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ExcludeDuplicateIps(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'collectors': 'list[str]',
        'groups': 'list[str]',
        'type': 'int'
    }

    attribute_map = {
        'collectors': 'collectors',
        'groups': 'groups',
        'type': 'type'
    }

    def __init__(self, collectors=None, groups=None, type=None):  # noqa: E501
        """ExcludeDuplicateIps - a model defined in Swagger"""  # noqa: E501

        self._collectors = None
        self._groups = None
        self._type = None
        self.discriminator = None

        if collectors is not None:
            self.collectors = collectors
        if groups is not None:
            self.groups = groups
        if type is not None:
            self.type = type

    @property
    def collectors(self):
        """Gets the collectors of this ExcludeDuplicateIps.  # noqa: E501

        The collectors for which monitored devices should be used to identify and exclude duplicate IPs, if duplicate type is 4  # noqa: E501

        :return: The collectors of this ExcludeDuplicateIps.  # noqa: E501
        :rtype: list[str]
        """
        return self._collectors

    @collectors.setter
    def collectors(self, collectors):
        """Sets the collectors of this ExcludeDuplicateIps.

        The collectors for which monitored devices should be used to identify and exclude duplicate IPs, if duplicate type is 4  # noqa: E501

        :param collectors: The collectors of this ExcludeDuplicateIps.  # noqa: E501
        :type: list[str]
        """

        self._collectors = collectors

    @property
    def groups(self):
        """Gets the groups of this ExcludeDuplicateIps.  # noqa: E501

        The groups for which devices should be used to identify and exclude duplicate IPs, if duplicate type is 3  # noqa: E501

        :return: The groups of this ExcludeDuplicateIps.  # noqa: E501
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this ExcludeDuplicateIps.

        The groups for which devices should be used to identify and exclude duplicate IPs, if duplicate type is 3  # noqa: E501

        :param groups: The groups of this ExcludeDuplicateIps.  # noqa: E501
        :type: list[str]
        """

        self._groups = groups

    @property
    def type(self):
        """Gets the type of this ExcludeDuplicateIps.  # noqa: E501

        What types of duplicate IPs should be excluded. Options are 1 (matching any monitored devices), 2 (matching devices already discovered by this scan), 3 (matching devices in these groups), and 4 (matching devices assigned to these collectors)  # noqa: E501

        :return: The type of this ExcludeDuplicateIps.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ExcludeDuplicateIps.

        What types of duplicate IPs should be excluded. Options are 1 (matching any monitored devices), 2 (matching devices already discovered by this scan), 3 (matching devices in these groups), and 4 (matching devices assigned to these collectors)  # noqa: E501

        :param type: The type of this ExcludeDuplicateIps.  # noqa: E501
        :type: int
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExcludeDuplicateIps, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExcludeDuplicateIps):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
