# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.color_threshold import ColorThreshold  # noqa: F401,E501
from logicmonitor_sdk.models.sla_metric import SlaMetric  # noqa: F401,E501
from logicmonitor_sdk.models.widget import Widget  # noqa: F401,E501


class DeviceSLAWidget(Widget):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'last_updated_by': 'str',
        'user_permission': 'str',
        'dashboard_id': 'int',
        'name': 'str',
        'description': 'str',
        'last_updated_on': 'int',
        'theme': 'str',
        'interval': 'int',
        'id': 'int',
        'type': 'str',
        'timescale': 'str',
        'days_in_week': 'str',
        'display_type': 'int',
        'top_x': 'int',
        'timezone': 'str',
        'bottom_label': 'str',
        'period_in_one_day': 'str',
        'metrics': 'list[SlaMetric]',
        'unmonitored_time_type': 'int',
        'color_thresholds': 'list[ColorThreshold]'
    }

    attribute_map = {
        'last_updated_by': 'lastUpdatedBy',
        'user_permission': 'userPermission',
        'dashboard_id': 'dashboardId',
        'name': 'name',
        'description': 'description',
        'last_updated_on': 'lastUpdatedOn',
        'theme': 'theme',
        'interval': 'interval',
        'id': 'id',
        'type': 'type',
        'timescale': 'timescale',
        'days_in_week': 'daysInWeek',
        'display_type': 'displayType',
        'top_x': 'topX',
        'timezone': 'timezone',
        'bottom_label': 'bottomLabel',
        'period_in_one_day': 'periodInOneDay',
        'metrics': 'metrics',
        'unmonitored_time_type': 'unmonitoredTimeType',
        'color_thresholds': 'colorThresholds'
    }

    def __init__(self, last_updated_by=None, user_permission=None, dashboard_id=None, name=None, description=None, last_updated_on=None, theme=None, interval=None, id=None, type=None, timescale=None, days_in_week=None, display_type=None, top_x=None, timezone=None, bottom_label=None, period_in_one_day=None, metrics=None, unmonitored_time_type=None, color_thresholds=None):  # noqa: E501
        """DeviceSLAWidget - a model defined in Swagger"""  # noqa: E501

        self._last_updated_by = None
        self._user_permission = None
        self._dashboard_id = None
        self._name = None
        self._description = None
        self._last_updated_on = None
        self._theme = None
        self._interval = None
        self._id = None
        self._type = None
        self._timescale = None
        self._days_in_week = None
        self._display_type = None
        self._top_x = None
        self._timezone = None
        self._bottom_label = None
        self._period_in_one_day = None
        self._metrics = None
        self._unmonitored_time_type = None
        self._color_thresholds = None
        self.discriminator = None

        if last_updated_by is not None:
            self.last_updated_by = last_updated_by
        if user_permission is not None:
            self.user_permission = user_permission
        self.dashboard_id = dashboard_id
        self.name = name
        if description is not None:
            self.description = description
        if last_updated_on is not None:
            self.last_updated_on = last_updated_on
        if theme is not None:
            self.theme = theme
        if interval is not None:
            self.interval = interval
        if id is not None:
            self.id = id
        self.type = type
        if timescale is not None:
            self.timescale = timescale
        if days_in_week is not None:
            self.days_in_week = days_in_week
        if display_type is not None:
            self.display_type = display_type
        if top_x is not None:
            self.top_x = top_x
        if timezone is not None:
            self.timezone = timezone
        if bottom_label is not None:
            self.bottom_label = bottom_label
        if period_in_one_day is not None:
            self.period_in_one_day = period_in_one_day
        self.metrics = metrics
        if unmonitored_time_type is not None:
            self.unmonitored_time_type = unmonitored_time_type
        if color_thresholds is not None:
            self.color_thresholds = color_thresholds

    @property
    def last_updated_by(self):
        """Gets the last_updated_by of this DeviceSLAWidget.  # noqa: E501

        The user that last updated the widget  # noqa: E501

        :return: The last_updated_by of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """Sets the last_updated_by of this DeviceSLAWidget.

        The user that last updated the widget  # noqa: E501

        :param last_updated_by: The last_updated_by of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._last_updated_by = last_updated_by

    @property
    def user_permission(self):
        """Gets the user_permission of this DeviceSLAWidget.  # noqa: E501

        The permission level of the user who last modified the widget  # noqa: E501

        :return: The user_permission of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this DeviceSLAWidget.

        The permission level of the user who last modified the widget  # noqa: E501

        :param user_permission: The user_permission of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def dashboard_id(self):
        """Gets the dashboard_id of this DeviceSLAWidget.  # noqa: E501

        The id of the dashboard the widget belongs to  # noqa: E501

        :return: The dashboard_id of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._dashboard_id

    @dashboard_id.setter
    def dashboard_id(self, dashboard_id):
        """Sets the dashboard_id of this DeviceSLAWidget.

        The id of the dashboard the widget belongs to  # noqa: E501

        :param dashboard_id: The dashboard_id of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """
        if dashboard_id is None:
            raise ValueError("Invalid value for `dashboard_id`, must not be `None`")  # noqa: E501

        self._dashboard_id = dashboard_id

    @property
    def name(self):
        """Gets the name of this DeviceSLAWidget.  # noqa: E501

        The name of the widget  # noqa: E501

        :return: The name of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeviceSLAWidget.

        The name of the widget  # noqa: E501

        :param name: The name of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this DeviceSLAWidget.  # noqa: E501

        The description of the widget  # noqa: E501

        :return: The description of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DeviceSLAWidget.

        The description of the widget  # noqa: E501

        :param description: The description of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def last_updated_on(self):
        """Gets the last_updated_on of this DeviceSLAWidget.  # noqa: E501

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :return: The last_updated_on of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._last_updated_on

    @last_updated_on.setter
    def last_updated_on(self, last_updated_on):
        """Sets the last_updated_on of this DeviceSLAWidget.

        The time that corresponds to when the widget was last updated, in epoch format  # noqa: E501

        :param last_updated_on: The last_updated_on of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._last_updated_on = last_updated_on

    @property
    def theme(self):
        """Gets the theme of this DeviceSLAWidget.  # noqa: E501

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :return: The theme of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this DeviceSLAWidget.

        The color scheme of the widget. Options are: borderPurple | borderGray | borderBlue | solidPurple | solidGray | solidBlue | simplePurple | simpleBlue | simpleGray | newBorderGray | newBorderBlue | newBorderDarkBlue | newSolidGray | newSolidBlue | newSolidDarkBlue | newSimpleGray | newSimpleBlue |newSimpleDarkBlue  # noqa: E501

        :param theme: The theme of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._theme = theme

    @property
    def interval(self):
        """Gets the interval of this DeviceSLAWidget.  # noqa: E501

        The refresh interval of the widget, in minutes  # noqa: E501

        :return: The interval of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this DeviceSLAWidget.

        The refresh interval of the widget, in minutes  # noqa: E501

        :param interval: The interval of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._interval = interval

    @property
    def id(self):
        """Gets the id of this DeviceSLAWidget.  # noqa: E501

        The Id of the widget  # noqa: E501

        :return: The id of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceSLAWidget.

        The Id of the widget  # noqa: E501

        :param id: The id of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this DeviceSLAWidget.  # noqa: E501

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :return: The type of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DeviceSLAWidget.

        alert | batchjob | flash | gmap | ngraph | ograph | cgraph | sgraph | netflowgraph | groupNetflowGraph | netflow | groupNetflow | html | bigNumber | gauge | pieChart | table | dynamicTable | deviceSLA | text | statsd | deviceStatus | serviceAlert | noc | websiteOverview | websiteOverallStatus | websiteIndividualStatus | websiteSLA  # noqa: E501

        :param type: The type of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def timescale(self):
        """Gets the timescale of this DeviceSLAWidget.  # noqa: E501

        The default timescale of the widget  # noqa: E501

        :return: The timescale of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._timescale

    @timescale.setter
    def timescale(self, timescale):
        """Sets the timescale of this DeviceSLAWidget.

        The default timescale of the widget  # noqa: E501

        :param timescale: The timescale of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._timescale = timescale

    @property
    def days_in_week(self):
        """Gets the days_in_week of this DeviceSLAWidget.  # noqa: E501

        The days that SLA should be computed for, separated by commas. 1=Sunday, 2=Monday, 3=Tuesday, 4=Wednesday, 5=Thursday, 6=Friday, 7=Saturday.  # noqa: E501

        :return: The days_in_week of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._days_in_week

    @days_in_week.setter
    def days_in_week(self, days_in_week):
        """Sets the days_in_week of this DeviceSLAWidget.

        The days that SLA should be computed for, separated by commas. 1=Sunday, 2=Monday, 3=Tuesday, 4=Wednesday, 5=Thursday, 6=Friday, 7=Saturday.  # noqa: E501

        :param days_in_week: The days_in_week of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._days_in_week = days_in_week

    @property
    def display_type(self):
        """Gets the display_type of this DeviceSLAWidget.  # noqa: E501

        Whether or not selected metrics should be combined into one number (displayType:0) or should be displayed individually, up to four metrics (displayType:1)  # noqa: E501

        :return: The display_type of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._display_type

    @display_type.setter
    def display_type(self, display_type):
        """Sets the display_type of this DeviceSLAWidget.

        Whether or not selected metrics should be combined into one number (displayType:0) or should be displayed individually, up to four metrics (displayType:1)  # noqa: E501

        :param display_type: The display_type of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._display_type = display_type

    @property
    def top_x(self):
        """Gets the top_x of this DeviceSLAWidget.  # noqa: E501

        Top list size for each point, 1 means aggregate  # noqa: E501

        :return: The top_x of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._top_x

    @top_x.setter
    def top_x(self, top_x):
        """Sets the top_x of this DeviceSLAWidget.

        Top list size for each point, 1 means aggregate  # noqa: E501

        :param top_x: The top_x of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._top_x = top_x

    @property
    def timezone(self):
        """Gets the timezone of this DeviceSLAWidget.  # noqa: E501

        The specific timezone for the widget  # noqa: E501

        :return: The timezone of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this DeviceSLAWidget.

        The specific timezone for the widget  # noqa: E501

        :param timezone: The timezone of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._timezone = timezone

    @property
    def bottom_label(self):
        """Gets the bottom_label of this DeviceSLAWidget.  # noqa: E501

        The services that should be used to compute the SLA, where each service should include serviceGroup and service  # noqa: E501

        :return: The bottom_label of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._bottom_label

    @bottom_label.setter
    def bottom_label(self, bottom_label):
        """Sets the bottom_label of this DeviceSLAWidget.

        The services that should be used to compute the SLA, where each service should include serviceGroup and service  # noqa: E501

        :param bottom_label: The bottom_label of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._bottom_label = bottom_label

    @property
    def period_in_one_day(self):
        """Gets the period_in_one_day of this DeviceSLAWidget.  # noqa: E501

        The period during the selected days that the SLA should be computed for. * = all day, or a time range can be specified in the format of \"hh:mm TO hh:mm\", e.g. \"01:15 TO 17:15\"  # noqa: E501

        :return: The period_in_one_day of this DeviceSLAWidget.  # noqa: E501
        :rtype: str
        """
        return self._period_in_one_day

    @period_in_one_day.setter
    def period_in_one_day(self, period_in_one_day):
        """Sets the period_in_one_day of this DeviceSLAWidget.

        The period during the selected days that the SLA should be computed for. * = all day, or a time range can be specified in the format of \"hh:mm TO hh:mm\", e.g. \"01:15 TO 17:15\"  # noqa: E501

        :param period_in_one_day: The period_in_one_day of this DeviceSLAWidget.  # noqa: E501
        :type: str
        """

        self._period_in_one_day = period_in_one_day

    @property
    def metrics(self):
        """Gets the metrics of this DeviceSLAWidget.  # noqa: E501

        The metrics (datapoints) that should be used to compute the SLA, where each service should include groupName (can be *), deviceName (can be *), dataSourceId or dataSourceFullName, instances (can be *), metric (datapoint), threshold, and exclusionSDTType (empty string means SDT periods will not be excluded, \"group\" means SDT periods at the device group level will be excluded, and \"device\" means SDT periods at the device level will be excluded)  # noqa: E501

        :return: The metrics of this DeviceSLAWidget.  # noqa: E501
        :rtype: list[SlaMetric]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this DeviceSLAWidget.

        The metrics (datapoints) that should be used to compute the SLA, where each service should include groupName (can be *), deviceName (can be *), dataSourceId or dataSourceFullName, instances (can be *), metric (datapoint), threshold, and exclusionSDTType (empty string means SDT periods will not be excluded, \"group\" means SDT periods at the device group level will be excluded, and \"device\" means SDT periods at the device level will be excluded)  # noqa: E501

        :param metrics: The metrics of this DeviceSLAWidget.  # noqa: E501
        :type: list[SlaMetric]
        """
        if metrics is None:
            raise ValueError("Invalid value for `metrics`, must not be `None`")  # noqa: E501

        self._metrics = metrics

    @property
    def unmonitored_time_type(self):
        """Gets the unmonitored_time_type of this DeviceSLAWidget.  # noqa: E501

        How no data should be treated: 0 = unmonitored time will be ignored & subtracted from the total possible time, 1 = unmonitored time will be subtracted from uptime and counted as a violation, 2 = unmonitored time will be added to uptime and counted as available  # noqa: E501

        :return: The unmonitored_time_type of this DeviceSLAWidget.  # noqa: E501
        :rtype: int
        """
        return self._unmonitored_time_type

    @unmonitored_time_type.setter
    def unmonitored_time_type(self, unmonitored_time_type):
        """Sets the unmonitored_time_type of this DeviceSLAWidget.

        How no data should be treated: 0 = unmonitored time will be ignored & subtracted from the total possible time, 1 = unmonitored time will be subtracted from uptime and counted as a violation, 2 = unmonitored time will be added to uptime and counted as available  # noqa: E501

        :param unmonitored_time_type: The unmonitored_time_type of this DeviceSLAWidget.  # noqa: E501
        :type: int
        """

        self._unmonitored_time_type = unmonitored_time_type

    @property
    def color_thresholds(self):
        """Gets the color_thresholds of this DeviceSLAWidget.  # noqa: E501

        The threshold of color changes  # noqa: E501

        :return: The color_thresholds of this DeviceSLAWidget.  # noqa: E501
        :rtype: list[ColorThreshold]
        """
        return self._color_thresholds

    @color_thresholds.setter
    def color_thresholds(self, color_thresholds):
        """Sets the color_thresholds of this DeviceSLAWidget.

        The threshold of color changes  # noqa: E501

        :param color_thresholds: The color_thresholds of this DeviceSLAWidget.  # noqa: E501
        :type: list[ColorThreshold]
        """

        self._color_thresholds = color_thresholds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceSLAWidget, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceSLAWidget):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
