# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.noc_item_base import NOCItemBase  # noqa: F401,E501


class DeviceNOCItem(NOCItemBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'data_point_name': 'str',
        'instance_name': 'str',
        'name': 'str',
        'data_source_display_name': 'str',
        'group_by': 'str',
        'device_group_full_path': 'str',
        'device_display_name': 'str'
    }

    attribute_map = {
        'type': 'type',
        'data_point_name': 'dataPointName',
        'instance_name': 'instanceName',
        'name': 'name',
        'data_source_display_name': 'dataSourceDisplayName',
        'group_by': 'groupBy',
        'device_group_full_path': 'deviceGroupFullPath',
        'device_display_name': 'deviceDisplayName'
    }

    def __init__(self, type=None, data_point_name=None, instance_name=None, name=None, data_source_display_name=None, group_by=None, device_group_full_path=None, device_display_name=None):  # noqa: E501
        """DeviceNOCItem - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._data_point_name = None
        self._instance_name = None
        self._name = None
        self._data_source_display_name = None
        self._group_by = None
        self._device_group_full_path = None
        self._device_display_name = None
        self.discriminator = None

        self.type = type
        self.data_point_name = data_point_name
        self.instance_name = instance_name
        self.name = name
        self.data_source_display_name = data_source_display_name
        if group_by is not None:
            self.group_by = group_by
        self.device_group_full_path = device_group_full_path
        self.device_display_name = device_display_name

    @property
    def type(self):
        """Gets the type of this DeviceNOCItem.  # noqa: E501


        :return: The type of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DeviceNOCItem.


        :param type: The type of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def data_point_name(self):
        """Gets the data_point_name of this DeviceNOCItem.  # noqa: E501


        :return: The data_point_name of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._data_point_name

    @data_point_name.setter
    def data_point_name(self, data_point_name):
        """Sets the data_point_name of this DeviceNOCItem.


        :param data_point_name: The data_point_name of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if data_point_name is None:
            raise ValueError("Invalid value for `data_point_name`, must not be `None`")  # noqa: E501

        self._data_point_name = data_point_name

    @property
    def instance_name(self):
        """Gets the instance_name of this DeviceNOCItem.  # noqa: E501


        :return: The instance_name of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """Sets the instance_name of this DeviceNOCItem.


        :param instance_name: The instance_name of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if instance_name is None:
            raise ValueError("Invalid value for `instance_name`, must not be `None`")  # noqa: E501

        self._instance_name = instance_name

    @property
    def name(self):
        """Gets the name of this DeviceNOCItem.  # noqa: E501


        :return: The name of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeviceNOCItem.


        :param name: The name of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def data_source_display_name(self):
        """Gets the data_source_display_name of this DeviceNOCItem.  # noqa: E501


        :return: The data_source_display_name of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._data_source_display_name

    @data_source_display_name.setter
    def data_source_display_name(self, data_source_display_name):
        """Sets the data_source_display_name of this DeviceNOCItem.


        :param data_source_display_name: The data_source_display_name of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if data_source_display_name is None:
            raise ValueError("Invalid value for `data_source_display_name`, must not be `None`")  # noqa: E501

        self._data_source_display_name = data_source_display_name

    @property
    def group_by(self):
        """Gets the group_by of this DeviceNOCItem.  # noqa: E501


        :return: The group_by of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """Sets the group_by of this DeviceNOCItem.


        :param group_by: The group_by of this DeviceNOCItem.  # noqa: E501
        :type: str
        """

        self._group_by = group_by

    @property
    def device_group_full_path(self):
        """Gets the device_group_full_path of this DeviceNOCItem.  # noqa: E501


        :return: The device_group_full_path of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._device_group_full_path

    @device_group_full_path.setter
    def device_group_full_path(self, device_group_full_path):
        """Sets the device_group_full_path of this DeviceNOCItem.


        :param device_group_full_path: The device_group_full_path of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if device_group_full_path is None:
            raise ValueError("Invalid value for `device_group_full_path`, must not be `None`")  # noqa: E501

        self._device_group_full_path = device_group_full_path

    @property
    def device_display_name(self):
        """Gets the device_display_name of this DeviceNOCItem.  # noqa: E501


        :return: The device_display_name of this DeviceNOCItem.  # noqa: E501
        :rtype: str
        """
        return self._device_display_name

    @device_display_name.setter
    def device_display_name(self, device_display_name):
        """Sets the device_display_name of this DeviceNOCItem.


        :param device_display_name: The device_display_name of this DeviceNOCItem.  # noqa: E501
        :type: str
        """
        if device_display_name is None:
            raise ValueError("Invalid value for `device_display_name`, must not be `None`")  # noqa: E501

        self._device_display_name = device_display_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceNOCItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceNOCItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
