# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.raw_data_values import RawDataValues  # noqa: F401,E501


class DeviceDataSourceData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'instances': 'dict(str, RawDataValues)',
        'data_points': 'list[str]',
        'next_page_params': 'str',
        'data_source_name': 'str'
    }

    attribute_map = {
        'instances': 'instances',
        'data_points': 'dataPoints',
        'next_page_params': 'nextPageParams',
        'data_source_name': 'dataSourceName'
    }

    def __init__(self, instances=None, data_points=None, next_page_params=None, data_source_name=None):  # noqa: E501
        """DeviceDataSourceData - a model defined in Swagger"""  # noqa: E501

        self._instances = None
        self._data_points = None
        self._next_page_params = None
        self._data_source_name = None
        self.discriminator = None

        if instances is not None:
            self.instances = instances
        if data_points is not None:
            self.data_points = data_points
        if next_page_params is not None:
            self.next_page_params = next_page_params
        if data_source_name is not None:
            self.data_source_name = data_source_name

    @property
    def instances(self):
        """Gets the instances of this DeviceDataSourceData.  # noqa: E501


        :return: The instances of this DeviceDataSourceData.  # noqa: E501
        :rtype: dict(str, RawDataValues)
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this DeviceDataSourceData.


        :param instances: The instances of this DeviceDataSourceData.  # noqa: E501
        :type: dict(str, RawDataValues)
        """

        self._instances = instances

    @property
    def data_points(self):
        """Gets the data_points of this DeviceDataSourceData.  # noqa: E501


        :return: The data_points of this DeviceDataSourceData.  # noqa: E501
        :rtype: list[str]
        """
        return self._data_points

    @data_points.setter
    def data_points(self, data_points):
        """Sets the data_points of this DeviceDataSourceData.


        :param data_points: The data_points of this DeviceDataSourceData.  # noqa: E501
        :type: list[str]
        """

        self._data_points = data_points

    @property
    def next_page_params(self):
        """Gets the next_page_params of this DeviceDataSourceData.  # noqa: E501


        :return: The next_page_params of this DeviceDataSourceData.  # noqa: E501
        :rtype: str
        """
        return self._next_page_params

    @next_page_params.setter
    def next_page_params(self, next_page_params):
        """Sets the next_page_params of this DeviceDataSourceData.


        :param next_page_params: The next_page_params of this DeviceDataSourceData.  # noqa: E501
        :type: str
        """

        self._next_page_params = next_page_params

    @property
    def data_source_name(self):
        """Gets the data_source_name of this DeviceDataSourceData.  # noqa: E501


        :return: The data_source_name of this DeviceDataSourceData.  # noqa: E501
        :rtype: str
        """
        return self._data_source_name

    @data_source_name.setter
    def data_source_name(self, data_source_name):
        """Sets the data_source_name of this DeviceDataSourceData.


        :param data_source_name: The data_source_name of this DeviceDataSourceData.  # noqa: E501
        :type: str
        """

        self._data_source_name = data_source_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceDataSourceData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceDataSourceData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
