# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DeviceClusterAlertConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'count_by': 'str',
        'data_point_name': 'str',
        'data_source_id': 'int',
        'data_point_id': 'int',
        'min_alert_level': 'int',
        'data_source_display_name': 'str',
        'disable_alerting': 'bool',
        'id': 'int',
        'suppress_ind_alert': 'object',
        'threshold_type': 'str',
        'data_point_description': 'str',
        'alert_expr': 'str'
    }

    attribute_map = {
        'count_by': 'countBy',
        'data_point_name': 'dataPointName',
        'data_source_id': 'dataSourceId',
        'data_point_id': 'dataPointId',
        'min_alert_level': 'minAlertLevel',
        'data_source_display_name': 'dataSourceDisplayName',
        'disable_alerting': 'disableAlerting',
        'id': 'id',
        'suppress_ind_alert': 'suppressIndAlert',
        'threshold_type': 'thresholdType',
        'data_point_description': 'dataPointDescription',
        'alert_expr': 'alertExpr'
    }

    def __init__(self, count_by=None, data_point_name=None, data_source_id=None, data_point_id=None, min_alert_level=None, data_source_display_name=None, disable_alerting=None, id=None, suppress_ind_alert=None, threshold_type=None, data_point_description=None, alert_expr=None):  # noqa: E501
        """DeviceClusterAlertConfig - a model defined in Swagger"""  # noqa: E501

        self._count_by = None
        self._data_point_name = None
        self._data_source_id = None
        self._data_point_id = None
        self._min_alert_level = None
        self._data_source_display_name = None
        self._disable_alerting = None
        self._id = None
        self._suppress_ind_alert = None
        self._threshold_type = None
        self._data_point_description = None
        self._alert_expr = None
        self.discriminator = None

        if count_by is not None:
            self.count_by = count_by
        if data_point_name is not None:
            self.data_point_name = data_point_name
        if data_source_id is not None:
            self.data_source_id = data_source_id
        if data_point_id is not None:
            self.data_point_id = data_point_id
        if min_alert_level is not None:
            self.min_alert_level = min_alert_level
        if data_source_display_name is not None:
            self.data_source_display_name = data_source_display_name
        if disable_alerting is not None:
            self.disable_alerting = disable_alerting
        if id is not None:
            self.id = id
        if suppress_ind_alert is not None:
            self.suppress_ind_alert = suppress_ind_alert
        if threshold_type is not None:
            self.threshold_type = threshold_type
        if data_point_description is not None:
            self.data_point_description = data_point_description
        if alert_expr is not None:
            self.alert_expr = alert_expr

    @property
    def count_by(self):
        """Gets the count_by of this DeviceClusterAlertConfig.  # noqa: E501

        host | instance - Whether the cluster alert is based on an alert count across devices or instances  # noqa: E501

        :return: The count_by of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._count_by

    @count_by.setter
    def count_by(self, count_by):
        """Sets the count_by of this DeviceClusterAlertConfig.

        host | instance - Whether the cluster alert is based on an alert count across devices or instances  # noqa: E501

        :param count_by: The count_by of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._count_by = count_by

    @property
    def data_point_name(self):
        """Gets the data_point_name of this DeviceClusterAlertConfig.  # noqa: E501

        The name of the dataPoint you want to base the cluster alert on  # noqa: E501

        :return: The data_point_name of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._data_point_name

    @data_point_name.setter
    def data_point_name(self, data_point_name):
        """Sets the data_point_name of this DeviceClusterAlertConfig.

        The name of the dataPoint you want to base the cluster alert on  # noqa: E501

        :param data_point_name: The data_point_name of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._data_point_name = data_point_name

    @property
    def data_source_id(self):
        """Gets the data_source_id of this DeviceClusterAlertConfig.  # noqa: E501

        The id of the dataSource you want to base the cluster alert on  # noqa: E501

        :return: The data_source_id of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: int
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this DeviceClusterAlertConfig.

        The id of the dataSource you want to base the cluster alert on  # noqa: E501

        :param data_source_id: The data_source_id of this DeviceClusterAlertConfig.  # noqa: E501
        :type: int
        """

        self._data_source_id = data_source_id

    @property
    def data_point_id(self):
        """Gets the data_point_id of this DeviceClusterAlertConfig.  # noqa: E501

        The id of the dataPoint you want to base the cluster alert on  # noqa: E501

        :return: The data_point_id of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: int
        """
        return self._data_point_id

    @data_point_id.setter
    def data_point_id(self, data_point_id):
        """Sets the data_point_id of this DeviceClusterAlertConfig.

        The id of the dataPoint you want to base the cluster alert on  # noqa: E501

        :param data_point_id: The data_point_id of this DeviceClusterAlertConfig.  # noqa: E501
        :type: int
        """

        self._data_point_id = data_point_id

    @property
    def min_alert_level(self):
        """Gets the min_alert_level of this DeviceClusterAlertConfig.  # noqa: E501

        The alert level that must be present for the devices or instances to trigger the cluster alert. Acceptable values are: 2, 3, 4  # noqa: E501

        :return: The min_alert_level of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: int
        """
        return self._min_alert_level

    @min_alert_level.setter
    def min_alert_level(self, min_alert_level):
        """Sets the min_alert_level of this DeviceClusterAlertConfig.

        The alert level that must be present for the devices or instances to trigger the cluster alert. Acceptable values are: 2, 3, 4  # noqa: E501

        :param min_alert_level: The min_alert_level of this DeviceClusterAlertConfig.  # noqa: E501
        :type: int
        """

        self._min_alert_level = min_alert_level

    @property
    def data_source_display_name(self):
        """Gets the data_source_display_name of this DeviceClusterAlertConfig.  # noqa: E501

        The display name of the dataSource you want to base the cluster alert on  # noqa: E501

        :return: The data_source_display_name of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._data_source_display_name

    @data_source_display_name.setter
    def data_source_display_name(self, data_source_display_name):
        """Sets the data_source_display_name of this DeviceClusterAlertConfig.

        The display name of the dataSource you want to base the cluster alert on  # noqa: E501

        :param data_source_display_name: The data_source_display_name of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._data_source_display_name = data_source_display_name

    @property
    def disable_alerting(self):
        """Gets the disable_alerting of this DeviceClusterAlertConfig.  # noqa: E501

        Whether or not alerting will be disabled  # noqa: E501

        :return: The disable_alerting of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: bool
        """
        return self._disable_alerting

    @disable_alerting.setter
    def disable_alerting(self, disable_alerting):
        """Sets the disable_alerting of this DeviceClusterAlertConfig.

        Whether or not alerting will be disabled  # noqa: E501

        :param disable_alerting: The disable_alerting of this DeviceClusterAlertConfig.  # noqa: E501
        :type: bool
        """

        self._disable_alerting = disable_alerting

    @property
    def id(self):
        """Gets the id of this DeviceClusterAlertConfig.  # noqa: E501

        The id of the cluster alert configuration  # noqa: E501

        :return: The id of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DeviceClusterAlertConfig.

        The id of the cluster alert configuration  # noqa: E501

        :param id: The id of this DeviceClusterAlertConfig.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def suppress_ind_alert(self):
        """Gets the suppress_ind_alert of this DeviceClusterAlertConfig.  # noqa: E501

        Whether or not alerting will be suppressed for individual alerts, the default value is true  # noqa: E501

        :return: The suppress_ind_alert of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: object
        """
        return self._suppress_ind_alert

    @suppress_ind_alert.setter
    def suppress_ind_alert(self, suppress_ind_alert):
        """Sets the suppress_ind_alert of this DeviceClusterAlertConfig.

        Whether or not alerting will be suppressed for individual alerts, the default value is true  # noqa: E501

        :param suppress_ind_alert: The suppress_ind_alert of this DeviceClusterAlertConfig.  # noqa: E501
        :type: object
        """

        self._suppress_ind_alert = suppress_ind_alert

    @property
    def threshold_type(self):
        """Gets the threshold_type of this DeviceClusterAlertConfig.  # noqa: E501

        whether the alert expression should be evaluated as a total number of devices or instances (absolute) or as a percentage of devices or instances (percentage). Acceptable values are: absolute, percentage  # noqa: E501

        :return: The threshold_type of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._threshold_type

    @threshold_type.setter
    def threshold_type(self, threshold_type):
        """Sets the threshold_type of this DeviceClusterAlertConfig.

        whether the alert expression should be evaluated as a total number of devices or instances (absolute) or as a percentage of devices or instances (percentage). Acceptable values are: absolute, percentage  # noqa: E501

        :param threshold_type: The threshold_type of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._threshold_type = threshold_type

    @property
    def data_point_description(self):
        """Gets the data_point_description of this DeviceClusterAlertConfig.  # noqa: E501

        The description of the dataPoint you want to base the cluster alert on  # noqa: E501

        :return: The data_point_description of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._data_point_description

    @data_point_description.setter
    def data_point_description(self, data_point_description):
        """Sets the data_point_description of this DeviceClusterAlertConfig.

        The description of the dataPoint you want to base the cluster alert on  # noqa: E501

        :param data_point_description: The data_point_description of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._data_point_description = data_point_description

    @property
    def alert_expr(self):
        """Gets the alert_expr of this DeviceClusterAlertConfig.  # noqa: E501

        The expression that indicates the number of objects (devices or instances) that need to be in alert to trigger the cluster alert. E.g. > 5  # noqa: E501

        :return: The alert_expr of this DeviceClusterAlertConfig.  # noqa: E501
        :rtype: str
        """
        return self._alert_expr

    @alert_expr.setter
    def alert_expr(self, alert_expr):
        """Sets the alert_expr of this DeviceClusterAlertConfig.

        The expression that indicates the number of objects (devices or instances) that need to be in alert to trigger the cluster alert. E.g. > 5  # noqa: E501

        :param alert_expr: The alert_expr of this DeviceClusterAlertConfig.  # noqa: E501
        :type: str
        """

        self._alert_expr = alert_expr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DeviceClusterAlertConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeviceClusterAlertConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
