# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DaysUntilAlert(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'severity': 'str',
        'forecast_day': 'int',
        'forecast_period_in_days': 'int',
        'is_waiting_forecast_results': 'bool'
    }

    attribute_map = {
        'severity': 'severity',
        'forecast_day': 'forecastDay',
        'forecast_period_in_days': 'forecastPeriodInDays',
        'is_waiting_forecast_results': 'isWaitingForecastResults'
    }

    def __init__(self, severity=None, forecast_day=None, forecast_period_in_days=None, is_waiting_forecast_results=None):  # noqa: E501
        """DaysUntilAlert - a model defined in Swagger"""  # noqa: E501

        self._severity = None
        self._forecast_day = None
        self._forecast_period_in_days = None
        self._is_waiting_forecast_results = None
        self.discriminator = None

        if severity is not None:
            self.severity = severity
        if forecast_day is not None:
            self.forecast_day = forecast_day
        if forecast_period_in_days is not None:
            self.forecast_period_in_days = forecast_period_in_days
        if is_waiting_forecast_results is not None:
            self.is_waiting_forecast_results = is_waiting_forecast_results

    @property
    def severity(self):
        """Gets the severity of this DaysUntilAlert.  # noqa: E501


        :return: The severity of this DaysUntilAlert.  # noqa: E501
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this DaysUntilAlert.


        :param severity: The severity of this DaysUntilAlert.  # noqa: E501
        :type: str
        """

        self._severity = severity

    @property
    def forecast_day(self):
        """Gets the forecast_day of this DaysUntilAlert.  # noqa: E501


        :return: The forecast_day of this DaysUntilAlert.  # noqa: E501
        :rtype: int
        """
        return self._forecast_day

    @forecast_day.setter
    def forecast_day(self, forecast_day):
        """Sets the forecast_day of this DaysUntilAlert.


        :param forecast_day: The forecast_day of this DaysUntilAlert.  # noqa: E501
        :type: int
        """

        self._forecast_day = forecast_day

    @property
    def forecast_period_in_days(self):
        """Gets the forecast_period_in_days of this DaysUntilAlert.  # noqa: E501


        :return: The forecast_period_in_days of this DaysUntilAlert.  # noqa: E501
        :rtype: int
        """
        return self._forecast_period_in_days

    @forecast_period_in_days.setter
    def forecast_period_in_days(self, forecast_period_in_days):
        """Sets the forecast_period_in_days of this DaysUntilAlert.


        :param forecast_period_in_days: The forecast_period_in_days of this DaysUntilAlert.  # noqa: E501
        :type: int
        """

        self._forecast_period_in_days = forecast_period_in_days

    @property
    def is_waiting_forecast_results(self):
        """Gets the is_waiting_forecast_results of this DaysUntilAlert.  # noqa: E501


        :return: The is_waiting_forecast_results of this DaysUntilAlert.  # noqa: E501
        :rtype: bool
        """
        return self._is_waiting_forecast_results

    @is_waiting_forecast_results.setter
    def is_waiting_forecast_results(self, is_waiting_forecast_results):
        """Sets the is_waiting_forecast_results of this DaysUntilAlert.


        :param is_waiting_forecast_results: The is_waiting_forecast_results of this DaysUntilAlert.  # noqa: E501
        :type: bool
        """

        self._is_waiting_forecast_results = is_waiting_forecast_results

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DaysUntilAlert, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DaysUntilAlert):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
