# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.dashboard_data import DashboardData  # noqa: F401,E501
from logicmonitor_sdk.models.widget_token import WidgetToken  # noqa: F401,E501


class DashboardGroup(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'template': 'object',
        'full_path': 'str',
        'user_permission': 'str',
        'widget_tokens': 'list[WidgetToken]',
        'name': 'str',
        'num_of_direct_sub_groups': 'int',
        'num_of_dashboards': 'int',
        'description': 'str',
        'id': 'int',
        'dashboards': 'list[DashboardData]',
        'parent_id': 'int',
        'num_of_direct_dashboards': 'int'
    }

    attribute_map = {
        'template': 'template',
        'full_path': 'fullPath',
        'user_permission': 'userPermission',
        'widget_tokens': 'widgetTokens',
        'name': 'name',
        'num_of_direct_sub_groups': 'numOfDirectSubGroups',
        'num_of_dashboards': 'numOfDashboards',
        'description': 'description',
        'id': 'id',
        'dashboards': 'dashboards',
        'parent_id': 'parentId',
        'num_of_direct_dashboards': 'numOfDirectDashboards'
    }

    def __init__(self, template=None, full_path=None, user_permission=None, widget_tokens=None, name=None, num_of_direct_sub_groups=None, num_of_dashboards=None, description=None, id=None, dashboards=None, parent_id=None, num_of_direct_dashboards=None):  # noqa: E501
        """DashboardGroup - a model defined in Swagger"""  # noqa: E501

        self._template = None
        self._full_path = None
        self._user_permission = None
        self._widget_tokens = None
        self._name = None
        self._num_of_direct_sub_groups = None
        self._num_of_dashboards = None
        self._description = None
        self._id = None
        self._dashboards = None
        self._parent_id = None
        self._num_of_direct_dashboards = None
        self.discriminator = None

        if template is not None:
            self.template = template
        if full_path is not None:
            self.full_path = full_path
        if user_permission is not None:
            self.user_permission = user_permission
        if widget_tokens is not None:
            self.widget_tokens = widget_tokens
        self.name = name
        if num_of_direct_sub_groups is not None:
            self.num_of_direct_sub_groups = num_of_direct_sub_groups
        if num_of_dashboards is not None:
            self.num_of_dashboards = num_of_dashboards
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if dashboards is not None:
            self.dashboards = dashboards
        if parent_id is not None:
            self.parent_id = parent_id
        if num_of_direct_dashboards is not None:
            self.num_of_direct_dashboards = num_of_direct_dashboards

    @property
    def template(self):
        """Gets the template of this DashboardGroup.  # noqa: E501

        The template which is used for import dashboard group  # noqa: E501

        :return: The template of this DashboardGroup.  # noqa: E501
        :rtype: object
        """
        return self._template

    @template.setter
    def template(self, template):
        """Sets the template of this DashboardGroup.

        The template which is used for import dashboard group  # noqa: E501

        :param template: The template of this DashboardGroup.  # noqa: E501
        :type: object
        """

        self._template = template

    @property
    def full_path(self):
        """Gets the full_path of this DashboardGroup.  # noqa: E501

        The full path of the dashboard group  # noqa: E501

        :return: The full_path of this DashboardGroup.  # noqa: E501
        :rtype: str
        """
        return self._full_path

    @full_path.setter
    def full_path(self, full_path):
        """Sets the full_path of this DashboardGroup.

        The full path of the dashboard group  # noqa: E501

        :param full_path: The full_path of this DashboardGroup.  # noqa: E501
        :type: str
        """

        self._full_path = full_path

    @property
    def user_permission(self):
        """Gets the user_permission of this DashboardGroup.  # noqa: E501

        The permission of the user that made the API call  # noqa: E501

        :return: The user_permission of this DashboardGroup.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this DashboardGroup.

        The permission of the user that made the API call  # noqa: E501

        :param user_permission: The user_permission of this DashboardGroup.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def widget_tokens(self):
        """Gets the widget_tokens of this DashboardGroup.  # noqa: E501

        The tokens assigned at the group level  # noqa: E501

        :return: The widget_tokens of this DashboardGroup.  # noqa: E501
        :rtype: list[WidgetToken]
        """
        return self._widget_tokens

    @widget_tokens.setter
    def widget_tokens(self, widget_tokens):
        """Sets the widget_tokens of this DashboardGroup.

        The tokens assigned at the group level  # noqa: E501

        :param widget_tokens: The widget_tokens of this DashboardGroup.  # noqa: E501
        :type: list[WidgetToken]
        """

        self._widget_tokens = widget_tokens

    @property
    def name(self):
        """Gets the name of this DashboardGroup.  # noqa: E501

        The name of the dashboard group  # noqa: E501

        :return: The name of this DashboardGroup.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DashboardGroup.

        The name of the dashboard group  # noqa: E501

        :param name: The name of this DashboardGroup.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def num_of_direct_sub_groups(self):
        """Gets the num_of_direct_sub_groups of this DashboardGroup.  # noqa: E501

        The number of groups directly under the Dashboard Group  # noqa: E501

        :return: The num_of_direct_sub_groups of this DashboardGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_direct_sub_groups

    @num_of_direct_sub_groups.setter
    def num_of_direct_sub_groups(self, num_of_direct_sub_groups):
        """Sets the num_of_direct_sub_groups of this DashboardGroup.

        The number of groups directly under the Dashboard Group  # noqa: E501

        :param num_of_direct_sub_groups: The num_of_direct_sub_groups of this DashboardGroup.  # noqa: E501
        :type: int
        """

        self._num_of_direct_sub_groups = num_of_direct_sub_groups

    @property
    def num_of_dashboards(self):
        """Gets the num_of_dashboards of this DashboardGroup.  # noqa: E501

        The number of dashboards that belong to the Dashboard Group and any sub-groups  # noqa: E501

        :return: The num_of_dashboards of this DashboardGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_dashboards

    @num_of_dashboards.setter
    def num_of_dashboards(self, num_of_dashboards):
        """Sets the num_of_dashboards of this DashboardGroup.

        The number of dashboards that belong to the Dashboard Group and any sub-groups  # noqa: E501

        :param num_of_dashboards: The num_of_dashboards of this DashboardGroup.  # noqa: E501
        :type: int
        """

        self._num_of_dashboards = num_of_dashboards

    @property
    def description(self):
        """Gets the description of this DashboardGroup.  # noqa: E501

        This is a description of the dashboard group  # noqa: E501

        :return: The description of this DashboardGroup.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DashboardGroup.

        This is a description of the dashboard group  # noqa: E501

        :param description: The description of this DashboardGroup.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this DashboardGroup.  # noqa: E501

        The Id of the dashboard group   # noqa: E501

        :return: The id of this DashboardGroup.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DashboardGroup.

        The Id of the dashboard group   # noqa: E501

        :param id: The id of this DashboardGroup.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def dashboards(self):
        """Gets the dashboards of this DashboardGroup.  # noqa: E501

        The dashboards that belong to the group  # noqa: E501

        :return: The dashboards of this DashboardGroup.  # noqa: E501
        :rtype: list[DashboardData]
        """
        return self._dashboards

    @dashboards.setter
    def dashboards(self, dashboards):
        """Sets the dashboards of this DashboardGroup.

        The dashboards that belong to the group  # noqa: E501

        :param dashboards: The dashboards of this DashboardGroup.  # noqa: E501
        :type: list[DashboardData]
        """

        self._dashboards = dashboards

    @property
    def parent_id(self):
        """Gets the parent_id of this DashboardGroup.  # noqa: E501

        The Id of the parent dashboard group  # noqa: E501

        :return: The parent_id of this DashboardGroup.  # noqa: E501
        :rtype: int
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this DashboardGroup.

        The Id of the parent dashboard group  # noqa: E501

        :param parent_id: The parent_id of this DashboardGroup.  # noqa: E501
        :type: int
        """

        self._parent_id = parent_id

    @property
    def num_of_direct_dashboards(self):
        """Gets the num_of_direct_dashboards of this DashboardGroup.  # noqa: E501

        The number of dashboards that belong directly to the Dashboard Group  # noqa: E501

        :return: The num_of_direct_dashboards of this DashboardGroup.  # noqa: E501
        :rtype: int
        """
        return self._num_of_direct_dashboards

    @num_of_direct_dashboards.setter
    def num_of_direct_dashboards(self, num_of_direct_dashboards):
        """Sets the num_of_direct_dashboards of this DashboardGroup.

        The number of dashboards that belong directly to the Dashboard Group  # noqa: E501

        :param num_of_direct_dashboards: The num_of_direct_dashboards of this DashboardGroup.  # noqa: E501
        :type: int
        """

        self._num_of_direct_dashboards = num_of_direct_dashboards

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DashboardGroup, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DashboardGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
