# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.graph_display import GraphDisplay  # noqa: F401,E501


class CustomVirtualDataPoint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'rpn': 'str',
        'custom_graph_id': 'int',
        'display': 'GraphDisplay',
        'name': 'str',
        'id': 'int'
    }

    attribute_map = {
        'rpn': 'rpn',
        'custom_graph_id': 'customGraphId',
        'display': 'display',
        'name': 'name',
        'id': 'id'
    }

    def __init__(self, rpn=None, custom_graph_id=None, display=None, name=None, id=None):  # noqa: E501
        """CustomVirtualDataPoint - a model defined in Swagger"""  # noqa: E501

        self._rpn = None
        self._custom_graph_id = None
        self._display = None
        self._name = None
        self._id = None
        self.discriminator = None

        if rpn is not None:
            self.rpn = rpn
        if custom_graph_id is not None:
            self.custom_graph_id = custom_graph_id
        if display is not None:
            self.display = display
        if name is not None:
            self.name = name
        if id is not None:
            self.id = id

    @property
    def rpn(self):
        """Gets the rpn of this CustomVirtualDataPoint.  # noqa: E501


        :return: The rpn of this CustomVirtualDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._rpn

    @rpn.setter
    def rpn(self, rpn):
        """Sets the rpn of this CustomVirtualDataPoint.


        :param rpn: The rpn of this CustomVirtualDataPoint.  # noqa: E501
        :type: str
        """

        self._rpn = rpn

    @property
    def custom_graph_id(self):
        """Gets the custom_graph_id of this CustomVirtualDataPoint.  # noqa: E501


        :return: The custom_graph_id of this CustomVirtualDataPoint.  # noqa: E501
        :rtype: int
        """
        return self._custom_graph_id

    @custom_graph_id.setter
    def custom_graph_id(self, custom_graph_id):
        """Sets the custom_graph_id of this CustomVirtualDataPoint.


        :param custom_graph_id: The custom_graph_id of this CustomVirtualDataPoint.  # noqa: E501
        :type: int
        """

        self._custom_graph_id = custom_graph_id

    @property
    def display(self):
        """Gets the display of this CustomVirtualDataPoint.  # noqa: E501


        :return: The display of this CustomVirtualDataPoint.  # noqa: E501
        :rtype: GraphDisplay
        """
        return self._display

    @display.setter
    def display(self, display):
        """Sets the display of this CustomVirtualDataPoint.


        :param display: The display of this CustomVirtualDataPoint.  # noqa: E501
        :type: GraphDisplay
        """

        self._display = display

    @property
    def name(self):
        """Gets the name of this CustomVirtualDataPoint.  # noqa: E501


        :return: The name of this CustomVirtualDataPoint.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CustomVirtualDataPoint.


        :param name: The name of this CustomVirtualDataPoint.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def id(self):
        """Gets the id of this CustomVirtualDataPoint.  # noqa: E501


        :return: The id of this CustomVirtualDataPoint.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CustomVirtualDataPoint.


        :param id: The id of this CustomVirtualDataPoint.  # noqa: E501
        :type: int
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CustomVirtualDataPoint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CustomVirtualDataPoint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
