# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CollectorVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'stable': 'bool',
        'release_epoch': 'int',
        'has32bit_windows': 'bool',
        'has32bit_linux': 'bool',
        'major_version': 'int',
        'minor_version': 'int',
        'mandatory': 'bool'
    }

    attribute_map = {
        'stable': 'stable',
        'release_epoch': 'releaseEpoch',
        'has32bit_windows': 'has32bitWindows',
        'has32bit_linux': 'has32bitLinux',
        'major_version': 'majorVersion',
        'minor_version': 'minorVersion',
        'mandatory': 'mandatory'
    }

    def __init__(self, stable=None, release_epoch=None, has32bit_windows=None, has32bit_linux=None, major_version=None, minor_version=None, mandatory=None):  # noqa: E501
        """CollectorVersion - a model defined in Swagger"""  # noqa: E501

        self._stable = None
        self._release_epoch = None
        self._has32bit_windows = None
        self._has32bit_linux = None
        self._major_version = None
        self._minor_version = None
        self._mandatory = None
        self.discriminator = None

        if stable is not None:
            self.stable = stable
        if release_epoch is not None:
            self.release_epoch = release_epoch
        if has32bit_windows is not None:
            self.has32bit_windows = has32bit_windows
        if has32bit_linux is not None:
            self.has32bit_linux = has32bit_linux
        if major_version is not None:
            self.major_version = major_version
        if minor_version is not None:
            self.minor_version = minor_version
        if mandatory is not None:
            self.mandatory = mandatory

    @property
    def stable(self):
        """Gets the stable of this CollectorVersion.  # noqa: E501

        False for early release. True for general release  # noqa: E501

        :return: The stable of this CollectorVersion.  # noqa: E501
        :rtype: bool
        """
        return self._stable

    @stable.setter
    def stable(self, stable):
        """Sets the stable of this CollectorVersion.

        False for early release. True for general release  # noqa: E501

        :param stable: The stable of this CollectorVersion.  # noqa: E501
        :type: bool
        """

        self._stable = stable

    @property
    def release_epoch(self):
        """Gets the release_epoch of this CollectorVersion.  # noqa: E501

        Release Epoch for official releases  # noqa: E501

        :return: The release_epoch of this CollectorVersion.  # noqa: E501
        :rtype: int
        """
        return self._release_epoch

    @release_epoch.setter
    def release_epoch(self, release_epoch):
        """Sets the release_epoch of this CollectorVersion.

        Release Epoch for official releases  # noqa: E501

        :param release_epoch: The release_epoch of this CollectorVersion.  # noqa: E501
        :type: int
        """

        self._release_epoch = release_epoch

    @property
    def has32bit_windows(self):
        """Gets the has32bit_windows of this CollectorVersion.  # noqa: E501

        True if Windows collector available  # noqa: E501

        :return: The has32bit_windows of this CollectorVersion.  # noqa: E501
        :rtype: bool
        """
        return self._has32bit_windows

    @has32bit_windows.setter
    def has32bit_windows(self, has32bit_windows):
        """Sets the has32bit_windows of this CollectorVersion.

        True if Windows collector available  # noqa: E501

        :param has32bit_windows: The has32bit_windows of this CollectorVersion.  # noqa: E501
        :type: bool
        """

        self._has32bit_windows = has32bit_windows

    @property
    def has32bit_linux(self):
        """Gets the has32bit_linux of this CollectorVersion.  # noqa: E501

        True if Linux collector available  # noqa: E501

        :return: The has32bit_linux of this CollectorVersion.  # noqa: E501
        :rtype: bool
        """
        return self._has32bit_linux

    @has32bit_linux.setter
    def has32bit_linux(self, has32bit_linux):
        """Sets the has32bit_linux of this CollectorVersion.

        True if Linux collector available  # noqa: E501

        :param has32bit_linux: The has32bit_linux of this CollectorVersion.  # noqa: E501
        :type: bool
        """

        self._has32bit_linux = has32bit_linux

    @property
    def major_version(self):
        """Gets the major_version of this CollectorVersion.  # noqa: E501

        The collector major version  # noqa: E501

        :return: The major_version of this CollectorVersion.  # noqa: E501
        :rtype: int
        """
        return self._major_version

    @major_version.setter
    def major_version(self, major_version):
        """Sets the major_version of this CollectorVersion.

        The collector major version  # noqa: E501

        :param major_version: The major_version of this CollectorVersion.  # noqa: E501
        :type: int
        """

        self._major_version = major_version

    @property
    def minor_version(self):
        """Gets the minor_version of this CollectorVersion.  # noqa: E501

        The collector minor version  # noqa: E501

        :return: The minor_version of this CollectorVersion.  # noqa: E501
        :rtype: int
        """
        return self._minor_version

    @minor_version.setter
    def minor_version(self, minor_version):
        """Sets the minor_version of this CollectorVersion.

        The collector minor version  # noqa: E501

        :param minor_version: The minor_version of this CollectorVersion.  # noqa: E501
        :type: int
        """

        self._minor_version = minor_version

    @property
    def mandatory(self):
        """Gets the mandatory of this CollectorVersion.  # noqa: E501

        True if collector is a required release  # noqa: E501

        :return: The mandatory of this CollectorVersion.  # noqa: E501
        :rtype: bool
        """
        return self._mandatory

    @mandatory.setter
    def mandatory(self, mandatory):
        """Sets the mandatory of this CollectorVersion.

        True if collector is a required release  # noqa: E501

        :param mandatory: The mandatory of this CollectorVersion.  # noqa: E501
        :type: bool
        """

        self._mandatory = mandatory

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CollectorVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectorVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
