# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.automatic_upgrade_info import AutomaticUpgradeInfo  # noqa: F401,E501
from logicmonitor_sdk.models.name_and_value import NameAndValue  # noqa: F401,E501
from logicmonitor_sdk.models.next_upgrade_info import NextUpgradeInfo  # noqa: F401,E501
from logicmonitor_sdk.models.onetime_upgrade_info import OnetimeUpgradeInfo  # noqa: F401,E501


class CollectorBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'user_change_on': 'int',
        'conf_version': 'str',
        'updated_on_local': 'str',
        'hostname': 'str',
        'number_of_instances': 'int',
        'id': 'int',
        'ea': 'bool',
        'watchdog_updated_on_local': 'str',
        'has_fail_over_device': 'bool',
        'collector_group_name': 'str',
        'netscan_version': 'str',
        'in_sdt': 'bool',
        'updated_on': 'int',
        'automatic_upgrade_info': 'AutomaticUpgradeInfo',
        'number_of_hosts': 'int',
        'collector_conf': 'str',
        'sbproxy_conf': 'str',
        'last_sent_notification_on_local': 'str',
        'custom_properties': 'list[NameAndValue]',
        'predefined_config': 'object',
        'onetime_upgrade_info': 'OnetimeUpgradeInfo',
        'wrapper_conf': 'str',
        'clear_sent': 'bool',
        'status': 'int',
        'backup_agent_id': 'int',
        'specified_collector_device_group_id': 'int',
        'escalating_chain_id': 'int',
        'collector_size': 'str',
        'acked_on_local': 'str',
        'watchdog_conf': 'str',
        'description': 'str',
        'created_on': 'int',
        'platform': 'str',
        'is_down': 'bool',
        'user_visible_hosts_num': 'int',
        'can_downgrade': 'bool',
        'ack_comment': 'str',
        'next_upgrade_info': 'NextUpgradeInfo',
        'suppress_alert_clear': 'bool',
        'next_recipient': 'int',
        'acked_on': 'int',
        'user_change_on_local': 'str',
        'collector_device_id': 'int',
        'acked_by': 'str',
        'user_permission': 'str',
        'need_auto_create_collector_device': 'object',
        'watchdog_updated_on': 'int',
        'can_downgrade_reason': 'str',
        'last_sent_notification_on': 'int',
        'acked': 'bool',
        'onetime_downgrade_info': 'OnetimeUpgradeInfo',
        'up_time': 'int',
        'build': 'str',
        'previous_version': 'str',
        'collector_group_id': 'int',
        'created_on_local': 'str',
        'enable_fail_back': 'object',
        'resend_ival': 'int',
        'arch': 'str',
        'enable_fail_over_on_collector_device': 'bool'
    }

    attribute_map = {
        'user_change_on': 'userChangeOn',
        'conf_version': 'confVersion',
        'updated_on_local': 'updatedOnLocal',
        'hostname': 'hostname',
        'number_of_instances': 'numberOfInstances',
        'id': 'id',
        'ea': 'ea',
        'watchdog_updated_on_local': 'watchdogUpdatedOnLocal',
        'has_fail_over_device': 'hasFailOverDevice',
        'collector_group_name': 'collectorGroupName',
        'netscan_version': 'netscanVersion',
        'in_sdt': 'inSDT',
        'updated_on': 'updatedOn',
        'automatic_upgrade_info': 'automaticUpgradeInfo',
        'number_of_hosts': 'numberOfHosts',
        'collector_conf': 'collectorConf',
        'sbproxy_conf': 'sbproxyConf',
        'last_sent_notification_on_local': 'lastSentNotificationOnLocal',
        'custom_properties': 'customProperties',
        'predefined_config': 'predefinedConfig',
        'onetime_upgrade_info': 'onetimeUpgradeInfo',
        'wrapper_conf': 'wrapperConf',
        'clear_sent': 'clearSent',
        'status': 'status',
        'backup_agent_id': 'backupAgentId',
        'specified_collector_device_group_id': 'specifiedCollectorDeviceGroupId',
        'escalating_chain_id': 'escalatingChainId',
        'collector_size': 'collectorSize',
        'acked_on_local': 'ackedOnLocal',
        'watchdog_conf': 'watchdogConf',
        'description': 'description',
        'created_on': 'createdOn',
        'platform': 'platform',
        'is_down': 'isDown',
        'user_visible_hosts_num': 'userVisibleHostsNum',
        'can_downgrade': 'canDowngrade',
        'ack_comment': 'ackComment',
        'next_upgrade_info': 'nextUpgradeInfo',
        'suppress_alert_clear': 'suppressAlertClear',
        'next_recipient': 'nextRecipient',
        'acked_on': 'ackedOn',
        'user_change_on_local': 'userChangeOnLocal',
        'collector_device_id': 'collectorDeviceId',
        'acked_by': 'ackedBy',
        'user_permission': 'userPermission',
        'need_auto_create_collector_device': 'needAutoCreateCollectorDevice',
        'watchdog_updated_on': 'watchdogUpdatedOn',
        'can_downgrade_reason': 'canDowngradeReason',
        'last_sent_notification_on': 'lastSentNotificationOn',
        'acked': 'acked',
        'onetime_downgrade_info': 'onetimeDowngradeInfo',
        'up_time': 'upTime',
        'build': 'build',
        'previous_version': 'previousVersion',
        'collector_group_id': 'collectorGroupId',
        'created_on_local': 'createdOnLocal',
        'enable_fail_back': 'enableFailBack',
        'resend_ival': 'resendIval',
        'arch': 'arch',
        'enable_fail_over_on_collector_device': 'enableFailOverOnCollectorDevice'
    }

    def __init__(self, user_change_on=None, conf_version=None, updated_on_local=None, hostname=None, number_of_instances=None, id=None, ea=None, watchdog_updated_on_local=None, has_fail_over_device=None, collector_group_name=None, netscan_version=None, in_sdt=None, updated_on=None, automatic_upgrade_info=None, number_of_hosts=None, collector_conf=None, sbproxy_conf=None, last_sent_notification_on_local=None, custom_properties=None, predefined_config=None, onetime_upgrade_info=None, wrapper_conf=None, clear_sent=None, status=None, backup_agent_id=None, specified_collector_device_group_id=None, escalating_chain_id=None, collector_size=None, acked_on_local=None, watchdog_conf=None, description=None, created_on=None, platform=None, is_down=None, user_visible_hosts_num=None, can_downgrade=None, ack_comment=None, next_upgrade_info=None, suppress_alert_clear=None, next_recipient=None, acked_on=None, user_change_on_local=None, collector_device_id=None, acked_by=None, user_permission=None, need_auto_create_collector_device=None, watchdog_updated_on=None, can_downgrade_reason=None, last_sent_notification_on=None, acked=None, onetime_downgrade_info=None, up_time=None, build=None, previous_version=None, collector_group_id=None, created_on_local=None, enable_fail_back=None, resend_ival=None, arch=None, enable_fail_over_on_collector_device=None):  # noqa: E501
        """CollectorBase - a model defined in Swagger"""  # noqa: E501

        self._user_change_on = None
        self._conf_version = None
        self._updated_on_local = None
        self._hostname = None
        self._number_of_instances = None
        self._id = None
        self._ea = None
        self._watchdog_updated_on_local = None
        self._has_fail_over_device = None
        self._collector_group_name = None
        self._netscan_version = None
        self._in_sdt = None
        self._updated_on = None
        self._automatic_upgrade_info = None
        self._number_of_hosts = None
        self._collector_conf = None
        self._sbproxy_conf = None
        self._last_sent_notification_on_local = None
        self._custom_properties = None
        self._predefined_config = None
        self._onetime_upgrade_info = None
        self._wrapper_conf = None
        self._clear_sent = None
        self._status = None
        self._backup_agent_id = None
        self._specified_collector_device_group_id = None
        self._escalating_chain_id = None
        self._collector_size = None
        self._acked_on_local = None
        self._watchdog_conf = None
        self._description = None
        self._created_on = None
        self._platform = None
        self._is_down = None
        self._user_visible_hosts_num = None
        self._can_downgrade = None
        self._ack_comment = None
        self._next_upgrade_info = None
        self._suppress_alert_clear = None
        self._next_recipient = None
        self._acked_on = None
        self._user_change_on_local = None
        self._collector_device_id = None
        self._acked_by = None
        self._user_permission = None
        self._need_auto_create_collector_device = None
        self._watchdog_updated_on = None
        self._can_downgrade_reason = None
        self._last_sent_notification_on = None
        self._acked = None
        self._onetime_downgrade_info = None
        self._up_time = None
        self._build = None
        self._previous_version = None
        self._collector_group_id = None
        self._created_on_local = None
        self._enable_fail_back = None
        self._resend_ival = None
        self._arch = None
        self._enable_fail_over_on_collector_device = None
        self.discriminator = None

        if user_change_on is not None:
            self.user_change_on = user_change_on
        if conf_version is not None:
            self.conf_version = conf_version
        if updated_on_local is not None:
            self.updated_on_local = updated_on_local
        if hostname is not None:
            self.hostname = hostname
        if number_of_instances is not None:
            self.number_of_instances = number_of_instances
        if id is not None:
            self.id = id
        if ea is not None:
            self.ea = ea
        if watchdog_updated_on_local is not None:
            self.watchdog_updated_on_local = watchdog_updated_on_local
        if has_fail_over_device is not None:
            self.has_fail_over_device = has_fail_over_device
        if collector_group_name is not None:
            self.collector_group_name = collector_group_name
        if netscan_version is not None:
            self.netscan_version = netscan_version
        if in_sdt is not None:
            self.in_sdt = in_sdt
        if updated_on is not None:
            self.updated_on = updated_on
        if automatic_upgrade_info is not None:
            self.automatic_upgrade_info = automatic_upgrade_info
        if number_of_hosts is not None:
            self.number_of_hosts = number_of_hosts
        if collector_conf is not None:
            self.collector_conf = collector_conf
        if sbproxy_conf is not None:
            self.sbproxy_conf = sbproxy_conf
        if last_sent_notification_on_local is not None:
            self.last_sent_notification_on_local = last_sent_notification_on_local
        if custom_properties is not None:
            self.custom_properties = custom_properties
        if predefined_config is not None:
            self.predefined_config = predefined_config
        if onetime_upgrade_info is not None:
            self.onetime_upgrade_info = onetime_upgrade_info
        if wrapper_conf is not None:
            self.wrapper_conf = wrapper_conf
        if clear_sent is not None:
            self.clear_sent = clear_sent
        if status is not None:
            self.status = status
        if backup_agent_id is not None:
            self.backup_agent_id = backup_agent_id
        if specified_collector_device_group_id is not None:
            self.specified_collector_device_group_id = specified_collector_device_group_id
        if escalating_chain_id is not None:
            self.escalating_chain_id = escalating_chain_id
        if collector_size is not None:
            self.collector_size = collector_size
        if acked_on_local is not None:
            self.acked_on_local = acked_on_local
        if watchdog_conf is not None:
            self.watchdog_conf = watchdog_conf
        if description is not None:
            self.description = description
        if created_on is not None:
            self.created_on = created_on
        if platform is not None:
            self.platform = platform
        if is_down is not None:
            self.is_down = is_down
        if user_visible_hosts_num is not None:
            self.user_visible_hosts_num = user_visible_hosts_num
        if can_downgrade is not None:
            self.can_downgrade = can_downgrade
        if ack_comment is not None:
            self.ack_comment = ack_comment
        if next_upgrade_info is not None:
            self.next_upgrade_info = next_upgrade_info
        if suppress_alert_clear is not None:
            self.suppress_alert_clear = suppress_alert_clear
        if next_recipient is not None:
            self.next_recipient = next_recipient
        if acked_on is not None:
            self.acked_on = acked_on
        if user_change_on_local is not None:
            self.user_change_on_local = user_change_on_local
        if collector_device_id is not None:
            self.collector_device_id = collector_device_id
        if acked_by is not None:
            self.acked_by = acked_by
        if user_permission is not None:
            self.user_permission = user_permission
        if need_auto_create_collector_device is not None:
            self.need_auto_create_collector_device = need_auto_create_collector_device
        if watchdog_updated_on is not None:
            self.watchdog_updated_on = watchdog_updated_on
        if can_downgrade_reason is not None:
            self.can_downgrade_reason = can_downgrade_reason
        if last_sent_notification_on is not None:
            self.last_sent_notification_on = last_sent_notification_on
        if acked is not None:
            self.acked = acked
        if onetime_downgrade_info is not None:
            self.onetime_downgrade_info = onetime_downgrade_info
        if up_time is not None:
            self.up_time = up_time
        if build is not None:
            self.build = build
        if previous_version is not None:
            self.previous_version = previous_version
        if collector_group_id is not None:
            self.collector_group_id = collector_group_id
        if created_on_local is not None:
            self.created_on_local = created_on_local
        if enable_fail_back is not None:
            self.enable_fail_back = enable_fail_back
        if resend_ival is not None:
            self.resend_ival = resend_ival
        if arch is not None:
            self.arch = arch
        if enable_fail_over_on_collector_device is not None:
            self.enable_fail_over_on_collector_device = enable_fail_over_on_collector_device

    @property
    def user_change_on(self):
        """Gets the user_change_on of this CollectorBase.  # noqa: E501

        The last time the Collector was updated, in epoch format  # noqa: E501

        :return: The user_change_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._user_change_on

    @user_change_on.setter
    def user_change_on(self, user_change_on):
        """Sets the user_change_on of this CollectorBase.

        The last time the Collector was updated, in epoch format  # noqa: E501

        :param user_change_on: The user_change_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._user_change_on = user_change_on

    @property
    def conf_version(self):
        """Gets the conf_version of this CollectorBase.  # noqa: E501

        The version of the agent.conf configuration file  # noqa: E501

        :return: The conf_version of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._conf_version

    @conf_version.setter
    def conf_version(self, conf_version):
        """Sets the conf_version of this CollectorBase.

        The version of the agent.conf configuration file  # noqa: E501

        :param conf_version: The conf_version of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._conf_version = conf_version

    @property
    def updated_on_local(self):
        """Gets the updated_on_local of this CollectorBase.  # noqa: E501

        The time that the Collector was last updated, in local time format  # noqa: E501

        :return: The updated_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._updated_on_local

    @updated_on_local.setter
    def updated_on_local(self, updated_on_local):
        """Sets the updated_on_local of this CollectorBase.

        The time that the Collector was last updated, in local time format  # noqa: E501

        :param updated_on_local: The updated_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._updated_on_local = updated_on_local

    @property
    def hostname(self):
        """Gets the hostname of this CollectorBase.  # noqa: E501

        The hostname of the device the Collector is installed on  # noqa: E501

        :return: The hostname of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this CollectorBase.

        The hostname of the device the Collector is installed on  # noqa: E501

        :param hostname: The hostname of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def number_of_instances(self):
        """Gets the number_of_instances of this CollectorBase.  # noqa: E501


        :return: The number_of_instances of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._number_of_instances

    @number_of_instances.setter
    def number_of_instances(self, number_of_instances):
        """Sets the number_of_instances of this CollectorBase.


        :param number_of_instances: The number_of_instances of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._number_of_instances = number_of_instances

    @property
    def id(self):
        """Gets the id of this CollectorBase.  # noqa: E501

        The id of the Collector  # noqa: E501

        :return: The id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CollectorBase.

        The id of the Collector  # noqa: E501

        :param id: The id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def ea(self):
        """Gets the ea of this CollectorBase.  # noqa: E501

        Whether the collector is in EA version  # noqa: E501

        :return: The ea of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._ea

    @ea.setter
    def ea(self, ea):
        """Sets the ea of this CollectorBase.

        Whether the collector is in EA version  # noqa: E501

        :param ea: The ea of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._ea = ea

    @property
    def watchdog_updated_on_local(self):
        """Gets the watchdog_updated_on_local of this CollectorBase.  # noqa: E501

        The time that the Collector Watchdog was last updated, in local time format  # noqa: E501

        :return: The watchdog_updated_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._watchdog_updated_on_local

    @watchdog_updated_on_local.setter
    def watchdog_updated_on_local(self, watchdog_updated_on_local):
        """Sets the watchdog_updated_on_local of this CollectorBase.

        The time that the Collector Watchdog was last updated, in local time format  # noqa: E501

        :param watchdog_updated_on_local: The watchdog_updated_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._watchdog_updated_on_local = watchdog_updated_on_local

    @property
    def has_fail_over_device(self):
        """Gets the has_fail_over_device of this CollectorBase.  # noqa: E501

        Whether the collector has failover devices  # noqa: E501

        :return: The has_fail_over_device of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._has_fail_over_device

    @has_fail_over_device.setter
    def has_fail_over_device(self, has_fail_over_device):
        """Sets the has_fail_over_device of this CollectorBase.

        Whether the collector has failover devices  # noqa: E501

        :param has_fail_over_device: The has_fail_over_device of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._has_fail_over_device = has_fail_over_device

    @property
    def collector_group_name(self):
        """Gets the collector_group_name of this CollectorBase.  # noqa: E501

        The name of the group the Collector is in  # noqa: E501

        :return: The collector_group_name of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._collector_group_name

    @collector_group_name.setter
    def collector_group_name(self, collector_group_name):
        """Sets the collector_group_name of this CollectorBase.

        The name of the group the Collector is in  # noqa: E501

        :param collector_group_name: The collector_group_name of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._collector_group_name = collector_group_name

    @property
    def netscan_version(self):
        """Gets the netscan_version of this CollectorBase.  # noqa: E501

        The Netscan version associated with the Collector  # noqa: E501

        :return: The netscan_version of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._netscan_version

    @netscan_version.setter
    def netscan_version(self, netscan_version):
        """Sets the netscan_version of this CollectorBase.

        The Netscan version associated with the Collector  # noqa: E501

        :param netscan_version: The netscan_version of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._netscan_version = netscan_version

    @property
    def in_sdt(self):
        """Gets the in_sdt of this CollectorBase.  # noqa: E501

        The SDT status of the collector  # noqa: E501

        :return: The in_sdt of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._in_sdt

    @in_sdt.setter
    def in_sdt(self, in_sdt):
        """Sets the in_sdt of this CollectorBase.

        The SDT status of the collector  # noqa: E501

        :param in_sdt: The in_sdt of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._in_sdt = in_sdt

    @property
    def updated_on(self):
        """Gets the updated_on of this CollectorBase.  # noqa: E501

        The time that the Collector was last updated, in epoch format  # noqa: E501

        :return: The updated_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._updated_on

    @updated_on.setter
    def updated_on(self, updated_on):
        """Sets the updated_on of this CollectorBase.

        The time that the Collector was last updated, in epoch format  # noqa: E501

        :param updated_on: The updated_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._updated_on = updated_on

    @property
    def automatic_upgrade_info(self):
        """Gets the automatic_upgrade_info of this CollectorBase.  # noqa: E501

        The details of the Collector's automatic upgrade schedule, if one exists  # noqa: E501

        :return: The automatic_upgrade_info of this CollectorBase.  # noqa: E501
        :rtype: AutomaticUpgradeInfo
        """
        return self._automatic_upgrade_info

    @automatic_upgrade_info.setter
    def automatic_upgrade_info(self, automatic_upgrade_info):
        """Sets the automatic_upgrade_info of this CollectorBase.

        The details of the Collector's automatic upgrade schedule, if one exists  # noqa: E501

        :param automatic_upgrade_info: The automatic_upgrade_info of this CollectorBase.  # noqa: E501
        :type: AutomaticUpgradeInfo
        """

        self._automatic_upgrade_info = automatic_upgrade_info

    @property
    def number_of_hosts(self):
        """Gets the number_of_hosts of this CollectorBase.  # noqa: E501

        The number of devices monitored by the Collector  # noqa: E501

        :return: The number_of_hosts of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._number_of_hosts

    @number_of_hosts.setter
    def number_of_hosts(self, number_of_hosts):
        """Sets the number_of_hosts of this CollectorBase.

        The number of devices monitored by the Collector  # noqa: E501

        :param number_of_hosts: The number_of_hosts of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._number_of_hosts = number_of_hosts

    @property
    def collector_conf(self):
        """Gets the collector_conf of this CollectorBase.  # noqa: E501

        The Collector's configuration file  # noqa: E501

        :return: The collector_conf of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._collector_conf

    @collector_conf.setter
    def collector_conf(self, collector_conf):
        """Sets the collector_conf of this CollectorBase.

        The Collector's configuration file  # noqa: E501

        :param collector_conf: The collector_conf of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._collector_conf = collector_conf

    @property
    def sbproxy_conf(self):
        """Gets the sbproxy_conf of this CollectorBase.  # noqa: E501

        The Proxy's configuration  # noqa: E501

        :return: The sbproxy_conf of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._sbproxy_conf

    @sbproxy_conf.setter
    def sbproxy_conf(self, sbproxy_conf):
        """Sets the sbproxy_conf of this CollectorBase.

        The Proxy's configuration  # noqa: E501

        :param sbproxy_conf: The sbproxy_conf of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._sbproxy_conf = sbproxy_conf

    @property
    def last_sent_notification_on_local(self):
        """Gets the last_sent_notification_on_local of this CollectorBase.  # noqa: E501

        The time that a notification was last sent for this Collector, in local time format  # noqa: E501

        :return: The last_sent_notification_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._last_sent_notification_on_local

    @last_sent_notification_on_local.setter
    def last_sent_notification_on_local(self, last_sent_notification_on_local):
        """Sets the last_sent_notification_on_local of this CollectorBase.

        The time that a notification was last sent for this Collector, in local time format  # noqa: E501

        :param last_sent_notification_on_local: The last_sent_notification_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._last_sent_notification_on_local = last_sent_notification_on_local

    @property
    def custom_properties(self):
        """Gets the custom_properties of this CollectorBase.  # noqa: E501

        The custom properties defined for the Collector  # noqa: E501

        :return: The custom_properties of this CollectorBase.  # noqa: E501
        :rtype: list[NameAndValue]
        """
        return self._custom_properties

    @custom_properties.setter
    def custom_properties(self, custom_properties):
        """Sets the custom_properties of this CollectorBase.

        The custom properties defined for the Collector  # noqa: E501

        :param custom_properties: The custom_properties of this CollectorBase.  # noqa: E501
        :type: list[NameAndValue]
        """

        self._custom_properties = custom_properties

    @property
    def predefined_config(self):
        """Gets the predefined_config of this CollectorBase.  # noqa: E501

        Collector configurations  # noqa: E501

        :return: The predefined_config of this CollectorBase.  # noqa: E501
        :rtype: object
        """
        return self._predefined_config

    @predefined_config.setter
    def predefined_config(self, predefined_config):
        """Sets the predefined_config of this CollectorBase.

        Collector configurations  # noqa: E501

        :param predefined_config: The predefined_config of this CollectorBase.  # noqa: E501
        :type: object
        """

        self._predefined_config = predefined_config

    @property
    def onetime_upgrade_info(self):
        """Gets the onetime_upgrade_info of this CollectorBase.  # noqa: E501

        The details of the Collector's one time upgrade, if one has been scheduled  # noqa: E501

        :return: The onetime_upgrade_info of this CollectorBase.  # noqa: E501
        :rtype: OnetimeUpgradeInfo
        """
        return self._onetime_upgrade_info

    @onetime_upgrade_info.setter
    def onetime_upgrade_info(self, onetime_upgrade_info):
        """Sets the onetime_upgrade_info of this CollectorBase.

        The details of the Collector's one time upgrade, if one has been scheduled  # noqa: E501

        :param onetime_upgrade_info: The onetime_upgrade_info of this CollectorBase.  # noqa: E501
        :type: OnetimeUpgradeInfo
        """

        self._onetime_upgrade_info = onetime_upgrade_info

    @property
    def wrapper_conf(self):
        """Gets the wrapper_conf of this CollectorBase.  # noqa: E501

        The java service wrapper's configuration  # noqa: E501

        :return: The wrapper_conf of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._wrapper_conf

    @wrapper_conf.setter
    def wrapper_conf(self, wrapper_conf):
        """Sets the wrapper_conf of this CollectorBase.

        The java service wrapper's configuration  # noqa: E501

        :param wrapper_conf: The wrapper_conf of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._wrapper_conf = wrapper_conf

    @property
    def clear_sent(self):
        """Gets the clear_sent of this CollectorBase.  # noqa: E501

        Whether or not an alert clear notifcation has been sent for this Collector  # noqa: E501

        :return: The clear_sent of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._clear_sent

    @clear_sent.setter
    def clear_sent(self, clear_sent):
        """Sets the clear_sent of this CollectorBase.

        Whether or not an alert clear notifcation has been sent for this Collector  # noqa: E501

        :param clear_sent: The clear_sent of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._clear_sent = clear_sent

    @property
    def status(self):
        """Gets the status of this CollectorBase.  # noqa: E501

        The registration status of the Collector. Acceptable values are: 0= unregistered, 1= registered, 2= stopped, 3= suspended  # noqa: E501

        :return: The status of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CollectorBase.

        The registration status of the Collector. Acceptable values are: 0= unregistered, 1= registered, 2= stopped, 3= suspended  # noqa: E501

        :param status: The status of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._status = status

    @property
    def backup_agent_id(self):
        """Gets the backup_agent_id of this CollectorBase.  # noqa: E501

        The Id of the backup Collector assigned to the Collector  # noqa: E501

        :return: The backup_agent_id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._backup_agent_id

    @backup_agent_id.setter
    def backup_agent_id(self, backup_agent_id):
        """Sets the backup_agent_id of this CollectorBase.

        The Id of the backup Collector assigned to the Collector  # noqa: E501

        :param backup_agent_id: The backup_agent_id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._backup_agent_id = backup_agent_id

    @property
    def specified_collector_device_group_id(self):
        """Gets the specified_collector_device_group_id of this CollectorBase.  # noqa: E501

        The device group id when create a new collector device  # noqa: E501

        :return: The specified_collector_device_group_id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._specified_collector_device_group_id

    @specified_collector_device_group_id.setter
    def specified_collector_device_group_id(self, specified_collector_device_group_id):
        """Sets the specified_collector_device_group_id of this CollectorBase.

        The device group id when create a new collector device  # noqa: E501

        :param specified_collector_device_group_id: The specified_collector_device_group_id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._specified_collector_device_group_id = specified_collector_device_group_id

    @property
    def escalating_chain_id(self):
        """Gets the escalating_chain_id of this CollectorBase.  # noqa: E501

        The Id of the escalation chain associated with this Collector  # noqa: E501

        :return: The escalating_chain_id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._escalating_chain_id

    @escalating_chain_id.setter
    def escalating_chain_id(self, escalating_chain_id):
        """Sets the escalating_chain_id of this CollectorBase.

        The Id of the escalation chain associated with this Collector  # noqa: E501

        :param escalating_chain_id: The escalating_chain_id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._escalating_chain_id = escalating_chain_id

    @property
    def collector_size(self):
        """Gets the collector_size of this CollectorBase.  # noqa: E501

        The size of the collector  # noqa: E501

        :return: The collector_size of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._collector_size

    @collector_size.setter
    def collector_size(self, collector_size):
        """Sets the collector_size of this CollectorBase.

        The size of the collector  # noqa: E501

        :param collector_size: The collector_size of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._collector_size = collector_size

    @property
    def acked_on_local(self):
        """Gets the acked_on_local of this CollectorBase.  # noqa: E501

        The time that the Collector was acknowledged (if it is in alert), in local time format  # noqa: E501

        :return: The acked_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._acked_on_local

    @acked_on_local.setter
    def acked_on_local(self, acked_on_local):
        """Sets the acked_on_local of this CollectorBase.

        The time that the Collector was acknowledged (if it is in alert), in local time format  # noqa: E501

        :param acked_on_local: The acked_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._acked_on_local = acked_on_local

    @property
    def watchdog_conf(self):
        """Gets the watchdog_conf of this CollectorBase.  # noqa: E501

        The Watchdog's configuration  # noqa: E501

        :return: The watchdog_conf of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._watchdog_conf

    @watchdog_conf.setter
    def watchdog_conf(self, watchdog_conf):
        """Sets the watchdog_conf of this CollectorBase.

        The Watchdog's configuration  # noqa: E501

        :param watchdog_conf: The watchdog_conf of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._watchdog_conf = watchdog_conf

    @property
    def description(self):
        """Gets the description of this CollectorBase.  # noqa: E501

        The Collector's description  # noqa: E501

        :return: The description of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CollectorBase.

        The Collector's description  # noqa: E501

        :param description: The description of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def created_on(self):
        """Gets the created_on of this CollectorBase.  # noqa: E501

        The time that the Collector was created, in epoch format  # noqa: E501

        :return: The created_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this CollectorBase.

        The time that the Collector was created, in epoch format  # noqa: E501

        :param created_on: The created_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def platform(self):
        """Gets the platform of this CollectorBase.  # noqa: E501

        The OS of the Collector device (e.g. Linux, Windows)  # noqa: E501

        :return: The platform of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this CollectorBase.

        The OS of the Collector device (e.g. Linux, Windows)  # noqa: E501

        :param platform: The platform of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._platform = platform

    @property
    def is_down(self):
        """Gets the is_down of this CollectorBase.  # noqa: E501

        Whether or not the Collector is currently down  # noqa: E501

        :return: The is_down of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._is_down

    @is_down.setter
    def is_down(self, is_down):
        """Sets the is_down of this CollectorBase.

        Whether or not the Collector is currently down  # noqa: E501

        :param is_down: The is_down of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._is_down = is_down

    @property
    def user_visible_hosts_num(self):
        """Gets the user_visible_hosts_num of this CollectorBase.  # noqa: E501

        The number of devices monitored by the Collector and visible to the user that made the query  # noqa: E501

        :return: The user_visible_hosts_num of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._user_visible_hosts_num

    @user_visible_hosts_num.setter
    def user_visible_hosts_num(self, user_visible_hosts_num):
        """Sets the user_visible_hosts_num of this CollectorBase.

        The number of devices monitored by the Collector and visible to the user that made the query  # noqa: E501

        :param user_visible_hosts_num: The user_visible_hosts_num of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._user_visible_hosts_num = user_visible_hosts_num

    @property
    def can_downgrade(self):
        """Gets the can_downgrade of this CollectorBase.  # noqa: E501

        Whether the collector can be downgraded to a lower version  # noqa: E501

        :return: The can_downgrade of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._can_downgrade

    @can_downgrade.setter
    def can_downgrade(self, can_downgrade):
        """Sets the can_downgrade of this CollectorBase.

        Whether the collector can be downgraded to a lower version  # noqa: E501

        :param can_downgrade: The can_downgrade of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._can_downgrade = can_downgrade

    @property
    def ack_comment(self):
        """Gets the ack_comment of this CollectorBase.  # noqa: E501

        The comment associated with the Collector acknowledgement (if it is in alert and acknowledged)  # noqa: E501

        :return: The ack_comment of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._ack_comment

    @ack_comment.setter
    def ack_comment(self, ack_comment):
        """Sets the ack_comment of this CollectorBase.

        The comment associated with the Collector acknowledgement (if it is in alert and acknowledged)  # noqa: E501

        :param ack_comment: The ack_comment of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._ack_comment = ack_comment

    @property
    def next_upgrade_info(self):
        """Gets the next_upgrade_info of this CollectorBase.  # noqa: E501

        The details of the Collector's next upgrade, if one has been scheduled  # noqa: E501

        :return: The next_upgrade_info of this CollectorBase.  # noqa: E501
        :rtype: NextUpgradeInfo
        """
        return self._next_upgrade_info

    @next_upgrade_info.setter
    def next_upgrade_info(self, next_upgrade_info):
        """Sets the next_upgrade_info of this CollectorBase.

        The details of the Collector's next upgrade, if one has been scheduled  # noqa: E501

        :param next_upgrade_info: The next_upgrade_info of this CollectorBase.  # noqa: E501
        :type: NextUpgradeInfo
        """

        self._next_upgrade_info = next_upgrade_info

    @property
    def suppress_alert_clear(self):
        """Gets the suppress_alert_clear of this CollectorBase.  # noqa: E501

        Whether alert clear notifications are suppressed for the Collector  # noqa: E501

        :return: The suppress_alert_clear of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._suppress_alert_clear

    @suppress_alert_clear.setter
    def suppress_alert_clear(self, suppress_alert_clear):
        """Sets the suppress_alert_clear of this CollectorBase.

        Whether alert clear notifications are suppressed for the Collector  # noqa: E501

        :param suppress_alert_clear: The suppress_alert_clear of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._suppress_alert_clear = suppress_alert_clear

    @property
    def next_recipient(self):
        """Gets the next_recipient of this CollectorBase.  # noqa: E501

        The Id of the next recipient to which alert notifications will be sent  # noqa: E501

        :return: The next_recipient of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._next_recipient

    @next_recipient.setter
    def next_recipient(self, next_recipient):
        """Sets the next_recipient of this CollectorBase.

        The Id of the next recipient to which alert notifications will be sent  # noqa: E501

        :param next_recipient: The next_recipient of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._next_recipient = next_recipient

    @property
    def acked_on(self):
        """Gets the acked_on of this CollectorBase.  # noqa: E501

        The epoch at which the Collector was acknowledged (if it is in alert)  # noqa: E501

        :return: The acked_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._acked_on

    @acked_on.setter
    def acked_on(self, acked_on):
        """Sets the acked_on of this CollectorBase.

        The epoch at which the Collector was acknowledged (if it is in alert)  # noqa: E501

        :param acked_on: The acked_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._acked_on = acked_on

    @property
    def user_change_on_local(self):
        """Gets the user_change_on_local of this CollectorBase.  # noqa: E501

        The last time the Collector was updated, in the account time zone  # noqa: E501

        :return: The user_change_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._user_change_on_local

    @user_change_on_local.setter
    def user_change_on_local(self, user_change_on_local):
        """Sets the user_change_on_local of this CollectorBase.

        The last time the Collector was updated, in the account time zone  # noqa: E501

        :param user_change_on_local: The user_change_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._user_change_on_local = user_change_on_local

    @property
    def collector_device_id(self):
        """Gets the collector_device_id of this CollectorBase.  # noqa: E501

        The device id of the collector device  # noqa: E501

        :return: The collector_device_id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._collector_device_id

    @collector_device_id.setter
    def collector_device_id(self, collector_device_id):
        """Sets the collector_device_id of this CollectorBase.

        The device id of the collector device  # noqa: E501

        :param collector_device_id: The collector_device_id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._collector_device_id = collector_device_id

    @property
    def acked_by(self):
        """Gets the acked_by of this CollectorBase.  # noqa: E501

        The user that acknowledged the Collector (if it is in alert)  # noqa: E501

        :return: The acked_by of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._acked_by

    @acked_by.setter
    def acked_by(self, acked_by):
        """Sets the acked_by of this CollectorBase.

        The user that acknowledged the Collector (if it is in alert)  # noqa: E501

        :param acked_by: The acked_by of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._acked_by = acked_by

    @property
    def user_permission(self):
        """Gets the user_permission of this CollectorBase.  # noqa: E501

        The permission level of the user that made the API request to get Collector information  # noqa: E501

        :return: The user_permission of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._user_permission

    @user_permission.setter
    def user_permission(self, user_permission):
        """Sets the user_permission of this CollectorBase.

        The permission level of the user that made the API request to get Collector information  # noqa: E501

        :param user_permission: The user_permission of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._user_permission = user_permission

    @property
    def need_auto_create_collector_device(self):
        """Gets the need_auto_create_collector_device of this CollectorBase.  # noqa: E501

        Whether to create a collector device when instance collector, the default value is true  # noqa: E501

        :return: The need_auto_create_collector_device of this CollectorBase.  # noqa: E501
        :rtype: object
        """
        return self._need_auto_create_collector_device

    @need_auto_create_collector_device.setter
    def need_auto_create_collector_device(self, need_auto_create_collector_device):
        """Sets the need_auto_create_collector_device of this CollectorBase.

        Whether to create a collector device when instance collector, the default value is true  # noqa: E501

        :param need_auto_create_collector_device: The need_auto_create_collector_device of this CollectorBase.  # noqa: E501
        :type: object
        """

        self._need_auto_create_collector_device = need_auto_create_collector_device

    @property
    def watchdog_updated_on(self):
        """Gets the watchdog_updated_on of this CollectorBase.  # noqa: E501

        The time that the Watchdog Services was last updated, in epoch format  # noqa: E501

        :return: The watchdog_updated_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._watchdog_updated_on

    @watchdog_updated_on.setter
    def watchdog_updated_on(self, watchdog_updated_on):
        """Sets the watchdog_updated_on of this CollectorBase.

        The time that the Watchdog Services was last updated, in epoch format  # noqa: E501

        :param watchdog_updated_on: The watchdog_updated_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._watchdog_updated_on = watchdog_updated_on

    @property
    def can_downgrade_reason(self):
        """Gets the can_downgrade_reason of this CollectorBase.  # noqa: E501

        The reason why the collector can be downgraded  # noqa: E501

        :return: The can_downgrade_reason of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._can_downgrade_reason

    @can_downgrade_reason.setter
    def can_downgrade_reason(self, can_downgrade_reason):
        """Sets the can_downgrade_reason of this CollectorBase.

        The reason why the collector can be downgraded  # noqa: E501

        :param can_downgrade_reason: The can_downgrade_reason of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._can_downgrade_reason = can_downgrade_reason

    @property
    def last_sent_notification_on(self):
        """Gets the last_sent_notification_on of this CollectorBase.  # noqa: E501

        The time, in epoch format, that a notification was last sent for the Collector  # noqa: E501

        :return: The last_sent_notification_on of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._last_sent_notification_on

    @last_sent_notification_on.setter
    def last_sent_notification_on(self, last_sent_notification_on):
        """Sets the last_sent_notification_on of this CollectorBase.

        The time, in epoch format, that a notification was last sent for the Collector  # noqa: E501

        :param last_sent_notification_on: The last_sent_notification_on of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._last_sent_notification_on = last_sent_notification_on

    @property
    def acked(self):
        """Gets the acked of this CollectorBase.  # noqa: E501

        Whether or not the Collector is currently acknowledged  # noqa: E501

        :return: The acked of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._acked

    @acked.setter
    def acked(self, acked):
        """Sets the acked of this CollectorBase.

        Whether or not the Collector is currently acknowledged  # noqa: E501

        :param acked: The acked of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._acked = acked

    @property
    def onetime_downgrade_info(self):
        """Gets the onetime_downgrade_info of this CollectorBase.  # noqa: E501

        The details of the Collector's automatic downgrade schedule, if one exists  # noqa: E501

        :return: The onetime_downgrade_info of this CollectorBase.  # noqa: E501
        :rtype: OnetimeUpgradeInfo
        """
        return self._onetime_downgrade_info

    @onetime_downgrade_info.setter
    def onetime_downgrade_info(self, onetime_downgrade_info):
        """Sets the onetime_downgrade_info of this CollectorBase.

        The details of the Collector's automatic downgrade schedule, if one exists  # noqa: E501

        :param onetime_downgrade_info: The onetime_downgrade_info of this CollectorBase.  # noqa: E501
        :type: OnetimeUpgradeInfo
        """

        self._onetime_downgrade_info = onetime_downgrade_info

    @property
    def up_time(self):
        """Gets the up_time of this CollectorBase.  # noqa: E501

        The time the Collector has been up, in seconds  # noqa: E501

        :return: The up_time of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._up_time

    @up_time.setter
    def up_time(self, up_time):
        """Sets the up_time of this CollectorBase.

        The time the Collector has been up, in seconds  # noqa: E501

        :param up_time: The up_time of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._up_time = up_time

    @property
    def build(self):
        """Gets the build of this CollectorBase.  # noqa: E501

        The Collector version  # noqa: E501

        :return: The build of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._build

    @build.setter
    def build(self, build):
        """Sets the build of this CollectorBase.

        The Collector version  # noqa: E501

        :param build: The build of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._build = build

    @property
    def previous_version(self):
        """Gets the previous_version of this CollectorBase.  # noqa: E501

        The previous version of the collector, used for downgrading  # noqa: E501

        :return: The previous_version of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._previous_version

    @previous_version.setter
    def previous_version(self, previous_version):
        """Sets the previous_version of this CollectorBase.

        The previous version of the collector, used for downgrading  # noqa: E501

        :param previous_version: The previous_version of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._previous_version = previous_version

    @property
    def collector_group_id(self):
        """Gets the collector_group_id of this CollectorBase.  # noqa: E501

        The Id of the group the Collector is in  # noqa: E501

        :return: The collector_group_id of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._collector_group_id

    @collector_group_id.setter
    def collector_group_id(self, collector_group_id):
        """Sets the collector_group_id of this CollectorBase.

        The Id of the group the Collector is in  # noqa: E501

        :param collector_group_id: The collector_group_id of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._collector_group_id = collector_group_id

    @property
    def created_on_local(self):
        """Gets the created_on_local of this CollectorBase.  # noqa: E501

        The time that the Collector was created, in local time format  # noqa: E501

        :return: The created_on_local of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._created_on_local

    @created_on_local.setter
    def created_on_local(self, created_on_local):
        """Sets the created_on_local of this CollectorBase.

        The time that the Collector was created, in local time format  # noqa: E501

        :param created_on_local: The created_on_local of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._created_on_local = created_on_local

    @property
    def enable_fail_back(self):
        """Gets the enable_fail_back of this CollectorBase.  # noqa: E501

        Whether or not automatic failback is enabled for the Collector, the default value is true  # noqa: E501

        :return: The enable_fail_back of this CollectorBase.  # noqa: E501
        :rtype: object
        """
        return self._enable_fail_back

    @enable_fail_back.setter
    def enable_fail_back(self, enable_fail_back):
        """Sets the enable_fail_back of this CollectorBase.

        Whether or not automatic failback is enabled for the Collector, the default value is true  # noqa: E501

        :param enable_fail_back: The enable_fail_back of this CollectorBase.  # noqa: E501
        :type: object
        """

        self._enable_fail_back = enable_fail_back

    @property
    def resend_ival(self):
        """Gets the resend_ival of this CollectorBase.  # noqa: E501

        The interval, in minutes, after which alert notifications for the Collector will be resent  # noqa: E501

        :return: The resend_ival of this CollectorBase.  # noqa: E501
        :rtype: int
        """
        return self._resend_ival

    @resend_ival.setter
    def resend_ival(self, resend_ival):
        """Sets the resend_ival of this CollectorBase.

        The interval, in minutes, after which alert notifications for the Collector will be resent  # noqa: E501

        :param resend_ival: The resend_ival of this CollectorBase.  # noqa: E501
        :type: int
        """

        self._resend_ival = resend_ival

    @property
    def arch(self):
        """Gets the arch of this CollectorBase.  # noqa: E501

        The collector architecture (Windows | Linux platform followed by 32 | 64 bit)  # noqa: E501

        :return: The arch of this CollectorBase.  # noqa: E501
        :rtype: str
        """
        return self._arch

    @arch.setter
    def arch(self, arch):
        """Sets the arch of this CollectorBase.

        The collector architecture (Windows | Linux platform followed by 32 | 64 bit)  # noqa: E501

        :param arch: The arch of this CollectorBase.  # noqa: E501
        :type: str
        """

        self._arch = arch

    @property
    def enable_fail_over_on_collector_device(self):
        """Gets the enable_fail_over_on_collector_device of this CollectorBase.  # noqa: E501

        Whether or not the device the Collector is installed on is enabled for fail over  # noqa: E501

        :return: The enable_fail_over_on_collector_device of this CollectorBase.  # noqa: E501
        :rtype: bool
        """
        return self._enable_fail_over_on_collector_device

    @enable_fail_over_on_collector_device.setter
    def enable_fail_over_on_collector_device(self, enable_fail_over_on_collector_device):
        """Sets the enable_fail_over_on_collector_device of this CollectorBase.

        Whether or not the device the Collector is installed on is enabled for fail over  # noqa: E501

        :param enable_fail_over_on_collector_device: The enable_fail_over_on_collector_device of this CollectorBase.  # noqa: E501
        :type: bool
        """

        self._enable_fail_over_on_collector_device = enable_fail_over_on_collector_device

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CollectorBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectorBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
