# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CollectorAttribute(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str'
    }

    attribute_map = {
        'name': 'name'
    }

    discriminator_value_class_map = {
        'webpage': 'WebPageCollectorAttribute',
        '': 'AggregateCollectorAttribute',
        'tcp': 'TCPCollectorAttribute',
        'awsbilling': 'AwsBillingCollectorAttribute',
        'awsclassicelbservicelimits': 'AwsClassicElbServiceLimitsCollectorAttribute',
        'dns': 'DNSCollectorAttribute',
        'jdbc': 'JDBCCollectorAttribute',
        'udp': 'UDPCollectorAttribute',
        'cim': 'CIMCollectorAttribute',
        'awss3': 'AwsS3CollectorAttribute',
        'awsecsservicedetails': 'AwsEcsServiceDetailsCollectorAttribute',
        'batchscript': 'BatchScriptCollectorAttribute',
        'awsec2reservedinstancecoverage': 'AwsEC2ReservedInstanceCoverageCollectorAttribute',
        '': 'GcpComputeServiceLimitsCollectorAttributeV2',
        'awsservicelimitsfromtrustedadvisor': 'AwsServiceLimitsFromTrustedAdvisorCollectorAttribute',
        'awsdynamodb': 'AwsDynamodbCollectorAttribute',
        'internal': 'InternalCollectorAttribute',
        'netapp': 'NetAppCollectorAttribute',
        'xen': 'XENCollectorAttribute',
        'mongo': 'MongoCollectorAttribute',
        'azureresourcehealth': 'AzureResourceHealthCollectorAttribute',
        'ipmi': 'IPMICollectorAttribute',
        '': 'GcpStackDriverCollectorAttributeV2',
        'sdkscript': 'SDKScriptCollectorAttribute',
        'awsbillingreport': 'AwsBillingReportCollectorAttribute',
        'azurebilling': 'AzureBillingCollectorAttribute',
        'awsec2scheduledevents': 'AwsEC2ScheduledEventsCollectorAttribute',
        'ping': 'PingCollectorAttribute',
        'azurevmservicelimits': 'AzureVMServiceLimitsCollectorAttribute',
        'azurenetworkservicelimits': 'AzureNetworkServiceLimitsCollectorAttribute',
        'awssqs': 'AwsSqsCollectorAttribute',
        'awsec2reservedinstance': 'AwsEC2ReservedInstanceCollectorAttribute',
        'jmx': 'JMXCollectorAttribute',
        'awsec2servicelimits': 'AwsEc2ServiceLimitsCollectorAttribute',
        'wmi': 'WMICollectorAttribute',
        'datapump': 'DataPumpCollectorAttribute',
        'snmp': 'SNMPCollectorAttribute',
        'memcached': 'MemcachedCollectorAttribute',
        'perfmon': 'PerfmonCollectorAttribute',
        '': 'GcpBillingCollectorAttributeV2',
        'awscloudwatch': 'AwsCloudWatchCollectorAttribute',
        'awsautoscalingservicelimits': 'AwsAutoScalingServiceLimitsCollectorAttribute',
        'esx': 'ESXCollectorAttribute',
        'script': 'ScriptCollectorAttribute',
        'azurestorageservicelimits': 'AzureStorageServiceLimitsCollectorAttribute',
        '': 'OpenMetricCollectorAttributeV2',
        'awssesservicelimits': 'AwsSesServiceLimitsCollectorAttribute',
        'azureinsights': 'AzureInsightsCollectorAttribute'
    }

    def __init__(self, name=None):  # noqa: E501
        """CollectorAttribute - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self.discriminator = 'name'

        self.name = name

    @property
    def name(self):
        """Gets the name of this CollectorAttribute.  # noqa: E501


        :return: The name of this CollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CollectorAttribute.


        :param name: The name of this CollectorAttribute.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CollectorAttribute, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectorAttribute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
