# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.days_until_alert import DaysUntilAlert  # noqa: F401,E501


class CellData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alert_status': 'str',
        'forecast_day': 'int',
        'instance_id': 'int',
        'instance_name': 'str',
        'alert_severity': 'str',
        'days_until_alert_list': 'list[DaysUntilAlert]',
        'value': 'float'
    }

    attribute_map = {
        'alert_status': 'alertStatus',
        'forecast_day': 'forecastDay',
        'instance_id': 'instanceId',
        'instance_name': 'instanceName',
        'alert_severity': 'alertSeverity',
        'days_until_alert_list': 'daysUntilAlertList',
        'value': 'value'
    }

    def __init__(self, alert_status=None, forecast_day=None, instance_id=None, instance_name=None, alert_severity=None, days_until_alert_list=None, value=None):  # noqa: E501
        """CellData - a model defined in Swagger"""  # noqa: E501

        self._alert_status = None
        self._forecast_day = None
        self._instance_id = None
        self._instance_name = None
        self._alert_severity = None
        self._days_until_alert_list = None
        self._value = None
        self.discriminator = None

        if alert_status is not None:
            self.alert_status = alert_status
        if forecast_day is not None:
            self.forecast_day = forecast_day
        if instance_id is not None:
            self.instance_id = instance_id
        if instance_name is not None:
            self.instance_name = instance_name
        if alert_severity is not None:
            self.alert_severity = alert_severity
        if days_until_alert_list is not None:
            self.days_until_alert_list = days_until_alert_list
        if value is not None:
            self.value = value

    @property
    def alert_status(self):
        """Gets the alert_status of this CellData.  # noqa: E501


        :return: The alert_status of this CellData.  # noqa: E501
        :rtype: str
        """
        return self._alert_status

    @alert_status.setter
    def alert_status(self, alert_status):
        """Sets the alert_status of this CellData.


        :param alert_status: The alert_status of this CellData.  # noqa: E501
        :type: str
        """

        self._alert_status = alert_status

    @property
    def forecast_day(self):
        """Gets the forecast_day of this CellData.  # noqa: E501


        :return: The forecast_day of this CellData.  # noqa: E501
        :rtype: int
        """
        return self._forecast_day

    @forecast_day.setter
    def forecast_day(self, forecast_day):
        """Sets the forecast_day of this CellData.


        :param forecast_day: The forecast_day of this CellData.  # noqa: E501
        :type: int
        """

        self._forecast_day = forecast_day

    @property
    def instance_id(self):
        """Gets the instance_id of this CellData.  # noqa: E501


        :return: The instance_id of this CellData.  # noqa: E501
        :rtype: int
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """Sets the instance_id of this CellData.


        :param instance_id: The instance_id of this CellData.  # noqa: E501
        :type: int
        """

        self._instance_id = instance_id

    @property
    def instance_name(self):
        """Gets the instance_name of this CellData.  # noqa: E501


        :return: The instance_name of this CellData.  # noqa: E501
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """Sets the instance_name of this CellData.


        :param instance_name: The instance_name of this CellData.  # noqa: E501
        :type: str
        """

        self._instance_name = instance_name

    @property
    def alert_severity(self):
        """Gets the alert_severity of this CellData.  # noqa: E501


        :return: The alert_severity of this CellData.  # noqa: E501
        :rtype: str
        """
        return self._alert_severity

    @alert_severity.setter
    def alert_severity(self, alert_severity):
        """Sets the alert_severity of this CellData.


        :param alert_severity: The alert_severity of this CellData.  # noqa: E501
        :type: str
        """

        self._alert_severity = alert_severity

    @property
    def days_until_alert_list(self):
        """Gets the days_until_alert_list of this CellData.  # noqa: E501


        :return: The days_until_alert_list of this CellData.  # noqa: E501
        :rtype: list[DaysUntilAlert]
        """
        return self._days_until_alert_list

    @days_until_alert_list.setter
    def days_until_alert_list(self, days_until_alert_list):
        """Sets the days_until_alert_list of this CellData.


        :param days_until_alert_list: The days_until_alert_list of this CellData.  # noqa: E501
        :type: list[DaysUntilAlert]
        """

        self._days_until_alert_list = days_until_alert_list

    @property
    def value(self):
        """Gets the value of this CellData.  # noqa: E501


        :return: The value of this CellData.  # noqa: E501
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this CellData.


        :param value: The value of this CellData.  # noqa: E501
        :type: float
        """

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CellData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CellData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
