# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.color_threshold import ColorThreshold  # noqa: F401,E501


class BigNumberItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'data_point_name': 'str',
        'use_comma_separators': 'bool',
        'bottom_label': 'str',
        'rounding': 'int',
        'position': 'int',
        'right_label': 'str',
        'color_thresholds': 'list[ColorThreshold]'
    }

    attribute_map = {
        'data_point_name': 'dataPointName',
        'use_comma_separators': 'useCommaSeparators',
        'bottom_label': 'bottomLabel',
        'rounding': 'rounding',
        'position': 'position',
        'right_label': 'rightLabel',
        'color_thresholds': 'colorThresholds'
    }

    def __init__(self, data_point_name=None, use_comma_separators=None, bottom_label=None, rounding=None, position=None, right_label=None, color_thresholds=None):  # noqa: E501
        """BigNumberItem - a model defined in Swagger"""  # noqa: E501

        self._data_point_name = None
        self._use_comma_separators = None
        self._bottom_label = None
        self._rounding = None
        self._position = None
        self._right_label = None
        self._color_thresholds = None
        self.discriminator = None

        self.data_point_name = data_point_name
        self.use_comma_separators = use_comma_separators
        if bottom_label is not None:
            self.bottom_label = bottom_label
        if rounding is not None:
            self.rounding = rounding
        if position is not None:
            self.position = position
        if right_label is not None:
            self.right_label = right_label
        if color_thresholds is not None:
            self.color_thresholds = color_thresholds

    @property
    def data_point_name(self):
        """Gets the data_point_name of this BigNumberItem.  # noqa: E501


        :return: The data_point_name of this BigNumberItem.  # noqa: E501
        :rtype: str
        """
        return self._data_point_name

    @data_point_name.setter
    def data_point_name(self, data_point_name):
        """Sets the data_point_name of this BigNumberItem.


        :param data_point_name: The data_point_name of this BigNumberItem.  # noqa: E501
        :type: str
        """
        if data_point_name is None:
            raise ValueError("Invalid value for `data_point_name`, must not be `None`")  # noqa: E501

        self._data_point_name = data_point_name

    @property
    def use_comma_separators(self):
        """Gets the use_comma_separators of this BigNumberItem.  # noqa: E501


        :return: The use_comma_separators of this BigNumberItem.  # noqa: E501
        :rtype: bool
        """
        return self._use_comma_separators

    @use_comma_separators.setter
    def use_comma_separators(self, use_comma_separators):
        """Sets the use_comma_separators of this BigNumberItem.


        :param use_comma_separators: The use_comma_separators of this BigNumberItem.  # noqa: E501
        :type: bool
        """
        if use_comma_separators is None:
            raise ValueError("Invalid value for `use_comma_separators`, must not be `None`")  # noqa: E501

        self._use_comma_separators = use_comma_separators

    @property
    def bottom_label(self):
        """Gets the bottom_label of this BigNumberItem.  # noqa: E501


        :return: The bottom_label of this BigNumberItem.  # noqa: E501
        :rtype: str
        """
        return self._bottom_label

    @bottom_label.setter
    def bottom_label(self, bottom_label):
        """Sets the bottom_label of this BigNumberItem.


        :param bottom_label: The bottom_label of this BigNumberItem.  # noqa: E501
        :type: str
        """

        self._bottom_label = bottom_label

    @property
    def rounding(self):
        """Gets the rounding of this BigNumberItem.  # noqa: E501


        :return: The rounding of this BigNumberItem.  # noqa: E501
        :rtype: int
        """
        return self._rounding

    @rounding.setter
    def rounding(self, rounding):
        """Sets the rounding of this BigNumberItem.


        :param rounding: The rounding of this BigNumberItem.  # noqa: E501
        :type: int
        """

        self._rounding = rounding

    @property
    def position(self):
        """Gets the position of this BigNumberItem.  # noqa: E501


        :return: The position of this BigNumberItem.  # noqa: E501
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """Sets the position of this BigNumberItem.


        :param position: The position of this BigNumberItem.  # noqa: E501
        :type: int
        """

        self._position = position

    @property
    def right_label(self):
        """Gets the right_label of this BigNumberItem.  # noqa: E501


        :return: The right_label of this BigNumberItem.  # noqa: E501
        :rtype: str
        """
        return self._right_label

    @right_label.setter
    def right_label(self, right_label):
        """Sets the right_label of this BigNumberItem.


        :param right_label: The right_label of this BigNumberItem.  # noqa: E501
        :type: str
        """

        self._right_label = right_label

    @property
    def color_thresholds(self):
        """Gets the color_thresholds of this BigNumberItem.  # noqa: E501


        :return: The color_thresholds of this BigNumberItem.  # noqa: E501
        :rtype: list[ColorThreshold]
        """
        return self._color_thresholds

    @color_thresholds.setter
    def color_thresholds(self, color_thresholds):
        """Sets the color_thresholds of this BigNumberItem.


        :param color_thresholds: The color_thresholds of this BigNumberItem.  # noqa: E501
        :type: list[ColorThreshold]
        """

        self._color_thresholds = color_thresholds

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BigNumberItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BigNumberItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
